/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.microsoft;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public class MicrosoftGraphAuthzRealmSettings {
    public static final String REALM_TYPE = "microsoft_graph";
    public static final Setting.AffixSetting<String> CLIENT_ID = RealmSettings.simpleString((String)"microsoft_graph", (String)"client_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting.AffixSetting<SecureString> CLIENT_SECRET = RealmSettings.secureString((String)"microsoft_graph", (String)"client_secret");
    public static final Setting.AffixSetting<String> TENANT_ID = RealmSettings.simpleString((String)"microsoft_graph", (String)"tenant_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting.AffixSetting<String> ACCESS_TOKEN_HOST = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix((String)"microsoft_graph"), (String)"access_token_host", key -> Setting.simpleString((String)key, (String)"https://login.microsoftonline.com", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> API_HOST = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix((String)"microsoft_graph"), (String)"graph_host", key -> Setting.simpleString((String)key, (String)"https://graph.microsoft.com/v1.0", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_REQUEST_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix((String)"microsoft_graph"), (String)"http_request_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> EXECUTION_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix((String)"microsoft_graph"), (String)"execution_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);

    public static List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList(RealmSettings.getStandardSettings((String)REALM_TYPE));
        settings.add((Setting<?>)CLIENT_ID);
        settings.add((Setting<?>)CLIENT_SECRET);
        settings.add((Setting<?>)TENANT_ID);
        settings.add((Setting<?>)ACCESS_TOKEN_HOST);
        settings.add((Setting<?>)API_HOST);
        settings.add((Setting<?>)HTTP_REQUEST_TIMEOUT);
        settings.add((Setting<?>)EXECUTION_TIMEOUT);
        return settings;
    }
}

