/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.middleware.ObservabilityHelper;
import com.microsoft.kiota.http.middleware.options.RedirectHandlerOption;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RedirectHandler
implements Interceptor {
    @Nonnull
    private final RedirectHandlerOption mRedirectOption;

    public RedirectHandler() {
        this(null);
    }

    public RedirectHandler(@Nullable RedirectHandlerOption redirectOption) {
        this.mRedirectOption = redirectOption == null ? new RedirectHandlerOption() : redirectOption;
    }

    boolean isRedirected(@Nonnull Request request, @Nonnull Response response, int redirectCount, @Nonnull RedirectHandlerOption redirectOption) throws IOException {
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(response, "parameter response cannot be null");
        Objects.requireNonNull(redirectOption, "parameter redirectOption cannot be null");
        if (redirectCount > redirectOption.maxRedirects()) {
            return false;
        }
        String locationHeader = response.header("location");
        if (locationHeader == null) {
            return false;
        }
        int statusCode = response.code();
        return statusCode == 308 || statusCode == 301 || statusCode == 307 || statusCode == 303 || statusCode == 302;
    }

    Request getRedirect(Request request, Response userResponse) throws ProtocolException {
        String location = userResponse.header("Location");
        if (location == null || location.length() == 0) {
            return null;
        }
        if (location.startsWith("/")) {
            if (request.url().toString().endsWith("/")) {
                location = location.substring(1);
            }
            location = request.url() + location;
        }
        HttpUrl requestUrl = userResponse.request().url();
        HttpUrl locationUrl = userResponse.request().url().resolve(location);
        if (locationUrl == null) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        boolean sameScheme = locationUrl.scheme().equalsIgnoreCase(requestUrl.scheme());
        boolean sameHost = locationUrl.host().toString().equalsIgnoreCase(requestUrl.host().toString());
        if (!sameScheme || !sameHost) {
            requestBuilder.removeHeader("Authorization");
        }
        if (userResponse.code() == 303) {
            requestBuilder.method("GET", null);
        }
        return requestBuilder.url(locationUrl).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Objects.requireNonNull(chain, "parameter chain cannot be null");
        Request request = chain.request();
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Response response = null;
        int requestsCount = 1;
        boolean shouldRedirect = true;
        RedirectHandlerOption redirectOption = (RedirectHandlerOption)request.tag(RedirectHandlerOption.class);
        redirectOption = redirectOption != null ? redirectOption : this.mRedirectOption;
        Span span = ObservabilityHelper.getSpanForRequest(request, "RedirectHandler_Intercept");
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.redirect.enable", true);
        }
        try {
            do {
                Request followup;
                if (span != null && (request = request.newBuilder().tag(Span.class, (Object)span).build()) == null) {
                    throw new IllegalArgumentException("request cannot be null");
                }
                response = chain.proceed(request);
                if (response == null) {
                    throw new IllegalArgumentException("response cannot be null");
                }
                shouldRedirect = this.isRedirected(request, response, requestsCount, redirectOption) && redirectOption.shouldRedirect().shouldRedirect(response);
                Request request2 = followup = shouldRedirect ? this.getRedirect(request, response) : null;
                if (followup == null) continue;
                response.close();
                request = followup;
                Span redirectSpan = ObservabilityHelper.getSpanForRequest(request, "RedirectHandler_Intercept - redirect " + ++requestsCount, span);
                redirectSpan.setAttribute("com.microsoft.kiota.handler.redirect.count", (long)requestsCount);
                redirectSpan.setAttribute("http.status_code", (long)response.code());
                redirectSpan.end();
            } while (shouldRedirect);
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
        return response;
    }
}

