/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.rest.serializer.JacksonAdapter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@Beta(value=Beta.SinceVersion.V1_1_0)
final class AuthFile {
    private String clientId;
    private String tenantId;
    private String clientSecret;
    private String clientCertificate;
    private String clientCertificatePassword;
    private String subscriptionId;
    @JsonIgnore
    private AzureEnvironment environment = new AzureEnvironment(new HashMap());
    @JsonIgnore
    private static final JacksonAdapter ADAPTER = new JacksonAdapter();
    @JsonIgnore
    private String authFilePath;

    private AuthFile() {
        this.environment.endpoints().putAll(AzureEnvironment.AZURE.endpoints());
    }

    static AuthFile parse(File file) throws IOException {
        AuthFile authFile;
        String content = Files.toString((File)file, (Charset)Charsets.UTF_8).trim();
        if (AuthFile.isJsonBased(content)) {
            authFile = (AuthFile)ADAPTER.deserialize(content, AuthFile.class);
            Map endpoints = (Map)ADAPTER.deserialize(content, new TypeToken<Map<String, String>>(){}.getType());
            authFile.environment.endpoints().putAll(endpoints);
        } else {
            Properties authSettings = new Properties();
            authSettings.put(CredentialSettings.AUTH_URL.toString(), AzureEnvironment.AZURE.activeDirectoryEndpoint());
            authSettings.put(CredentialSettings.BASE_URL.toString(), AzureEnvironment.AZURE.resourceManagerEndpoint());
            authSettings.put(CredentialSettings.MANAGEMENT_URI.toString(), AzureEnvironment.AZURE.managementEndpoint());
            authSettings.put(CredentialSettings.GRAPH_URL.toString(), AzureEnvironment.AZURE.graphEndpoint());
            authSettings.put(CredentialSettings.VAULT_SUFFIX.toString(), AzureEnvironment.AZURE.keyVaultDnsSuffix());
            StringReader credentialsReader = new StringReader(content);
            authSettings.load(credentialsReader);
            credentialsReader.close();
            authFile = new AuthFile();
            authFile.clientId = authSettings.getProperty(CredentialSettings.CLIENT_ID.toString());
            authFile.tenantId = authSettings.getProperty(CredentialSettings.TENANT_ID.toString());
            authFile.clientSecret = authSettings.getProperty(CredentialSettings.CLIENT_KEY.toString());
            authFile.clientCertificate = authSettings.getProperty(CredentialSettings.CLIENT_CERT.toString());
            authFile.clientCertificatePassword = authSettings.getProperty(CredentialSettings.CLIENT_CERT_PASS.toString());
            authFile.subscriptionId = authSettings.getProperty(CredentialSettings.SUBSCRIPTION_ID.toString());
            authFile.environment.endpoints().put(AzureEnvironment.Endpoint.MANAGEMENT.identifier(), authSettings.getProperty(CredentialSettings.MANAGEMENT_URI.toString()));
            authFile.environment.endpoints().put(AzureEnvironment.Endpoint.ACTIVE_DIRECTORY.identifier(), authSettings.getProperty(CredentialSettings.AUTH_URL.toString()));
            authFile.environment.endpoints().put(AzureEnvironment.Endpoint.RESOURCE_MANAGER.identifier(), authSettings.getProperty(CredentialSettings.BASE_URL.toString()));
            authFile.environment.endpoints().put(AzureEnvironment.Endpoint.GRAPH.identifier(), authSettings.getProperty(CredentialSettings.GRAPH_URL.toString()));
            authFile.environment.endpoints().put(AzureEnvironment.Endpoint.KEYVAULT.identifier(), authSettings.getProperty(CredentialSettings.VAULT_SUFFIX.toString()));
        }
        authFile.authFilePath = file.getParent();
        return authFile;
    }

    private static boolean isJsonBased(String content) {
        return content.startsWith("{");
    }

    ApplicationTokenCredentials generateCredentials() throws IOException {
        if (this.clientSecret != null) {
            return (ApplicationTokenCredentials)new ApplicationTokenCredentials(this.clientId, this.tenantId, this.clientSecret, this.environment).withDefaultSubscriptionId(this.subscriptionId);
        }
        if (this.clientCertificate != null) {
            byte[] certData = new File(this.clientCertificate).exists() ? Files.toByteArray((File)new File(this.clientCertificate)) : Files.toByteArray((File)new File(this.authFilePath, this.clientCertificate));
            return (ApplicationTokenCredentials)new ApplicationTokenCredentials(this.clientId, this.tenantId, certData, this.clientCertificatePassword, this.environment).withDefaultSubscriptionId(this.subscriptionId);
        }
        throw new IllegalArgumentException("Please specify either a client key or a client certificate.");
    }

    private static enum CredentialSettings {
        SUBSCRIPTION_ID("subscription"),
        TENANT_ID("tenant"),
        CLIENT_ID("client"),
        CLIENT_KEY("key"),
        CLIENT_CERT("certificate"),
        CLIENT_CERT_PASS("certificatePassword"),
        MANAGEMENT_URI("managementURI"),
        BASE_URL("baseURL"),
        AUTH_URL("authURL"),
        GRAPH_URL("graphURL"),
        VAULT_SUFFIX("vaultSuffix");

        private final String name;

        private CredentialSettings(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

