/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.h3.H3;
import org.elasticsearch.xpack.spatial.common.H3CartesianUtil;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoHexVisitor;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public abstract class GeoHexGridTiler
extends GeoGridTiler {
    private static final long[] RES0CELLS = H3.getLongRes0Cells();

    private GeoHexGridTiler(int precision) {
        super(precision);
    }

    public static GeoHexGridTiler makeGridTiler(int precision, GeoBoundingBox geoBoundingBox) {
        return geoBoundingBox == null || geoBoundingBox.isUnbounded() ? new UnboundedGeoHexGridTiler(precision) : new BoundedGeoHexGridTiler(precision, geoBoundingBox);
    }

    protected abstract boolean h3IntersectsBounds(long var1);

    protected abstract GeoRelation relateTile(GeoShapeValues.GeoShapeValue var1, long var2) throws IOException;

    protected abstract boolean valueInsideBounds(GeoShapeValues.GeoShapeValue var1) throws IOException;

    @Override
    public long encode(double x, double y) {
        throw new IllegalArgumentException("no supported");
    }

    @Override
    public int setValues(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        long singleCell;
        ShapeValues.BoundingBox bounds = geoValue.boundingBox();
        assert (bounds.minX() <= bounds.maxX());
        if (bounds.maxX() - bounds.minX() < 180.0 && (singleCell = this.boundsInSameCell(bounds, this.precision)) > 0L) {
            return this.setValuesFromPointResolution(singleCell, values, geoValue);
        }
        return this.setValuesByRecursion(values, geoValue, bounds);
    }

    private int setValuesFromPointResolution(long h3, GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        int valueIndex = 0;
        GeoRelation relation = this.relateTile(geoValue, h3);
        valueIndex = this.maybeAdd(h3, relation, values, valueIndex);
        if (relation == GeoRelation.QUERY_CONTAINS) {
            return valueIndex;
        }
        int ringSize = H3.hexRingSize((long)h3);
        for (int i = 0; i < ringSize; ++i) {
            long n = H3.hexRingPosToH3((long)h3, (int)i);
            GeoRelation relation2 = this.relateTile(geoValue, n);
            valueIndex = this.maybeAdd(n, relation2, values, valueIndex);
            if (relation2 != GeoRelation.QUERY_CONTAINS) continue;
            return valueIndex;
        }
        return valueIndex;
    }

    private long boundsInSameCell(ShapeValues.BoundingBox bounds, int res) {
        long maxH3;
        long minH3 = H3.geoToH3((double)bounds.minY(), (double)bounds.minX(), (int)res);
        if (minH3 != (maxH3 = H3.geoToH3((double)bounds.maxY(), (double)bounds.maxX(), (int)res))) {
            return -1L;
        }
        if (H3CartesianUtil.isPolar(minH3)) {
            long minMax = H3.geoToH3((double)bounds.minY(), (double)bounds.maxX(), (int)res);
            long maxMin = H3.geoToH3((double)bounds.maxY(), (double)bounds.minX(), (int)res);
            if (minMax != minH3 || maxMin != minH3) {
                return -1L;
            }
        }
        return minH3;
    }

    private int maybeAdd(long h3, GeoRelation relation, GeoShapeCellValues values, int valueIndex) {
        if (relation != GeoRelation.QUERY_DISJOINT) {
            values.resizeCell(valueIndex + 1);
            values.add(valueIndex++, h3);
        }
        return valueIndex;
    }

    int setValuesByRecursion(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue, ShapeValues.BoundingBox bounds) throws IOException {
        long singleCell;
        int valueIndex = 0;
        if (bounds.maxX() - bounds.minX() < 180.0 && (singleCell = this.boundsInSameCell(bounds, 0)) > 0L) {
            valueIndex = this.setValuesByRecursion(values, geoValue, singleCell, 0, valueIndex);
            int ringSize = H3.hexRingSize((long)singleCell);
            for (int i = 0; i < ringSize; ++i) {
                valueIndex = this.setValuesByRecursion(values, geoValue, H3.hexRingPosToH3((long)singleCell, (int)i), 0, valueIndex);
            }
            return valueIndex;
        }
        for (long h3 : RES0CELLS) {
            valueIndex = this.setValuesByRecursion(values, geoValue, h3, 0, valueIndex);
        }
        return valueIndex;
    }

    private int setValuesByRecursion(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue, long h3, int precision, int valueIndex) throws IOException {
        assert (H3.getResolution((long)h3) == precision);
        GeoRelation relation = this.relateTile(geoValue, h3);
        if (precision == this.precision) {
            return this.maybeAdd(h3, relation, values, valueIndex);
        }
        assert (precision < this.precision);
        if (relation != GeoRelation.QUERY_DISJOINT) {
            int i = 0;
            if (relation == GeoRelation.QUERY_INSIDE) {
                long centerChild = H3.childPosToH3((long)h3, (int)i++);
                valueIndex = this.setAllValuesByRecursion(values, centerChild, precision + 1, valueIndex, this.valueInsideBounds(geoValue));
            }
            int numChildren = H3.h3ToChildrenSize((long)h3);
            while (i < numChildren) {
                long child = H3.childPosToH3((long)h3, (int)i);
                valueIndex = this.setValuesByRecursion(values, geoValue, child, precision + 1, valueIndex);
                ++i;
            }
            int numNoChildren = H3.h3ToNotIntersectingChildrenSize((long)h3);
            for (int j = 0; j < numNoChildren; ++j) {
                long noChild = H3.noChildIntersectingPosToH3((long)h3, (int)j);
                if (this.relateTile(geoValue, H3.h3ToParent((long)noChild)) != GeoRelation.QUERY_DISJOINT) continue;
                valueIndex = this.setValuesByRecursion(values, geoValue, noChild, precision + 1, valueIndex);
            }
        }
        return valueIndex;
    }

    private int setAllValuesByRecursion(GeoShapeCellValues values, long h3, int precision, int valueIndex, boolean valueInsideBounds) {
        if (valueInsideBounds || this.h3IntersectsBounds(h3)) {
            if (precision == this.precision) {
                values.resizeCell(valueIndex + 1);
                values.add(valueIndex++, h3);
            } else {
                int numChildren = H3.h3ToChildrenSize((long)h3);
                for (int i = 0; i < numChildren; ++i) {
                    valueIndex = this.setAllValuesByRecursion(values, H3.childPosToH3((long)h3, (int)i), precision + 1, valueIndex, valueInsideBounds);
                }
            }
        }
        return valueIndex;
    }

    static long calcMaxAddresses(int precision) {
        int baseHexagons = 110;
        int basePentagons = 12;
        return 110L * (long)Math.pow(7.0, precision) + 12L * (long)Math.pow(6.0, precision);
    }

    private static class UnboundedGeoHexGridTiler
    extends GeoHexGridTiler {
        private final long maxAddresses;
        private final GeoHexVisitor visitor = new GeoHexVisitor();

        UnboundedGeoHexGridTiler(int precision) {
            super(precision);
            this.maxAddresses = UnboundedGeoHexGridTiler.calcMaxAddresses(precision);
        }

        @Override
        protected boolean h3IntersectsBounds(long h3) {
            return true;
        }

        @Override
        protected GeoRelation relateTile(GeoShapeValues.GeoShapeValue geoValue, long h3) throws IOException {
            this.visitor.reset(h3);
            int resolution = H3.getResolution((long)h3);
            if (resolution != this.precision && (this.visitor.getMaxY() > H3CartesianUtil.getNorthPolarBound(resolution) || this.visitor.getMinY() < H3CartesianUtil.getSouthPolarBound(resolution))) {
                return GeoRelation.QUERY_CROSSES;
            }
            geoValue.visit(this.visitor);
            return this.visitor.relation();
        }

        @Override
        protected boolean valueInsideBounds(GeoShapeValues.GeoShapeValue geoValue) {
            return true;
        }

        @Override
        protected long getMaxCells() {
            return this.maxAddresses;
        }
    }

    static class BoundedGeoHexGridTiler
    extends GeoHexGridTiler {
        private final GeoBoundingBox[] inflatedBboxes;
        private final GeoBoundingBox bbox;
        private final GeoHexVisitor visitor;
        private final int resolution;
        private static final double FACTOR = 0.37;

        BoundedGeoHexGridTiler(int resolution, GeoBoundingBox bbox) {
            super(resolution);
            this.bbox = bbox;
            this.visitor = new GeoHexVisitor();
            this.resolution = resolution;
            this.inflatedBboxes = new GeoBoundingBox[resolution];
            for (int i = 0; i < resolution; ++i) {
                this.inflatedBboxes[i] = BoundedGeoHexGridTiler.inflateBbox(i, bbox, 0.37);
            }
        }

        static GeoBoundingBox inflateBbox(int precision, GeoBoundingBox bbox, double factor) {
            Rectangle minMin = H3CartesianUtil.toBoundingBox(H3.geoToH3((double)bbox.bottom(), (double)bbox.left(), (int)precision));
            Rectangle maxMax = H3CartesianUtil.toBoundingBox(H3.geoToH3((double)bbox.top(), (double)bbox.right(), (int)precision));
            double height = Math.max(BoundedGeoHexGridTiler.height(minMin), BoundedGeoHexGridTiler.height(maxMax));
            double width = Math.max(BoundedGeoHexGridTiler.width(minMin), BoundedGeoHexGridTiler.width(maxMax));
            double minY = Math.max(bbox.bottom() - factor * height, -90.0);
            double maxY = Math.min(bbox.top() + factor * height, 90.0);
            double left = GeoUtils.normalizeLon(bbox.left() - factor * width);
            double right = GeoUtils.normalizeLon(bbox.right() + factor * width);
            if (2.0 * factor * width + BoundedGeoHexGridTiler.width(bbox) >= 360.0) {
                return new GeoBoundingBox(new GeoPoint(maxY, -180.0), new GeoPoint(minY, 180.0));
            }
            return new GeoBoundingBox(new GeoPoint(maxY, left), new GeoPoint(minY, right));
        }

        static double height(Rectangle rectangle) {
            return rectangle.getMaxY() - rectangle.getMinY();
        }

        static double width(Rectangle rectangle) {
            if (rectangle.getMinX() > rectangle.getMaxX()) {
                return 360.0 + rectangle.getMaxX() - rectangle.getMinX();
            }
            return rectangle.getMaxX() - rectangle.getMinX();
        }

        static double width(GeoBoundingBox bbox) {
            if (bbox.left() > bbox.right()) {
                return 360.0 + bbox.right() - bbox.left();
            }
            return bbox.right() - bbox.left();
        }

        @Override
        protected long getMaxCells() {
            return UnboundedGeoHexGridTiler.calcMaxAddresses(this.resolution);
        }

        @Override
        protected boolean h3IntersectsBounds(long h3) {
            this.visitor.reset(h3);
            int resolution = H3.getResolution((long)h3);
            if (resolution != this.resolution) {
                assert (resolution < this.resolution);
                return BoundedGeoHexGridTiler.cellIntersectsBounds(this.visitor, this.inflatedBboxes[resolution]);
            }
            return BoundedGeoHexGridTiler.cellIntersectsBounds(this.visitor, this.bbox);
        }

        @Override
        protected GeoRelation relateTile(GeoShapeValues.GeoShapeValue geoValue, long h3) throws IOException {
            this.visitor.reset(h3);
            int resolution = H3.getResolution((long)h3);
            if (resolution != this.resolution) {
                assert (resolution < this.resolution);
                if (BoundedGeoHexGridTiler.cellIntersectsBounds(this.visitor, this.inflatedBboxes[resolution])) {
                    if (this.visitor.getMaxY() > H3CartesianUtil.getNorthPolarBound(resolution) || this.visitor.getMinY() < H3CartesianUtil.getSouthPolarBound(resolution)) {
                        return GeoRelation.QUERY_CROSSES;
                    }
                    geoValue.visit(this.visitor);
                    return this.visitor.relation();
                }
                return GeoRelation.QUERY_DISJOINT;
            }
            if (BoundedGeoHexGridTiler.cellIntersectsBounds(this.visitor, this.bbox)) {
                geoValue.visit(this.visitor);
                return this.visitor.relation();
            }
            return GeoRelation.QUERY_DISJOINT;
        }

        @Override
        protected boolean valueInsideBounds(GeoShapeValues.GeoShapeValue geoValue) {
            if (this.bbox.bottom() <= geoValue.boundingBox().minY() && this.bbox.top() >= geoValue.boundingBox().maxY()) {
                if (this.bbox.right() < this.bbox.left()) {
                    return this.bbox.left() <= geoValue.boundingBox().minX() || this.bbox.right() >= geoValue.boundingBox().maxX();
                }
                return this.bbox.left() <= geoValue.boundingBox().minX() && this.bbox.right() >= geoValue.boundingBox().maxX();
            }
            return false;
        }

        private static boolean cellIntersectsBounds(GeoHexVisitor visitor, GeoBoundingBox bbox) {
            return visitor.intersectsBbox(bbox.left(), bbox.right(), bbox.bottom(), bbox.top());
        }
    }
}

