/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RawInferenceResults
implements InferenceResults {
    public static final String NAME = "raw";
    private final double[] value;
    private final double[][] featureImportance;

    public RawInferenceResults(double[] value, double[][] featureImportance) {
        this.value = value;
        this.featureImportance = featureImportance;
    }

    public double[] getValue() {
        return this.value;
    }

    public double[][] getFeatureImportance() {
        return this.featureImportance;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("[raw] does not support wire serialization");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RawInferenceResults that = (RawInferenceResults)object;
        return Arrays.equals(this.value, that.value) && Arrays.deepEquals((Object[])this.featureImportance, (Object[])that.featureImportance);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.value), Arrays.deepHashCode((Object[])this.featureImportance));
    }

    @Override
    public String getResultsField() {
        return "predicted_value";
    }

    @Override
    public Map<String, Object> asMap() {
        throw new UnsupportedOperationException("[raw] does not support map conversion");
    }

    @Override
    public Map<String, Object> asMap(String outputField) {
        throw new UnsupportedOperationException("[raw] does not support map conversion");
    }

    @Override
    public Object predictedValue() {
        return null;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        throw new UnsupportedOperationException("[raw] does not support toXContent");
    }
}

