/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class BooleanFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = BooleanFieldScript.newContext("boolean_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = new Factory(){

        @Override
        public LeafFactory newFactory(String field, Map<String, Object> params, SearchLookup lookup, OnScriptError onScriptError) {
            return ctx -> new BooleanFieldScript(this, field, params, lookup, OnScriptError.FAIL, ctx){

                @Override
                public void execute() {
                    this.emitFromSource();
                }
            };
        }

        @Override
        public boolean isResultDeterministic() {
            return true;
        }

        @Override
        public boolean isParsedFromSource() {
            return true;
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private int trues;
    private int falses;

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup, onScriptError) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new BooleanFieldScript(leafFieldName, params, searchLookup, onScriptError, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public BooleanFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx, onScriptError);
    }

    @Override
    protected void prepareExecute() {
        this.trues = 0;
        this.falses = 0;
    }

    public final void runForDoc(int docId, Consumer<Boolean> consumer) {
        this.runForDoc(docId);
        int count = this.trues + this.falses;
        for (int i = 0; i < count; ++i) {
            consumer.accept(i >= this.falses);
        }
    }

    public final int trues() {
        return this.trues;
    }

    public final int falses() {
        return this.falses;
    }

    @Override
    protected final void emitFromObject(Object v) {
        if (v instanceof Boolean) {
            this.emit((Boolean)v);
        } else if (v instanceof String) {
            try {
                this.emit(Booleans.parseBoolean((String)v));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public final void emit(boolean v) {
        if (v) {
            ++this.trues;
        } else {
            ++this.falses;
        }
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3, OnScriptError var4);
    }

    public static interface LeafFactory {
        public BooleanFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Emit {
        private final BooleanFieldScript script;

        public Emit(BooleanFieldScript script) {
            this.script = script;
        }

        public void value(boolean v) {
            this.script.emit(v);
        }
    }
}

