/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class MethodWriter
extends GeneratorAdapter {
    private final BitSet statements;
    private final CompilerSettings settings;
    private final Deque<List<Type>> stringConcatArgs = new ArrayDeque<List<Type>>();

    public MethodWriter(int access, Method method, ClassVisitor cw, BitSet statements, CompilerSettings settings) {
        super(327680, cw.visitMethod(access, method.getName(), method.getDescriptor(), null, null), access, method.getName(), method.getDescriptor());
        this.statements = statements;
        this.settings = settings;
    }

    public void writeStatementOffset(Location location) {
        int offset = location.getOffset();
        this.statements.set(offset);
    }

    public void writeDebugInfo(Location location) {
        Label label = new Label();
        this.visitLabel(label);
        this.visitLineNumber(location.getOffset() + 1, label);
    }

    public void writeLoopCounter(int slot, Location location) {
        assert (slot != -1);
        this.writeDebugInfo(location);
        Label end = new Label();
        this.iinc(slot, -1);
        this.visitVarInsn(21, slot);
        this.push(0);
        this.ifICmp(157, end);
        this.throwException(WriterConstants.PAINLESS_ERROR_TYPE, "The maximum number of statements that can be executed in a loop has been reached.");
        this.mark(end);
    }

    public void writeCast(PainlessCast cast) {
        if (cast == null) {
            return;
        }
        if (cast.originalType == Character.TYPE && cast.targetType == String.class) {
            this.invokeStatic(WriterConstants.UTILITY_TYPE, WriterConstants.CHAR_TO_STRING);
        } else if (cast.originalType == String.class && cast.targetType == Character.TYPE) {
            this.invokeStatic(WriterConstants.UTILITY_TYPE, WriterConstants.STRING_TO_CHAR);
        } else if (cast.unboxOriginalType != null && cast.boxTargetType != null) {
            this.unbox(MethodWriter.getType(cast.unboxOriginalType));
            this.writeCast(cast.unboxOriginalType, cast.boxTargetType);
            this.box(MethodWriter.getType(cast.boxTargetType));
        } else if (cast.unboxOriginalType != null) {
            this.unbox(MethodWriter.getType(cast.unboxOriginalType));
            this.writeCast(cast.originalType, cast.targetType);
        } else if (cast.unboxTargetType != null) {
            this.writeCast(cast.originalType, cast.targetType);
            this.unbox(MethodWriter.getType(cast.unboxTargetType));
        } else if (cast.boxOriginalType != null) {
            this.box(MethodWriter.getType(cast.boxOriginalType));
            this.writeCast(cast.originalType, cast.targetType);
        } else if (cast.boxTargetType != null) {
            this.writeCast(cast.originalType, cast.targetType);
            this.box(MethodWriter.getType(cast.boxTargetType));
        } else if (cast.originalType == def.class) {
            if (cast.explicitCast) {
                if (cast.targetType == Boolean.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_BOOLEAN);
                } else if (cast.targetType == Byte.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_BYTE_EXPLICIT);
                } else if (cast.targetType == Short.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_SHORT_EXPLICIT);
                } else if (cast.targetType == Character.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_CHAR_EXPLICIT);
                } else if (cast.targetType == Integer.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_INT_EXPLICIT);
                } else if (cast.targetType == Long.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_LONG_EXPLICIT);
                } else if (cast.targetType == Float.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_FLOAT_EXPLICIT);
                } else if (cast.targetType == Double.TYPE) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_DOUBLE_EXPLICIT);
                } else if (cast.targetType == Boolean.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_BOOLEAN);
                } else if (cast.targetType == Byte.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_BYTE_EXPLICIT);
                } else if (cast.targetType == Short.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_SHORT_EXPLICIT);
                } else if (cast.targetType == Character.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_CHARACTER_EXPLICIT);
                } else if (cast.targetType == Integer.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_INTEGER_EXPLICIT);
                } else if (cast.targetType == Long.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_LONG_EXPLICIT);
                } else if (cast.targetType == Float.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_FLOAT_EXPLICIT);
                } else if (cast.targetType == Double.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_DOUBLE_EXPLICIT);
                } else if (cast.targetType == String.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_STRING_EXPLICIT);
                } else {
                    this.writeCast(cast.originalType, cast.targetType);
                }
            } else if (cast.targetType == Boolean.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_BOOLEAN);
            } else if (cast.targetType == Byte.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_BYTE_IMPLICIT);
            } else if (cast.targetType == Short.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_SHORT_IMPLICIT);
            } else if (cast.targetType == Character.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_CHAR_IMPLICIT);
            } else if (cast.targetType == Integer.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_INT_IMPLICIT);
            } else if (cast.targetType == Long.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_LONG_IMPLICIT);
            } else if (cast.targetType == Float.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_FLOAT_IMPLICIT);
            } else if (cast.targetType == Double.TYPE) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_P_DOUBLE_IMPLICIT);
            } else if (cast.targetType == Boolean.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_BOOLEAN);
            } else if (cast.targetType == Byte.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_BYTE_IMPLICIT);
            } else if (cast.targetType == Short.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_SHORT_IMPLICIT);
            } else if (cast.targetType == Character.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_CHARACTER_IMPLICIT);
            } else if (cast.targetType == Integer.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_INTEGER_IMPLICIT);
            } else if (cast.targetType == Long.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_LONG_IMPLICIT);
            } else if (cast.targetType == Float.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_FLOAT_IMPLICIT);
            } else if (cast.targetType == Double.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_B_DOUBLE_IMPLICIT);
            } else if (cast.targetType == String.class) {
                this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_STRING_IMPLICIT);
            } else {
                this.writeCast(cast.originalType, cast.targetType);
            }
        } else {
            this.writeCast(cast.originalType, cast.targetType);
        }
    }

    private void writeCast(Class<?> from, Class<?> to) {
        if (from.equals(to)) {
            return;
        }
        if (from != Boolean.TYPE && from.isPrimitive() && to != Boolean.TYPE && to.isPrimitive()) {
            this.cast(MethodWriter.getType(from), MethodWriter.getType(to));
        } else if (!to.isAssignableFrom(from)) {
            this.checkCast(MethodWriter.getType(to));
        }
    }

    @Override
    public void box(Type type) {
        this.valueOf(type);
    }

    public static Type getType(Class<?> clazz) {
        if (clazz.isArray()) {
            Class<?> component = clazz.getComponentType();
            int dimensions = 1;
            while (component.isArray()) {
                component = component.getComponentType();
                ++dimensions;
            }
            if (component == def.class) {
                char[] braces = new char[dimensions];
                Arrays.fill(braces, '[');
                return Type.getType(new String(braces) + Type.getType(Object.class).getDescriptor());
            }
        } else if (clazz == def.class) {
            return Type.getType(Object.class);
        }
        return Type.getType(clazz);
    }

    public List<Type> writeNewStrings() {
        ArrayList<Type> list = new ArrayList<Type>();
        this.stringConcatArgs.push(list);
        return list;
    }

    public void writeAppendStrings(Class<?> clazz) {
        List<Type> currentConcat = this.stringConcatArgs.peek();
        currentConcat.add(MethodWriter.getType(clazz));
        if (currentConcat.size() >= 200) {
            this.writeToStrings();
            currentConcat = this.writeNewStrings();
            currentConcat.add(WriterConstants.STRING_TYPE);
        }
    }

    public void writeToStrings() {
        String desc = Type.getMethodDescriptor(WriterConstants.STRING_TYPE, (Type[])this.stringConcatArgs.pop().toArray(Type[]::new));
        this.invokeDynamic("concat", desc, WriterConstants.STRING_CONCAT_BOOTSTRAP_HANDLE, new Object[0]);
    }

    public void writeDynamicBinaryInstruction(Location location, Class<?> returnType, Class<?> lhs, Class<?> rhs, Operation operation, int flags) {
        Type methodType = Type.getMethodType(MethodWriter.getType(returnType), MethodWriter.getType(lhs), MethodWriter.getType(rhs));
        switch (operation) {
            case MUL: {
                this.invokeDefCall("mul", methodType, 8, flags);
                break;
            }
            case DIV: {
                this.invokeDefCall("div", methodType, 8, flags);
                break;
            }
            case REM: {
                this.invokeDefCall("rem", methodType, 8, flags);
                break;
            }
            case ADD: {
                boolean hasPrimitiveArg;
                boolean bl = hasPrimitiveArg = lhs.isPrimitive() || rhs.isPrimitive();
                if (!hasPrimitiveArg) {
                    flags |= 1;
                }
                this.invokeDefCall("add", methodType, 8, flags);
                break;
            }
            case SUB: {
                this.invokeDefCall("sub", methodType, 8, flags);
                break;
            }
            case LSH: {
                this.invokeDefCall("lsh", methodType, 9, flags);
                break;
            }
            case USH: {
                this.invokeDefCall("ush", methodType, 9, flags);
                break;
            }
            case RSH: {
                this.invokeDefCall("rsh", methodType, 9, flags);
                break;
            }
            case BWAND: {
                this.invokeDefCall("and", methodType, 8, flags);
                break;
            }
            case XOR: {
                this.invokeDefCall("xor", methodType, 8, flags);
                break;
            }
            case BWOR: {
                this.invokeDefCall("or", methodType, 8, flags);
                break;
            }
            default: {
                throw location.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    public void writeBinaryInstruction(Location location, Class<?> clazz, Operation operation) {
        if (!(clazz != Float.TYPE && clazz != Double.TYPE || operation != Operation.LSH && operation != Operation.USH && operation != Operation.RSH && operation != Operation.BWAND && operation != Operation.XOR && operation != Operation.BWOR)) {
            throw location.createError(new IllegalStateException("Illegal tree structure."));
        }
        switch (operation) {
            case MUL: {
                this.math(104, MethodWriter.getType(clazz));
                break;
            }
            case DIV: {
                this.math(108, MethodWriter.getType(clazz));
                break;
            }
            case REM: {
                this.math(112, MethodWriter.getType(clazz));
                break;
            }
            case ADD: {
                this.math(96, MethodWriter.getType(clazz));
                break;
            }
            case SUB: {
                this.math(100, MethodWriter.getType(clazz));
                break;
            }
            case LSH: {
                this.math(120, MethodWriter.getType(clazz));
                break;
            }
            case USH: {
                this.math(124, MethodWriter.getType(clazz));
                break;
            }
            case RSH: {
                this.math(122, MethodWriter.getType(clazz));
                break;
            }
            case BWAND: {
                this.math(126, MethodWriter.getType(clazz));
                break;
            }
            case XOR: {
                this.math(130, MethodWriter.getType(clazz));
                break;
            }
            case BWOR: {
                this.math(128, MethodWriter.getType(clazz));
                break;
            }
            default: {
                throw location.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    public void writeDup(int size, int xsize) {
        if (size == 1) {
            if (xsize == 2) {
                this.dupX2();
            } else if (xsize == 1) {
                this.dupX1();
            } else {
                this.dup();
            }
        } else if (size == 2) {
            if (xsize == 2) {
                this.dup2X2();
            } else if (xsize == 1) {
                this.dup2X1();
            } else {
                this.dup2();
            }
        }
    }

    public void writePop(int size) {
        if (size == 1) {
            this.pop();
        } else if (size == 2) {
            this.pop2();
        }
    }

    @Override
    public void endMethod() {
        if (this.stringConcatArgs != null && !this.stringConcatArgs.isEmpty()) {
            throw new IllegalStateException("String concat bytecode not completed.");
        }
        super.endMethod();
    }

    @Override
    public void visitEnd() {
        throw new AssertionError((Object)"Should never call this method on MethodWriter, use endMethod() instead");
    }

    public void invokeDefCall(String name, Type methodType, int flavor, Object ... params) {
        Object[] args = new Object[params.length + 2];
        args[0] = this.settings.getInitialCallSiteDepth();
        args[1] = flavor;
        System.arraycopy(params, 0, args, 2, params.length);
        this.invokeDynamic(name, methodType.getDescriptor(), WriterConstants.DEF_BOOTSTRAP_HANDLE, args);
    }

    public void invokeMethodCall(PainlessMethod painlessMethod) {
        Type type = Type.getType(painlessMethod.javaMethod().getDeclaringClass());
        Method method = Method.getMethod(painlessMethod.javaMethod());
        if (Modifier.isStatic(painlessMethod.javaMethod().getModifiers())) {
            if (painlessMethod.javaMethod().getDeclaringClass().isInterface()) {
                this.visitMethodInsn(184, type.getInternalName(), painlessMethod.javaMethod().getName(), method.getDescriptor(), true);
            } else {
                this.invokeStatic(type, method);
            }
        } else if (painlessMethod.javaMethod().getDeclaringClass().isInterface()) {
            this.invokeInterface(type, method);
        } else {
            this.invokeVirtual(type, method);
        }
    }

    public void invokeLambdaCall(FunctionRef functionRef) {
        Object[] args = new Object[7 + functionRef.delegateInjections.length];
        args[0] = Type.getMethodType(functionRef.interfaceMethodType.toMethodDescriptorString());
        args[1] = functionRef.delegateClassName;
        args[2] = functionRef.delegateInvokeType;
        args[3] = functionRef.delegateMethodName;
        args[4] = Type.getMethodType(functionRef.delegateMethodType.toMethodDescriptorString());
        args[5] = functionRef.isDelegateInterface ? 1 : 0;
        args[6] = functionRef.isDelegateAugmented ? 1 : 0;
        System.arraycopy(functionRef.delegateInjections, 0, args, 7, functionRef.delegateInjections.length);
        this.invokeDynamic(functionRef.interfaceMethodName, functionRef.getFactoryMethodDescriptor(), WriterConstants.LAMBDA_BOOTSTRAP_HANDLE, args);
    }
}

