/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.admin.indices.sampling.SamplingMetadata;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.script.IngestConditionalScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public class SamplingService
implements ClusterStateListener {
    public static final boolean RANDOM_SAMPLING_FEATURE_FLAG = new FeatureFlag("random_sampling").isEnabled();
    private static final Logger logger = LogManager.getLogger(SamplingService.class);
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final LongSupplier relativeMillisTimeSupplier;
    private final LongSupplier statsTimeSupplier = System::nanoTime;
    private final Random random;
    private final Map<ProjectIndex, SoftReference<SampleInfo>> samples = new ConcurrentHashMap<ProjectIndex, SoftReference<SampleInfo>>();

    public SamplingService(ScriptService scriptService, ClusterService clusterService, ProjectResolver projectResolver, LongSupplier relativeMillisTimeSupplier) {
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.projectResolver = projectResolver;
        this.relativeMillisTimeSupplier = relativeMillisTimeSupplier;
        this.random = Randomness.get();
    }

    public void maybeSample(ProjectMetadata projectMetadata, IndexRequest indexRequest) {
        this.maybeSample(projectMetadata, indexRequest.index(), indexRequest, () -> {
            Map<String, Object> sourceAsMap;
            try {
                sourceAsMap = indexRequest.sourceAsMap();
            }
            catch (XContentParseException e) {
                sourceAsMap = Map.of();
                logger.trace("Invalid index request source, attempting to sample anyway");
            }
            return new IngestDocument(indexRequest.index(), indexRequest.id(), indexRequest.version(), indexRequest.routing(), indexRequest.versionType(), sourceAsMap);
        });
    }

    public void maybeSample(ProjectMetadata projectMetadata, String indexName, IndexRequest indexRequest, IngestDocument ingestDocument) {
        this.maybeSample(projectMetadata, indexName, indexRequest, () -> ingestDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSample(ProjectMetadata projectMetadata, String indexName, IndexRequest indexRequest, Supplier<IngestDocument> ingestDocumentSupplier) {
        if (!RANDOM_SAMPLING_FEATURE_FLAG) {
            return;
        }
        long startTime = this.statsTimeSupplier.getAsLong();
        SamplingMetadata samplingMetadata = (SamplingMetadata)projectMetadata.custom("sampling");
        if (samplingMetadata == null) {
            return;
        }
        SamplingConfiguration samplingConfig = samplingMetadata.getIndexToSamplingConfigMap().get(indexName);
        ProjectId projectId = projectMetadata.id();
        if (samplingConfig == null) {
            return;
        }
        SoftReference sampleInfoReference = this.samples.compute(new ProjectIndex(projectId, indexName), (k, v) -> v == null || v.get() == null ? new SoftReference<SampleInfo>(new SampleInfo(samplingConfig.maxSamples(), samplingConfig.timeToLive(), this.relativeMillisTimeSupplier.getAsLong())) : v);
        SampleInfo sampleInfo = (SampleInfo)sampleInfoReference.get();
        if (sampleInfo == null) {
            return;
        }
        SampleStats stats = sampleInfo.stats;
        stats.potentialSamples.increment();
        try {
            if (!sampleInfo.hasCapacity()) {
                stats.samplesRejectedForMaxSamplesExceeded.increment();
                return;
            }
            if (this.random.nextDouble() >= samplingConfig.rate()) {
                stats.samplesRejectedForRate.increment();
                return;
            }
            String condition = samplingConfig.condition();
            if (condition != null && (sampleInfo.script == null || sampleInfo.factory == null)) {
                long compileScriptStartTime = this.statsTimeSupplier.getAsLong();
                try {
                    if (sampleInfo.compilationFailed) {
                        stats.samplesRejectedForException.increment();
                        return;
                    }
                    Script script = SamplingService.getScript(condition);
                    sampleInfo.setScript(script, this.scriptService.compile(script, IngestConditionalScript.CONTEXT));
                }
                catch (Exception e) {
                    sampleInfo.compilationFailed = true;
                    throw e;
                }
                finally {
                    stats.timeCompilingCondition.add(this.statsTimeSupplier.getAsLong() - compileScriptStartTime);
                }
            }
            if (condition != null && !this.evaluateCondition(ingestDocumentSupplier, sampleInfo.script, sampleInfo.factory, sampleInfo.stats)) {
                stats.samplesRejectedForCondition.increment();
                return;
            }
            RawDocument sample = this.getRawDocumentForIndexRequest(projectId, indexName, indexRequest);
            if (sampleInfo.offer(sample)) {
                stats.samples.increment();
                logger.trace("Sampling " + String.valueOf(indexRequest));
            } else {
                stats.samplesRejectedForMaxSamplesExceeded.increment();
            }
        }
        catch (Exception e) {
            stats.samplesRejectedForException.increment();
            stats.lastException = e;
            logger.debug("Error performing sampling for " + indexName, (Throwable)e);
        }
        finally {
            stats.timeSampling.add(this.statsTimeSupplier.getAsLong() - startTime);
        }
    }

    public List<RawDocument> getLocalSample(ProjectId projectId, String index) {
        SoftReference<SampleInfo> sampleInfoReference = this.samples.get(new ProjectIndex(projectId, index));
        SampleInfo sampleInfo = sampleInfoReference == null ? null : sampleInfoReference.get();
        return sampleInfo == null ? List.of() : Arrays.stream(sampleInfo.getRawDocuments()).filter(Objects::nonNull).toList();
    }

    public SampleStats getLocalSampleStats(ProjectId projectId, String index) {
        SoftReference<SampleInfo> sampleInfoReference = this.samples.get(new ProjectIndex(projectId, index));
        SampleInfo sampleInfo = sampleInfoReference.get();
        return sampleInfo == null ? new SampleStats() : sampleInfo.stats;
    }

    public boolean atLeastOneSampleConfigured() {
        if (RANDOM_SAMPLING_FEATURE_FLAG) {
            SamplingMetadata samplingMetadata = (SamplingMetadata)this.clusterService.state().projectState(this.projectResolver.getProjectId()).metadata().custom("sampling");
            return samplingMetadata != null && !samplingMetadata.getIndexToSamplingConfigMap().isEmpty();
        }
        return false;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
    }

    private boolean evaluateCondition(Supplier<IngestDocument> ingestDocumentSupplier, Script script, IngestConditionalScript.Factory factory, SampleStats stats) {
        long conditionStartTime = this.statsTimeSupplier.getAsLong();
        boolean passedCondition = factory.newInstance(script.getParams(), ingestDocumentSupplier.get().getUnmodifiableSourceAndMetadata()).execute();
        stats.timeEvaluatingCondition.add(this.statsTimeSupplier.getAsLong() - conditionStartTime);
        return passedCondition;
    }

    private static Script getScript(String conditional) throws IOException {
        logger.debug("Parsing script for conditional " + conditional);
        try (XContentBuilder builder = XContentBuilder.builder(JsonXContent.jsonXContent).map(Map.of("source", conditional));){
            Script script;
            block12: {
                XContentParser parser = XContentHelper.createParserNotCompressed(LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, BytesReference.bytes(builder), XContentType.JSON);
                try {
                    script = Script.parse(parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return script;
        }
    }

    private RawDocument getRawDocumentForIndexRequest(ProjectId projectId, String indexName, IndexRequest indexRequest) {
        BytesReference sourceReference = indexRequest.source();
        assert (sourceReference != null) : "Cannot sample an IndexRequest with no source";
        byte[] source = sourceReference.array();
        byte[] sourceCopy = new byte[sourceReference.length()];
        System.arraycopy(source, sourceReference.arrayOffset(), sourceCopy, 0, sourceReference.length());
        return new RawDocument(projectId, indexName, sourceCopy, indexRequest.getContentType());
    }

    private record ProjectIndex(ProjectId projectId, String indexName) {
    }

    private static final class SampleInfo {
        private final RawDocument[] rawDocuments;
        private final SampleStats stats;
        private final long expiration;
        private final TimeValue timeToLive;
        private volatile Script script;
        private volatile IngestConditionalScript.Factory factory;
        private volatile boolean compilationFailed = false;
        private volatile boolean isFull = false;
        private final AtomicInteger arrayIndex = new AtomicInteger(0);

        SampleInfo(int maxSamples, TimeValue timeToLive, long relativeNowMillis) {
            this.timeToLive = timeToLive;
            this.rawDocuments = new RawDocument[maxSamples];
            this.stats = new SampleStats();
            this.expiration = (timeToLive == null ? TimeValue.timeValueDays(5L).millis() : timeToLive.millis()) + relativeNowMillis;
        }

        public boolean hasCapacity() {
            return !this.isFull;
        }

        public RawDocument[] getRawDocuments() {
            return this.rawDocuments;
        }

        public boolean offer(RawDocument rawDocument) {
            int index = this.arrayIndex.getAndIncrement();
            if (index < this.rawDocuments.length) {
                this.rawDocuments[index] = rawDocument;
                if (index == this.rawDocuments.length - 1) {
                    this.isFull = true;
                }
                return true;
            }
            return false;
        }

        void setScript(Script script, IngestConditionalScript.Factory factory) {
            this.script = script;
            this.factory = factory;
        }
    }

    public static final class SampleStats
    implements Writeable,
    ToXContent {
        final LongAdder samples = new LongAdder();
        final LongAdder potentialSamples = new LongAdder();
        final LongAdder samplesRejectedForMaxSamplesExceeded = new LongAdder();
        final LongAdder samplesRejectedForCondition = new LongAdder();
        final LongAdder samplesRejectedForRate = new LongAdder();
        final LongAdder samplesRejectedForException = new LongAdder();
        final LongAdder timeSampling = new LongAdder();
        final LongAdder timeEvaluatingCondition = new LongAdder();
        final LongAdder timeCompilingCondition = new LongAdder();
        Exception lastException = null;

        public SampleStats() {
        }

        public SampleStats(StreamInput in) throws IOException {
            this.potentialSamples.add(in.readLong());
            this.samplesRejectedForMaxSamplesExceeded.add(in.readLong());
            this.samplesRejectedForCondition.add(in.readLong());
            this.samplesRejectedForRate.add(in.readLong());
            this.samplesRejectedForException.add(in.readLong());
            this.samples.add(in.readLong());
            this.timeSampling.add(in.readLong());
            this.timeEvaluatingCondition.add(in.readLong());
            this.timeCompilingCondition.add(in.readLong());
            this.lastException = in.readBoolean() ? in.readException() : null;
        }

        public long getSamples() {
            return this.samples.longValue();
        }

        public long getPotentialSamples() {
            return this.potentialSamples.longValue();
        }

        public long getSamplesRejectedForMaxSamplesExceeded() {
            return this.samplesRejectedForMaxSamplesExceeded.longValue();
        }

        public long getSamplesRejectedForCondition() {
            return this.samplesRejectedForCondition.longValue();
        }

        public long getSamplesRejectedForRate() {
            return this.samplesRejectedForRate.longValue();
        }

        public long getSamplesRejectedForException() {
            return this.samplesRejectedForException.longValue();
        }

        public TimeValue getTimeSampling() {
            return TimeValue.timeValueNanos(this.timeSampling.longValue());
        }

        public TimeValue getTimeEvaluatingCondition() {
            return TimeValue.timeValueNanos(this.timeEvaluatingCondition.longValue());
        }

        public TimeValue getTimeCompilingCondition() {
            return TimeValue.timeValueNanos(this.timeCompilingCondition.longValue());
        }

        public Exception getLastException() {
            return this.lastException;
        }

        public String toString() {
            return "potential_samples: " + String.valueOf(this.potentialSamples) + ", samples_rejected_for_max_samples_exceeded: " + String.valueOf(this.samplesRejectedForMaxSamplesExceeded) + ", samples_rejected_for_condition: " + String.valueOf(this.samplesRejectedForCondition) + ", samples_rejected_for_rate: " + String.valueOf(this.samplesRejectedForRate) + ", samples_rejected_for_exception: " + String.valueOf(this.samplesRejectedForException) + ", samples_accepted: " + String.valueOf(this.samples) + ", time_sampling: " + this.timeSampling.longValue() / 1000000L + ", time_evaluating_condition: " + this.timeEvaluatingCondition.longValue() / 1000000L + ", time_compiling_condition: " + this.timeCompilingCondition.longValue() / 1000000L;
        }

        public SampleStats combine(SampleStats other) {
            SampleStats result = new SampleStats();
            SampleStats.addAllFields(this, result);
            SampleStats.addAllFields(other, result);
            return result;
        }

        private static void addAllFields(SampleStats source, SampleStats dest) {
            dest.potentialSamples.add(source.potentialSamples.longValue());
            dest.samplesRejectedForMaxSamplesExceeded.add(source.samplesRejectedForMaxSamplesExceeded.longValue());
            dest.samplesRejectedForCondition.add(source.samplesRejectedForCondition.longValue());
            dest.samplesRejectedForRate.add(source.samplesRejectedForRate.longValue());
            dest.samplesRejectedForException.add(source.samplesRejectedForException.longValue());
            dest.samples.add(source.samples.longValue());
            dest.timeSampling.add(source.timeSampling.longValue());
            dest.timeEvaluatingCondition.add(source.timeEvaluatingCondition.longValue());
            dest.timeCompilingCondition.add(source.timeCompilingCondition.longValue());
            if (dest.lastException == null) {
                dest.lastException = source.lastException;
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("potential_samples", this.potentialSamples.longValue());
            builder.field("samples_rejected_for_max_samples_exceeded", this.samplesRejectedForMaxSamplesExceeded.longValue());
            builder.field("samples_rejected_for_condition", this.samplesRejectedForCondition.longValue());
            builder.field("samples_rejected_for_rate", this.samplesRejectedForRate.longValue());
            builder.field("samples_rejected_for_exception", this.samplesRejectedForException.longValue());
            builder.field("samples_accepted", this.samples.longValue());
            builder.field("time_sampling", this.timeSampling.longValue() / 1000000L);
            builder.field("time_evaluating_condition", this.timeEvaluatingCondition.longValue() / 1000000L);
            builder.field("time_compiling_condition", this.timeCompilingCondition.longValue() / 1000000L);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.potentialSamples.longValue());
            out.writeLong(this.samplesRejectedForMaxSamplesExceeded.longValue());
            out.writeLong(this.samplesRejectedForCondition.longValue());
            out.writeLong(this.samplesRejectedForRate.longValue());
            out.writeLong(this.samplesRejectedForException.longValue());
            out.writeLong(this.samples.longValue());
            out.writeLong(this.timeSampling.longValue());
            out.writeLong(this.timeEvaluatingCondition.longValue());
            out.writeLong(this.timeCompilingCondition.longValue());
            if (this.lastException == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeException(this.lastException);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SampleStats that = (SampleStats)o;
            if (this.samples.longValue() != that.samples.longValue()) {
                return false;
            }
            if (this.potentialSamples.longValue() != that.potentialSamples.longValue()) {
                return false;
            }
            if (this.samplesRejectedForMaxSamplesExceeded.longValue() != that.samplesRejectedForMaxSamplesExceeded.longValue()) {
                return false;
            }
            if (this.samplesRejectedForCondition.longValue() != that.samplesRejectedForCondition.longValue()) {
                return false;
            }
            if (this.samplesRejectedForRate.longValue() != that.samplesRejectedForRate.longValue()) {
                return false;
            }
            if (this.samplesRejectedForException.longValue() != that.samplesRejectedForException.longValue()) {
                return false;
            }
            if (this.timeSampling.longValue() != that.timeSampling.longValue()) {
                return false;
            }
            if (this.timeEvaluatingCondition.longValue() != that.timeEvaluatingCondition.longValue()) {
                return false;
            }
            if (this.timeCompilingCondition.longValue() != that.timeCompilingCondition.longValue()) {
                return false;
            }
            return this.exceptionsAreEqual(this.lastException, that.lastException);
        }

        private boolean exceptionsAreEqual(Exception e1, Exception e2) {
            if (e1 == null && e2 == null) {
                return true;
            }
            if (e1 == null || e2 == null) {
                return false;
            }
            return e1.getClass().equals(e2.getClass()) && e1.getMessage().equals(e2.getMessage());
        }

        public int hashCode() {
            return Objects.hash(this.samples.longValue(), this.potentialSamples.longValue(), this.samplesRejectedForMaxSamplesExceeded.longValue(), this.samplesRejectedForCondition.longValue(), this.samplesRejectedForRate.longValue(), this.samplesRejectedForException.longValue(), this.timeSampling.longValue(), this.timeEvaluatingCondition.longValue(), this.timeCompilingCondition.longValue()) + this.hashException(this.lastException);
        }

        private int hashException(Exception e) {
            if (e == null) {
                return 0;
            }
            return Objects.hash(e.getClass(), e.getMessage());
        }
    }

    public record RawDocument(ProjectId projectId, String indexName, byte[] source, XContentType contentType) implements Writeable
    {
        public RawDocument(StreamInput in) throws IOException {
            this(ProjectId.readFrom(in), in.readString(), in.readByteArray(), in.readEnum(XContentType.class));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.projectId.writeTo(out);
            out.writeString(this.indexName);
            out.writeByteArray(this.source);
            XContentHelper.writeTo(out, this.contentType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawDocument rawDocument = (RawDocument)o;
            return Objects.equals(this.projectId, rawDocument.projectId) && Objects.equals(this.indexName, rawDocument.indexName) && Arrays.equals(this.source, rawDocument.source) && this.contentType == rawDocument.contentType;
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.projectId, this.indexName, this.contentType);
            result = 31 * result + Arrays.hashCode(this.source);
            return result;
        }
    }
}

