/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetadata;
import org.elasticsearch.gateway.CorruptStateException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class PersistedClusterStateService {
    private static final Logger logger = LogManager.getLogger(PersistedClusterStateService.class);
    private static final String CURRENT_TERM_KEY = "current_term";
    private static final String LAST_ACCEPTED_VERSION_KEY = "last_accepted_version";
    private static final String NODE_ID_KEY = "node_id";
    private static final String CLUSTER_UUID_KEY = "cluster_uuid";
    private static final String CLUSTER_UUID_COMMITTED_KEY = "cluster_uuid_committed";
    private static final String OVERRIDDEN_NODE_VERSION_KEY = "overridden_node_version";
    static final String NODE_VERSION_KEY = "node_version";
    private static final String OLDEST_INDEX_VERSION_KEY = "oldest_index_version";
    public static final String TYPE_FIELD_NAME = "type";
    public static final String GLOBAL_TYPE_NAME = "global";
    public static final String INDEX_TYPE_NAME = "index";
    public static final String MAPPING_TYPE_NAME = "mapping";
    public static final String PROJECT_ID_FIELD_NAME = "project_id";
    private static final String DATA_FIELD_NAME = "data";
    private static final String INDEX_UUID_FIELD_NAME = "index_uuid";
    private static final String MAPPING_HASH_FIELD_NAME = "mapping_hash";
    public static final String PAGE_FIELD_NAME = "page";
    public static final String LAST_PAGE_FIELD_NAME = "last_page";
    public static final int IS_LAST_PAGE = 1;
    public static final int IS_NOT_LAST_PAGE = 0;
    private static final int COMMIT_DATA_SIZE = 7;
    private static final MergePolicy NO_MERGE_POLICY = PersistedClusterStateService.noMergePolicy();
    private static final MergePolicy DEFAULT_MERGE_POLICY = PersistedClusterStateService.defaultMergePolicy();
    public static final String METADATA_DIRECTORY_NAME = "_state";
    public static final Setting<TimeValue> SLOW_WRITE_LOGGING_THRESHOLD = Setting.timeSetting("gateway.slow_write_logging_threshold", TimeValue.timeValueSeconds(10L), TimeValue.ZERO, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<ByteSizeValue> DOCUMENT_PAGE_SIZE = Setting.byteSizeSetting("cluster_state.document_page_size", ByteSizeValue.ofMb(1L), ByteSizeValue.ONE, ByteSizeValue.ofGb(1L), Setting.Property.NodeScope);
    private final Path[] dataPaths;
    private final String nodeId;
    private final XContentParserConfiguration parserConfig;
    private final LongSupplier relativeTimeMillisSupplier;
    private final ByteSizeValue documentPageSize;
    private volatile TimeValue slowWriteLoggingThreshold;
    private final BooleanSupplier supportsMultipleProjects;
    private static final ToXContent.Params FORMAT_PARAMS;

    public PersistedClusterStateService(NodeEnvironment nodeEnvironment, NamedXContentRegistry namedXContentRegistry, ClusterSettings clusterSettings, LongSupplier relativeTimeMillisSupplier, BooleanSupplier supportsMultipleProjects) {
        this(nodeEnvironment.nodeDataPaths(), nodeEnvironment.nodeId(), namedXContentRegistry, clusterSettings, relativeTimeMillisSupplier, supportsMultipleProjects);
    }

    public PersistedClusterStateService(Path[] dataPaths, String nodeId, NamedXContentRegistry namedXContentRegistry, ClusterSettings clusterSettings, LongSupplier relativeTimeMillisSupplier, BooleanSupplier supportsMultipleProjects) {
        this.dataPaths = dataPaths;
        this.nodeId = nodeId;
        this.parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler(LoggingDeprecationHandler.INSTANCE).withRegistry(namedXContentRegistry);
        this.relativeTimeMillisSupplier = relativeTimeMillisSupplier;
        this.slowWriteLoggingThreshold = clusterSettings.get(SLOW_WRITE_LOGGING_THRESHOLD);
        this.supportsMultipleProjects = supportsMultipleProjects;
        clusterSettings.addSettingsUpdateConsumer(SLOW_WRITE_LOGGING_THRESHOLD, this::setSlowWriteLoggingThreshold);
        this.documentPageSize = clusterSettings.get(DOCUMENT_PAGE_SIZE);
    }

    private void setSlowWriteLoggingThreshold(TimeValue slowWriteLoggingThreshold) {
        this.slowWriteLoggingThreshold = slowWriteLoggingThreshold;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer createWriter() throws IOException {
        ArrayList<MetadataIndexWriter> metadataIndexWriters = new ArrayList<MetadataIndexWriter>();
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        boolean success = false;
        try {
            for (Path path : this.dataPaths) {
                Directory directory = this.createDirectory(path.resolve(METADATA_DIRECTORY_NAME));
                closeables.add(directory);
                IndexWriter indexWriter = PersistedClusterStateService.createIndexWriter(directory, false);
                closeables.add(indexWriter);
                metadataIndexWriters.add(new MetadataIndexWriter(path, directory, indexWriter, this.supportsMultipleProjects.getAsBoolean()));
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(closeables);
            }
        }
        return new Writer(metadataIndexWriters, this.nodeId, this.documentPageSize, this.relativeTimeMillisSupplier, () -> this.slowWriteLoggingThreshold, this.getAssertOnCommit());
    }

    CheckedBiConsumer<Path, DirectoryReader, IOException> getAssertOnCommit() {
        return Assertions.ENABLED ? this::loadOnDiskState : null;
    }

    private static IndexWriter createIndexWriter(Directory directory, boolean openExisting) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(new KeywordAnalyzer());
        indexWriterConfig.setInfoStream(InfoStream.NO_OUTPUT);
        indexWriterConfig.setOpenMode(openExisting ? IndexWriterConfig.OpenMode.APPEND : IndexWriterConfig.OpenMode.CREATE);
        indexWriterConfig.setCommitOnClose(false);
        indexWriterConfig.setRAMBufferSizeMB(1.0);
        indexWriterConfig.setMergeScheduler(new SerialMergeScheduler());
        indexWriterConfig.setMergePolicy(DEFAULT_MERGE_POLICY);
        return new IndexWriter(directory, indexWriterConfig);
    }

    public static void deleteAll(Path[] dataPaths) throws IOException {
        for (Path dataPath : dataPaths) {
            Lucene.cleanLuceneIndex(new NIOFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));
        }
    }

    protected Directory createDirectory(Path path) throws IOException {
        return new NIOFSDirectory(path);
    }

    public Path[] getDataPaths() {
        return this.dataPaths;
    }

    @Nullable
    public static NodeMetadata nodeMetadata(Path ... dataPaths) throws IOException {
        String nodeId = null;
        BuildVersion version = null;
        IndexVersion oldestIndexVersion = IndexVersions.ZERO;
        for (Path dataPath : dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (DirectoryReader reader = DirectoryReader.open(new NIOFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));){
                Map<String, String> userData = reader.getIndexCommit().getUserData();
                assert (userData.get(NODE_VERSION_KEY) != null);
                String thisNodeId = userData.get(NODE_ID_KEY);
                assert (thisNodeId != null);
                if (nodeId != null && !nodeId.equals(thisNodeId)) {
                    throw new CorruptStateException("unexpected node ID in metadata, found [" + thisNodeId + "] in [" + String.valueOf(dataPath) + "] but expected [" + nodeId + "]");
                }
                if (nodeId != null) continue;
                nodeId = thisNodeId;
                version = BuildVersion.fromNodeMetadata(userData.get(NODE_VERSION_KEY));
                if (userData.containsKey(OLDEST_INDEX_VERSION_KEY)) {
                    oldestIndexVersion = IndexVersion.fromId(Integer.parseInt(userData.get(OLDEST_INDEX_VERSION_KEY)));
                    continue;
                }
                oldestIndexVersion = IndexVersions.ZERO;
            }
            catch (IndexNotFoundException e) {
                logger.debug(() -> Strings.format("no on-disk state at %s", indexPath), (Throwable)e);
            }
        }
        if (nodeId == null) {
            return null;
        }
        return new NodeMetadata(nodeId, version, oldestIndexVersion);
    }

    public static void overrideVersion(BuildVersion newVersion, Path ... dataPaths) throws IOException {
        for (Path dataPath : dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (DirectoryReader reader = DirectoryReader.open(new NIOFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));){
                Map<String, String> userData = reader.getIndexCommit().getUserData();
                assert (userData.get(NODE_VERSION_KEY) != null);
                try (IndexWriter indexWriter = PersistedClusterStateService.createIndexWriter(new NIOFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)), true);){
                    HashMap<String, String> commitData = new HashMap<String, String>(userData);
                    commitData.put(NODE_VERSION_KEY, newVersion.toNodeMetadata());
                    commitData.put(OVERRIDDEN_NODE_VERSION_KEY, Boolean.toString(true));
                    indexWriter.setLiveCommitData(commitData.entrySet());
                    indexWriter.commit();
                }
            }
            catch (IndexNotFoundException e) {
                logger.debug(() -> Strings.format("no on-disk state at %s", indexPath), (Throwable)e);
            }
        }
    }

    public OnDiskState loadBestOnDiskState() throws IOException {
        return this.loadBestOnDiskState(true);
    }

    OnDiskState loadBestOnDiskState(boolean checkClean) throws IOException {
        OnDiskState bestOnDiskState;
        String committedClusterUuid = null;
        Path committedClusterUuidPath = null;
        OnDiskState maxCurrentTermOnDiskState = bestOnDiskState = OnDiskState.NO_ON_DISK_STATE;
        for (Path dataPath : this.dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (Directory directory = this.createDirectory(indexPath);){
                if (checkClean) {
                    logger.debug("checking cluster state integrity in [{}]", (Object)indexPath);
                    try (BytesStreamOutput outputStream = new BytesStreamOutput();){
                        boolean isClean;
                        try (PrintStream printStream = new PrintStream((OutputStream)outputStream, true, StandardCharsets.UTF_8);
                             CheckIndex checkIndex = new CheckIndex(directory);){
                            checkIndex.setThreadCount(1);
                            checkIndex.setInfoStream(printStream);
                            checkIndex.setLevel(1);
                            isClean = checkIndex.checkIndex().clean;
                        }
                        if (!isClean) {
                            if (logger.isErrorEnabled()) {
                                outputStream.bytes().utf8ToString().lines().forEach(l -> logger.error("checkIndex: {}", l));
                            }
                            throw new CorruptStateException("the index containing the cluster metadata under the data path [" + String.valueOf(dataPath) + "] has been changed by an external force after it was last written by Elasticsearch and is now unreadable");
                        }
                    }
                }
                try (DirectoryReader directoryReader = DirectoryReader.open(directory);){
                    if (logger.isDebugEnabled()) {
                        IndexCommit indexCommit = directoryReader.getIndexCommit();
                        String segmentsFileName = indexCommit.getSegmentsFileName();
                        try {
                            BasicFileAttributes attributes = Files.readAttributes(indexPath.resolve(segmentsFileName), BasicFileAttributes.class, new LinkOption[0]);
                            logger.debug("loading cluster state from commit [" + segmentsFileName + "] in [" + String.valueOf(directory) + "]: creationTime=" + String.valueOf(attributes.creationTime()) + ", lastModifiedTime=" + String.valueOf(attributes.lastModifiedTime()) + ", lastAccessTime=" + String.valueOf(attributes.lastAccessTime()));
                        }
                        catch (Exception e) {
                            logger.debug("loading cluster state from commit [" + segmentsFileName + "] in [" + String.valueOf(directory) + "] but could not get file attributes", (Throwable)e);
                        }
                        logger.debug("cluster state commit user data: {}", indexCommit.getUserData());
                        for (SegmentCommitInfo segmentCommitInfo : SegmentInfos.readCommit(directory, segmentsFileName)) {
                            logger.debug("loading cluster state from segment: {}", (Object)segmentCommitInfo);
                        }
                    }
                    OnDiskState onDiskState = this.loadOnDiskState(dataPath, directoryReader);
                    if (!this.nodeId.equals(onDiskState.nodeId)) {
                        throw new CorruptStateException("the index containing the cluster metadata under the data path [" + String.valueOf(dataPath) + "] belongs to a node with ID [" + onDiskState.nodeId + "] but this node's ID is [" + this.nodeId + "]");
                    }
                    if (onDiskState.metadata.clusterUUIDCommitted()) {
                        if (committedClusterUuid == null) {
                            committedClusterUuid = onDiskState.metadata.clusterUUID();
                            committedClusterUuidPath = dataPath;
                        } else if (!committedClusterUuid.equals(onDiskState.metadata.clusterUUID())) {
                            throw new CorruptStateException("mismatched cluster UUIDs in metadata, found [" + committedClusterUuid + "] in [" + String.valueOf(committedClusterUuidPath) + "] and [" + onDiskState.metadata.clusterUUID() + "] in [" + String.valueOf(dataPath) + "]");
                        }
                    }
                    if (maxCurrentTermOnDiskState.empty() || maxCurrentTermOnDiskState.currentTerm < onDiskState.currentTerm) {
                        maxCurrentTermOnDiskState = onDiskState;
                    }
                    long acceptedTerm = onDiskState.metadata.coordinationMetadata().term();
                    long maxAcceptedTerm = bestOnDiskState.metadata.coordinationMetadata().term();
                    if (!bestOnDiskState.empty() && acceptedTerm <= maxAcceptedTerm && (acceptedTerm != maxAcceptedTerm || onDiskState.lastAcceptedVersion <= bestOnDiskState.lastAcceptedVersion && (onDiskState.lastAcceptedVersion != bestOnDiskState.lastAcceptedVersion || onDiskState.currentTerm <= bestOnDiskState.currentTerm))) continue;
                    bestOnDiskState = onDiskState;
                }
            }
            catch (IndexNotFoundException e) {
                logger.debug(() -> Strings.format("no on-disk state at %s", indexPath), (Throwable)e);
            }
        }
        if (bestOnDiskState.currentTerm != maxCurrentTermOnDiskState.currentTerm) {
            throw new CorruptStateException("inconsistent terms found: best state is from [" + String.valueOf(bestOnDiskState.dataPath) + "] in term [" + bestOnDiskState.currentTerm + "] but there is a stale state in [" + String.valueOf(maxCurrentTermOnDiskState.dataPath) + "] with greater term [" + maxCurrentTermOnDiskState.currentTerm + "]");
        }
        return bestOnDiskState;
    }

    public OnDiskState loadOnDiskState(Path dataPath, DirectoryReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setQueryCache(null);
        SetOnce builderReference = new SetOnce();
        PersistedClusterStateService.consumeFromType(searcher, GLOBAL_TYPE_NAME, ignored -> GLOBAL_TYPE_NAME, (doc, bytes) -> {
            Metadata metadata = this.readXContent((BytesReference)bytes, Metadata.Builder::fromXContent);
            logger.trace("found global metadata with last-accepted term [{}]", (Object)metadata.coordinationMetadata().term());
            if (builderReference.get() != null) {
                throw new CorruptStateException("duplicate global metadata found in [" + String.valueOf(dataPath) + "]");
            }
            builderReference.set(Metadata.builder(metadata));
        });
        Metadata.Builder builder = (Metadata.Builder)builderReference.get();
        if (builder == null) {
            throw new CorruptStateException("no global metadata found in [" + String.valueOf(dataPath) + "]");
        }
        logger.trace("got global metadata, now reading mapping metadata");
        HashMap mappingsByHash = new HashMap();
        PersistedClusterStateService.consumeFromType(searcher, MAPPING_TYPE_NAME, document -> document.getField(MAPPING_HASH_FIELD_NAME).stringValue(), (doc, bytes) -> {
            MappingMetadata mappingMetadata = this.readXContent((BytesReference)bytes, parser -> {
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                    throw new CorruptStateException("invalid mapping metadata: expected START_OBJECT but got [" + String.valueOf((Object)parser.currentToken()) + "]");
                }
                if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
                    throw new CorruptStateException("invalid mapping metadata: expected FIELD_NAME but got [" + String.valueOf((Object)parser.currentToken()) + "]");
                }
                String fieldName = parser.currentName();
                if (!"content".equals(fieldName)) {
                    throw new CorruptStateException("invalid mapping metadata: unknown field [" + fieldName + "]");
                }
                if (parser.nextToken() != XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                    throw new CorruptStateException("invalid mapping metadata: expected VALUE_EMBEDDED_OBJECT but got [" + String.valueOf((Object)parser.currentToken()) + "]");
                }
                return new MappingMetadata(new CompressedXContent(parser.binaryValue()));
            });
            ProjectId projectId = ProjectId.ofNullable(doc.get(PROJECT_ID_FIELD_NAME), Metadata.DEFAULT_PROJECT_ID);
            String hash = mappingMetadata.source().getSha256();
            logger.trace("found mapping metadata with hash {}", (Object)hash);
            if (mappingsByHash.computeIfAbsent(projectId, k -> new HashMap()).put(hash, mappingMetadata) != null) {
                throw new CorruptStateException("duplicate metadata found for mapping hash [" + hash + "] in project [" + projectId.id() + "]");
            }
        });
        logger.trace("got metadata for [{}] mappings, now reading index metadata", (Object)mappingsByHash.size());
        HashSet indexUUIDs = new HashSet();
        PersistedClusterStateService.consumeFromType(searcher, INDEX_TYPE_NAME, document -> document.getField(INDEX_UUID_FIELD_NAME).stringValue(), (doc, bytes) -> {
            ProjectId projectId = ProjectId.ofNullable(doc.get(PROJECT_ID_FIELD_NAME), Metadata.DEFAULT_PROJECT_ID);
            IndexMetadata indexMetadata = this.readXContent((BytesReference)bytes, parser -> {
                try {
                    return IndexMetadata.fromXContent(parser, mappingsByHash.getOrDefault(projectId, Map.of()));
                }
                catch (Exception e) {
                    throw new CorruptStateException(e);
                }
            });
            logger.trace("found index metadata for {}", (Object)indexMetadata.getIndex());
            if (!indexUUIDs.add(indexMetadata.getIndexUUID())) {
                throw new CorruptStateException("duplicate metadata found for " + String.valueOf(indexMetadata.getIndex()) + " in [" + String.valueOf(dataPath) + "]");
            }
            builder.getProject(projectId).put(indexMetadata, false);
        });
        Map<String, String> userData = reader.getIndexCommit().getUserData();
        logger.trace("loaded metadata [{}] from [{}]", userData, (Object)reader.directory());
        OnDiskStateMetadata onDiskStateMetadata = this.loadOnDiskStateMetadataFromUserData(userData);
        return new OnDiskState(onDiskStateMetadata.nodeId(), dataPath, onDiskStateMetadata.currentTerm(), onDiskStateMetadata.lastAcceptedVersion(), onDiskStateMetadata.clusterUUID(), onDiskStateMetadata.clusterUUIDCommitted(), builder.build());
    }

    public OnDiskStateMetadata loadOnDiskStateMetadataFromUserData(Map<String, String> userData) {
        assert (userData.get(CURRENT_TERM_KEY) != null);
        assert (userData.get(LAST_ACCEPTED_VERSION_KEY) != null);
        assert (userData.get(NODE_ID_KEY) != null);
        assert (userData.get(NODE_VERSION_KEY) != null);
        assert (userData.get(CLUSTER_UUID_KEY) != null);
        assert (userData.get(CLUSTER_UUID_COMMITTED_KEY) != null);
        assert (userData.get(OVERRIDDEN_NODE_VERSION_KEY) != null || userData.size() == 7);
        return new OnDiskStateMetadata(Long.parseLong(userData.get(CURRENT_TERM_KEY)), Long.parseLong(userData.get(LAST_ACCEPTED_VERSION_KEY)), userData.get(NODE_ID_KEY), userData.get(CLUSTER_UUID_KEY), userData.get(CLUSTER_UUID_COMMITTED_KEY) != null ? Boolean.valueOf(Booleans.parseBoolean(userData.get(CLUSTER_UUID_COMMITTED_KEY))) : null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readXContent(BytesReference bytes, CheckedFunction<XContentParser, T, IOException> reader) throws IOException {
        try (XContentParser parser = XContentHelper.createParserNotCompressed(this.parserConfig, bytes, XContentType.SMILE);){
            XContentParser t = reader.apply(parser);
            return (T)t;
        }
        catch (Exception e) {
            throw new CorruptStateException(e);
        }
    }

    private static void consumeFromType(IndexSearcher indexSearcher, String type, Function<Document, String> keyFunction, CheckedBiConsumer<Document, BytesReference, IOException> bytesReferenceConsumer) throws IOException {
        TermQuery query = new TermQuery(new Term(TYPE_FIELD_NAME, type));
        Weight weight = indexSearcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
        logger.trace("running query [{}]", (Object)query);
        HashMap<String, PaginatedDocumentReader> documentReaders = new HashMap<String, PaginatedDocumentReader>();
        for (LeafReaderContext leafReaderContext : indexSearcher.getIndexReader().leaves()) {
            logger.trace("new leafReaderContext: {}", (Object)leafReaderContext);
            Scorer scorer = weight.scorer(leafReaderContext);
            if (scorer == null) continue;
            Bits liveDocs = leafReaderContext.reader().getLiveDocs();
            IntPredicate isLiveDoc = liveDocs == null ? i -> true : liveDocs::get;
            DocIdSetIterator docIdSetIterator = scorer.iterator();
            StoredFields storedFields = leafReaderContext.reader().storedFields();
            while (docIdSetIterator.nextDoc() != Integer.MAX_VALUE) {
                boolean isLastPage;
                if (!isLiveDoc.test(docIdSetIterator.docID())) continue;
                logger.trace("processing doc {}", (Object)docIdSetIterator.docID());
                Document document = storedFields.document(docIdSetIterator.docID());
                BytesArray documentData = new BytesArray(document.getBinaryValue(DATA_FIELD_NAME));
                if (document.getField(PAGE_FIELD_NAME) == null) {
                    assert (IndexVersions.MINIMUM_COMPATIBLE.before(IndexVersions.V_7_16_0));
                    bytesReferenceConsumer.accept(document, documentData);
                    continue;
                }
                int pageIndex = document.getField(PAGE_FIELD_NAME).numericValue().intValue();
                boolean bl = isLastPage = document.getField(LAST_PAGE_FIELD_NAME).numericValue().intValue() == 1;
                if (pageIndex == 0 && isLastPage) {
                    bytesReferenceConsumer.accept(document, PersistedClusterStateService.uncompress(documentData));
                    continue;
                }
                String key = keyFunction.apply(document);
                PaginatedDocumentReader reader = documentReaders.computeIfAbsent(key, k -> new PaginatedDocumentReader());
                BytesReference bytesReference = reader.addPage(key, documentData, pageIndex, isLastPage);
                if (bytesReference == null) continue;
                documentReaders.remove(key);
                bytesReferenceConsumer.accept(document, PersistedClusterStateService.uncompress(bytesReference));
            }
        }
        if (!documentReaders.isEmpty()) {
            throw new CorruptStateException("incomplete paginated documents " + String.valueOf(documentReaders.keySet()) + " when reading cluster state index [type=" + type + "]");
        }
    }

    private static BytesReference uncompress(BytesReference bytesReference) throws IOException {
        try {
            return CompressorFactory.COMPRESSOR.uncompress(bytesReference);
        }
        catch (IOException e) {
            throw new CorruptStateException(e);
        }
    }

    @SuppressForbidden(reason="merges are only temporarily suppressed, the merge scheduler does not need changing")
    private static MergePolicy noMergePolicy() {
        return NoMergePolicy.INSTANCE;
    }

    private static MergePolicy defaultMergePolicy() {
        TieredMergePolicy mergePolicy = new TieredMergePolicy();
        mergePolicy.setDeletesPctAllowed(50.0);
        mergePolicy.setSegmentsPerTier(100.0);
        mergePolicy.setMaxMergeAtOnce(100);
        mergePolicy.setNoCFSRatio(1.0);
        mergePolicy.setFloorSegmentMB(0.001);
        return mergePolicy;
    }

    static {
        Map<String, String> params = Maps.newMapWithExpectedSize(4);
        params.put("binary", "true");
        params.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
        params.put("deduplicated_mappings", Boolean.TRUE.toString());
        params.put("multi-project", "true");
        FORMAT_PARAMS = new ToXContent.MapParams(params);
    }

    private static class MetadataIndexWriter
    implements Closeable {
        private final Logger logger;
        private final Path path;
        private final Directory directory;
        private final IndexWriter indexWriter;
        private final boolean supportsMultipleProjects;

        MetadataIndexWriter(Path path, Directory directory, IndexWriter indexWriter, boolean supportsMultipleProjects) {
            this.path = path;
            this.directory = directory;
            this.indexWriter = indexWriter;
            this.logger = Loggers.getLogger(MetadataIndexWriter.class, directory.toString());
            this.supportsMultipleProjects = supportsMultipleProjects;
        }

        void deleteAll() throws IOException {
            this.logger.trace("clearing existing metadata");
            this.indexWriter.deleteAll();
        }

        public void deleteGlobalMetadata() throws IOException {
            this.logger.trace("deleting global metadata docs");
            this.indexWriter.deleteDocuments(new Term(PersistedClusterStateService.TYPE_FIELD_NAME, PersistedClusterStateService.GLOBAL_TYPE_NAME));
        }

        void deleteIndexMetadata(String indexUUID) throws IOException {
            this.logger.trace("removing metadata for [{}]", (Object)indexUUID);
            this.indexWriter.deleteDocuments(new Term(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, indexUUID));
        }

        public void deleteMappingMetadata(ProjectId projectId, String mappingHash) throws IOException {
            this.logger.trace("removing mapping metadata for [{}] on project [{}]", (Object)mappingHash, (Object)projectId);
            if (this.supportsMultipleProjects) {
                BooleanQuery matchProjectIdAndMappingHashKey = new BooleanQuery.Builder().add(new TermQuery(new Term(PersistedClusterStateService.PROJECT_ID_FIELD_NAME, projectId.id())), BooleanClause.Occur.MUST).add(new TermQuery(new Term(PersistedClusterStateService.MAPPING_HASH_FIELD_NAME, mappingHash)), BooleanClause.Occur.MUST).build();
                this.indexWriter.deleteDocuments(matchProjectIdAndMappingHashKey);
            } else {
                assert (Metadata.DEFAULT_PROJECT_ID.equals(projectId)) : "expected default project id, got " + String.valueOf(projectId);
                this.indexWriter.deleteDocuments(new Term(PersistedClusterStateService.MAPPING_HASH_FIELD_NAME, mappingHash));
            }
        }

        void flush() throws IOException {
            this.logger.trace("flushing");
            this.indexWriter.flush();
        }

        void startWrite() {
            this.indexWriter.getConfig().setMergePolicy(NO_MERGE_POLICY);
        }

        void prepareCommit(String nodeId, long currentTerm, long lastAcceptedVersion, IndexVersion oldestIndexVersion, String clusterUUID, boolean clusterUUIDCommitted) throws IOException {
            this.indexWriter.getConfig().setMergePolicy(DEFAULT_MERGE_POLICY);
            this.indexWriter.maybeMerge();
            Map<String, String> commitData = Maps.newMapWithExpectedSize(7);
            commitData.put(PersistedClusterStateService.CURRENT_TERM_KEY, Long.toString(currentTerm));
            commitData.put(PersistedClusterStateService.LAST_ACCEPTED_VERSION_KEY, Long.toString(lastAcceptedVersion));
            commitData.put(PersistedClusterStateService.NODE_VERSION_KEY, BuildVersion.current().toNodeMetadata());
            commitData.put(PersistedClusterStateService.OLDEST_INDEX_VERSION_KEY, Integer.toString(oldestIndexVersion.id()));
            commitData.put(PersistedClusterStateService.NODE_ID_KEY, nodeId);
            commitData.put(PersistedClusterStateService.CLUSTER_UUID_KEY, clusterUUID);
            commitData.put(PersistedClusterStateService.CLUSTER_UUID_COMMITTED_KEY, Boolean.toString(clusterUUIDCommitted));
            this.indexWriter.setLiveCommitData(commitData.entrySet());
            this.indexWriter.prepareCommit();
        }

        void commit() throws IOException {
            this.indexWriter.commit();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.indexWriter, this.directory);
        }
    }

    public static class Writer
    implements Closeable {
        private final List<MetadataIndexWriter> metadataIndexWriters;
        private final String nodeId;
        private final LongSupplier relativeTimeMillisSupplier;
        private final Supplier<TimeValue> slowWriteLoggingThresholdSupplier;
        boolean fullStateWritten = false;
        private final AtomicBoolean closed = new AtomicBoolean();
        private final byte[] documentBuffer;
        @Nullable
        private final CheckedBiConsumer<Path, DirectoryReader, IOException> assertOnCommit;

        private Writer(List<MetadataIndexWriter> metadataIndexWriters, String nodeId, ByteSizeValue documentPageSize, LongSupplier relativeTimeMillisSupplier, Supplier<TimeValue> slowWriteLoggingThresholdSupplier, @Nullable CheckedBiConsumer<Path, DirectoryReader, IOException> assertOnCommit) {
            this.metadataIndexWriters = metadataIndexWriters;
            this.nodeId = nodeId;
            this.relativeTimeMillisSupplier = relativeTimeMillisSupplier;
            this.slowWriteLoggingThresholdSupplier = slowWriteLoggingThresholdSupplier;
            this.documentBuffer = new byte[ByteSizeUnit.BYTES.toIntBytes(documentPageSize.getBytes())];
            this.assertOnCommit = assertOnCommit;
        }

        private void ensureOpen() {
            if (this.closed.get()) {
                throw new AlreadyClosedException("cluster state writer is closed already");
            }
        }

        public boolean isOpen() {
            return !this.closed.get();
        }

        private void closeIfAnyIndexWriterHasTragedyOrIsClosed() {
            if (this.metadataIndexWriters.stream().map(writer -> writer.indexWriter).anyMatch(iw -> iw.getTragicException() != null || !iw.isOpen())) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    logger.warn("failed on closing cluster state writer", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFullStateAndCommit(long currentTerm, ClusterState clusterState) throws IOException {
            this.ensureOpen();
            try {
                long startTimeMillis = this.relativeTimeMillisSupplier.getAsLong();
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.startWrite();
                }
                Metadata metadata = clusterState.metadata();
                WriterStats stats = this.overwriteMetadata(metadata);
                this.commit(currentTerm, clusterState.version(), metadata.oldestIndexVersionAllProjects(), metadata.clusterUUID(), metadata.clusterUUIDCommitted());
                this.fullStateWritten = true;
                long durationMillis = this.relativeTimeMillisSupplier.getAsLong() - startTimeMillis;
                TimeValue finalSlowWriteLoggingThreshold = this.slowWriteLoggingThresholdSupplier.get();
                if (durationMillis >= finalSlowWriteLoggingThreshold.getMillis()) {
                    logger.warn("writing full cluster state took [{}ms] which is above the warn threshold of [{}]; {}", (Object)durationMillis, (Object)finalSlowWriteLoggingThreshold, (Object)stats);
                } else {
                    logger.debug("writing full cluster state took [{}ms]; {}", (Object)durationMillis, (Object)stats);
                }
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeIncrementalStateAndCommit(long currentTerm, ClusterState previousClusterState, ClusterState clusterState) throws IOException {
            this.ensureOpen();
            this.ensureFullStateWritten();
            try {
                long startTimeMillis = this.relativeTimeMillisSupplier.getAsLong();
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.startWrite();
                }
                Metadata metadata = clusterState.metadata();
                WriterStats stats = this.updateMetadata(previousClusterState.metadata(), metadata);
                this.commit(currentTerm, clusterState.version(), metadata.oldestIndexVersionAllProjects(), metadata.clusterUUID(), metadata.clusterUUIDCommitted());
                long durationMillis = this.relativeTimeMillisSupplier.getAsLong() - startTimeMillis;
                TimeValue finalSlowWriteLoggingThreshold = this.slowWriteLoggingThresholdSupplier.get();
                if (durationMillis >= finalSlowWriteLoggingThreshold.getMillis()) {
                    logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; {}", (Object)durationMillis, (Object)finalSlowWriteLoggingThreshold, (Object)stats);
                } else {
                    logger.debug("writing cluster state took [{}ms]; {}", (Object)durationMillis, (Object)stats);
                }
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        private void ensureFullStateWritten() {
            assert (this.fullStateWritten) : "Need to write full state first before doing incremental writes";
            if (!this.fullStateWritten) {
                logger.error("cannot write incremental state");
                throw new IllegalStateException("cannot write incremental state");
            }
        }

        private WriterStats updateMetadata(Metadata previouslyWrittenMetadata, Metadata metadata) throws IOException {
            boolean updateGlobalMeta;
            assert (previouslyWrittenMetadata.coordinationMetadata().term() == metadata.coordinationMetadata().term());
            logger.trace("currentTerm [{}] matches previous currentTerm, writing changes only", (Object)metadata.coordinationMetadata().term());
            if (previouslyWrittenMetadata == metadata) {
                return new WriterStats(false, false, metadata.projects().values().stream().map(ProjectMetadata::getMappingsByHash).mapToInt(Map::size).sum(), 0, 0, metadata.projects().values().stream().mapToInt(ProjectMetadata::size).sum(), 0, 0, 0);
            }
            boolean bl = updateGlobalMeta = !Metadata.isGlobalStateEquals(previouslyWrittenMetadata, metadata);
            if (updateGlobalMeta) {
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.deleteGlobalMetadata();
                }
                this.addGlobalMetadataDocuments(metadata);
            }
            int numMappingsAdded = 0;
            int numMappingsRemoved = 0;
            int numMappingsUnchanged = 0;
            int numIndicesAdded = 0;
            int numIndicesUpdated = 0;
            int numIndicesRemoved = 0;
            int numIndicesUnchanged = 0;
            for (ProjectMetadata project : metadata.projects().values()) {
                ProjectId projectId = project.id();
                ProjectMetadata previousProject = previouslyWrittenMetadata.projects().get(projectId);
                if (previousProject == null) {
                    for (Map.Entry<String, MappingMetadata> entry : project.getMappingsByHash().entrySet()) {
                        this.addMappingDocuments(projectId, entry.getKey(), entry.getValue());
                        ++numMappingsAdded;
                    }
                    for (IndexMetadata indexMetadata2 : project.indices().values()) {
                        this.addIndexMetadataDocuments(projectId, indexMetadata2);
                        ++numIndicesAdded;
                    }
                    continue;
                }
                HashSet<String> previousMappingHashes = new HashSet<String>(previousProject.getMappingsByHash().keySet());
                for (Map.Entry<String, MappingMetadata> entry : project.getMappingsByHash().entrySet()) {
                    if (!previousMappingHashes.remove(entry.getKey())) {
                        this.addMappingDocuments(projectId, entry.getKey(), entry.getValue());
                        ++numMappingsAdded;
                        continue;
                    }
                    logger.trace("no action required for mapping [{}]", (Object)entry.getKey());
                    ++numMappingsUnchanged;
                }
                for (String unusedMappingHash : previousMappingHashes) {
                    for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                        metadataIndexWriter.deleteMappingMetadata(projectId, unusedMappingHash);
                        ++numMappingsRemoved;
                    }
                }
                Map map = Maps.newMapWithExpectedSize(previousProject.indices().size());
                previousProject.indices().forEach((name, indexMetadata) -> {
                    Long previousValue = indexMetadataVersionByUUID.putIfAbsent(indexMetadata.getIndexUUID(), indexMetadata.getVersion());
                    assert (previousValue == null) : indexMetadata.getIndexUUID() + " already mapped to " + previousValue;
                });
                for (IndexMetadata indexMetadata3 : project.indices().values()) {
                    Long previousVersion = (Long)map.get(indexMetadata3.getIndexUUID());
                    if (previousVersion == null || indexMetadata3.getVersion() != previousVersion.longValue()) {
                        logger.trace("updating metadata for [{}], changing version from [{}] to [{}]", (Object)indexMetadata3.getIndex(), (Object)previousVersion, (Object)indexMetadata3.getVersion());
                        if (previousVersion == null) {
                            ++numIndicesAdded;
                        } else {
                            ++numIndicesUpdated;
                        }
                        for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                            metadataIndexWriter.deleteIndexMetadata(indexMetadata3.getIndexUUID());
                        }
                        this.addIndexMetadataDocuments(projectId, indexMetadata3);
                    } else {
                        ++numIndicesUnchanged;
                        logger.trace("no action required for index [{}]", (Object)indexMetadata3.getIndex());
                    }
                    map.remove(indexMetadata3.getIndexUUID());
                }
                for (String removedIndexUUID : map.keySet()) {
                    for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                        ++numIndicesRemoved;
                        metadataIndexWriter.deleteIndexMetadata(removedIndexUUID);
                    }
                }
            }
            for (ProjectMetadata removedProject : previouslyWrittenMetadata.projects().values()) {
                if (metadata.projects().containsKey(removedProject.id())) continue;
                for (String unusedMappingHash : removedProject.getMappingsByHash().keySet()) {
                    for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                        metadataIndexWriter.deleteMappingMetadata(removedProject.id(), unusedMappingHash);
                        ++numMappingsRemoved;
                    }
                }
                for (IndexMetadata removedIndexMetadata : removedProject.indices().values()) {
                    for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                        ++numIndicesRemoved;
                        metadataIndexWriter.deleteIndexMetadata(removedIndexMetadata.getIndexUUID());
                    }
                }
            }
            for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                metadataIndexWriter.flush();
            }
            return new WriterStats(false, updateGlobalMeta, numMappingsUnchanged, numMappingsAdded, numMappingsRemoved, numIndicesUnchanged, numIndicesAdded, numIndicesUpdated, numIndicesRemoved);
        }

        private static int lastPageValue(boolean isLastPage) {
            return isLastPage ? 1 : 0;
        }

        private void addMappingDocuments(ProjectId projectId, String key, MappingMetadata mappingMetadata) throws IOException {
            logger.trace("writing mapping metadata with hash [{}] on project [{}]", (Object)key, (Object)projectId);
            this.writePages((builder, params) -> builder.field("content", mappingMetadata.source().compressed()), (bytesRef, pageIndex, isLastPage) -> {
                Document document = new Document();
                document.add(new StringField(PersistedClusterStateService.TYPE_FIELD_NAME, PersistedClusterStateService.MAPPING_TYPE_NAME, Field.Store.NO));
                document.add(new StringField(PersistedClusterStateService.MAPPING_HASH_FIELD_NAME, key, Field.Store.YES));
                document.add(new StoredField(PersistedClusterStateService.PAGE_FIELD_NAME, pageIndex));
                document.add(new StoredField(PersistedClusterStateService.LAST_PAGE_FIELD_NAME, Writer.lastPageValue(isLastPage)));
                document.add(new StoredField(PersistedClusterStateService.DATA_FIELD_NAME, bytesRef));
                document.add(new StringField(PersistedClusterStateService.PROJECT_ID_FIELD_NAME, projectId.id(), Field.Store.YES));
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.indexWriter.addDocument(document);
                }
            });
        }

        private void addIndexMetadataDocuments(ProjectId projectId, IndexMetadata indexMetadata) throws IOException {
            String indexUUID = indexMetadata.getIndexUUID();
            assert (!indexUUID.equals("_na_"));
            logger.trace("updating metadata for [{}] on project [{}]", (Object)indexMetadata.getIndex(), (Object)projectId);
            this.writePages(indexMetadata, (bytesRef, pageIndex, isLastPage) -> {
                Document document = new Document();
                document.add(new StringField(PersistedClusterStateService.TYPE_FIELD_NAME, PersistedClusterStateService.INDEX_TYPE_NAME, Field.Store.NO));
                document.add(new StringField(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, indexUUID, Field.Store.YES));
                document.add(new StoredField(PersistedClusterStateService.PAGE_FIELD_NAME, pageIndex));
                document.add(new StoredField(PersistedClusterStateService.LAST_PAGE_FIELD_NAME, Writer.lastPageValue(isLastPage)));
                document.add(new StoredField(PersistedClusterStateService.DATA_FIELD_NAME, bytesRef));
                document.add(new StringField(PersistedClusterStateService.PROJECT_ID_FIELD_NAME, projectId.id(), Field.Store.YES));
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.indexWriter.addDocument(document);
                }
            });
        }

        private void addGlobalMetadataDocuments(Metadata metadata) throws IOException {
            logger.trace("updating global metadata doc");
            this.writePages(ChunkedToXContent.wrapAsToXContent(metadata), (bytesRef, pageIndex, isLastPage) -> {
                Document document = new Document();
                document.add(new StringField(PersistedClusterStateService.TYPE_FIELD_NAME, PersistedClusterStateService.GLOBAL_TYPE_NAME, Field.Store.NO));
                document.add(new StoredField(PersistedClusterStateService.PAGE_FIELD_NAME, pageIndex));
                document.add(new StoredField(PersistedClusterStateService.LAST_PAGE_FIELD_NAME, Writer.lastPageValue(isLastPage)));
                document.add(new StoredField(PersistedClusterStateService.DATA_FIELD_NAME, bytesRef));
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.indexWriter.addDocument(document);
                }
            });
        }

        private void writePages(ToXContent metadata, PageWriter pageWriter) throws IOException {
            try (PageWriterOutputStream paginatedStream = new PageWriterOutputStream(this.documentBuffer, pageWriter);
                 OutputStream compressedStream = CompressorFactory.COMPRESSOR.threadLocalOutputStream(paginatedStream);
                 XContentBuilder xContentBuilder = XContentFactory.contentBuilder(XContentType.SMILE, compressedStream);){
                xContentBuilder.startObject();
                metadata.toXContent(xContentBuilder, FORMAT_PARAMS);
                xContentBuilder.endObject();
            }
        }

        private WriterStats overwriteMetadata(Metadata metadata) throws IOException {
            for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                metadataIndexWriter.deleteAll();
            }
            return this.addMetadata(metadata);
        }

        private WriterStats addMetadata(Metadata metadata) throws IOException {
            this.addGlobalMetadataDocuments(metadata);
            for (ProjectMetadata project : metadata.projects().values()) {
                for (Map.Entry<String, MappingMetadata> entry : project.getMappingsByHash().entrySet()) {
                    this.addMappingDocuments(project.id(), entry.getKey(), entry.getValue());
                }
                for (IndexMetadata indexMetadata : project.indices().values()) {
                    this.addIndexMetadataDocuments(project.id(), indexMetadata);
                }
            }
            for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                metadataIndexWriter.flush();
            }
            return new WriterStats(true, true, 0, metadata.projects().values().stream().map(ProjectMetadata::getMappingsByHash).mapToInt(Map::size).sum(), 0, 0, metadata.projects().values().stream().mapToInt(ProjectMetadata::size).sum(), 0, 0);
        }

        public void writeIncrementalTermUpdateAndCommit(long currentTerm, long lastAcceptedVersion, IndexVersion oldestIndexVersion, String clusterUUID, boolean clusterUUIDCommitted) throws IOException {
            this.ensureOpen();
            this.ensureFullStateWritten();
            this.commit(currentTerm, lastAcceptedVersion, oldestIndexVersion, clusterUUID, clusterUUIDCommitted);
        }

        void commit(long currentTerm, long lastAcceptedVersion, IndexVersion oldestIndexVersion, String clusterUUID, boolean clusterUUIDCommitted) throws IOException {
            this.ensureOpen();
            this.prepareCommit(currentTerm, lastAcceptedVersion, oldestIndexVersion, clusterUUID, clusterUUIDCommitted);
            this.completeCommit();
            assert (this.assertOnCommit());
        }

        private boolean assertOnCommit() {
            if (this.assertOnCommit != null && Randomness.get().nextInt(100) == 0) {
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    try {
                        DirectoryReader directoryReader = DirectoryReader.open(metadataIndexWriter.indexWriter);
                        try {
                            this.assertOnCommit.accept(metadataIndexWriter.path, directoryReader);
                        }
                        finally {
                            if (directoryReader == null) continue;
                            directoryReader.close();
                        }
                    }
                    catch (Exception e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
            return true;
        }

        private void prepareCommit(long currentTerm, long lastAcceptedVersion, IndexVersion oldestIndexVersion, String clusterUUID, boolean clusterUUIDCommitted) throws IOException {
            boolean prepareCommitSuccess = false;
            try {
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.prepareCommit(this.nodeId, currentTerm, lastAcceptedVersion, oldestIndexVersion, clusterUUID, clusterUUIDCommitted);
                }
                prepareCommitSuccess = true;
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    logger.warn("failed on closing cluster state writer", (Throwable)e2);
                    e.addSuppressed(e2);
                }
                throw e;
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
                if (!prepareCommitSuccess) {
                    this.closeAndSuppressExceptions();
                }
            }
        }

        private void completeCommit() {
            boolean commitSuccess = false;
            try {
                for (MetadataIndexWriter metadataIndexWriter : this.metadataIndexWriters) {
                    metadataIndexWriter.commit();
                }
                commitSuccess = true;
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                throw new IOError(e);
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
                if (!commitSuccess) {
                    this.closeAndSuppressExceptions();
                }
            }
        }

        private void closeAndSuppressExceptions() {
            if (this.closed.compareAndSet(false, true)) {
                logger.trace("closing PersistedClusterStateService.Writer suppressing any exceptions");
                IOUtils.closeWhileHandlingException(this.metadataIndexWriters);
            }
        }

        @Override
        public void close() throws IOException {
            logger.trace("closing PersistedClusterStateService.Writer");
            if (this.closed.compareAndSet(false, true)) {
                IOUtils.close(this.metadataIndexWriters);
            }
        }

        private record WriterStats(boolean isFullWrite, boolean globalMetaUpdated, int numMappingsUnchanged, int numMappingsAdded, int numMappingsRemoved, int numIndicesUnchanged, int numIndicesAdded, int numIndicesUpdated, int numIndicesRemoved) {
            @Override
            public String toString() {
                if (this.isFullWrite) {
                    return String.format(Locale.ROOT, "wrote global metadata, [%d] mappings, and metadata for [%d] indices", this.numMappingsAdded, this.numIndicesAdded);
                }
                return String.format(Locale.ROOT, "[%s] global metadata, wrote [%d] new mappings, removed [%d] mappings and skipped [%d] unchanged mappings, wrote metadata for [%d] new indices and [%d] existing indices, removed metadata for [%d] indices and skipped [%d] unchanged indices", this.globalMetaUpdated ? "wrote" : "skipped writing", this.numMappingsAdded, this.numMappingsRemoved, this.numMappingsUnchanged, this.numIndicesAdded, this.numIndicesUpdated, this.numIndicesRemoved, this.numIndicesUnchanged);
            }
        }
    }

    public static class OnDiskState {
        private static final OnDiskState NO_ON_DISK_STATE = new OnDiskState(null, null, 0L, 0L, null, false, Metadata.EMPTY_METADATA);
        private final String nodeId;
        private final Path dataPath;
        public final long currentTerm;
        public final long lastAcceptedVersion;
        @Nullable
        public final String clusterUUID;
        @Nullable
        public final Boolean clusterUUIDCommitted;
        public final Metadata metadata;

        private OnDiskState(String nodeId, Path dataPath, long currentTerm, long lastAcceptedVersion, String clusterUUID, Boolean clusterUUIDCommitted, Metadata metadata) {
            this.nodeId = nodeId;
            this.dataPath = dataPath;
            this.currentTerm = currentTerm;
            this.lastAcceptedVersion = lastAcceptedVersion;
            this.clusterUUID = clusterUUID;
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            this.metadata = metadata;
        }

        public boolean empty() {
            return this == NO_ON_DISK_STATE;
        }
    }

    public record OnDiskStateMetadata(long currentTerm, long lastAcceptedVersion, String nodeId, @Nullable String clusterUUID, @Nullable Boolean clusterUUIDCommitted) {
    }

    private static class PaginatedDocumentReader {
        private final ArrayList<BytesReference> pages = new ArrayList();
        private int emptyPages;
        private int pageCount = -1;

        private PaginatedDocumentReader() {
        }

        @Nullable
        BytesReference addPage(String key, BytesReference bytesReference, int pageIndex, boolean isLastPage) throws CorruptStateException {
            while (this.pages.size() < pageIndex) {
                if (this.pageCount != -1) {
                    throw new CorruptStateException("found page [" + pageIndex + "] but last page was [" + this.pageCount + "] when reading key [" + key + "] from cluster state index");
                }
                ++this.emptyPages;
                this.pages.add(null);
            }
            if (this.pages.size() == pageIndex) {
                this.pages.add(bytesReference);
            } else {
                if (this.pages.get(pageIndex) != null) {
                    throw new CorruptStateException("found duplicate page [" + pageIndex + "] when reading key [" + key + "] from cluster state index");
                }
                --this.emptyPages;
                this.pages.set(pageIndex, bytesReference);
            }
            if (isLastPage) {
                if (this.pageCount != -1) {
                    throw new CorruptStateException("already read page count " + this.pageCount + " but page " + pageIndex + " is also marked as the last page when reading key [" + key + "] from cluster state index");
                }
                this.pageCount = pageIndex + 1;
                if (this.pages.size() != this.pageCount) {
                    throw new CorruptStateException("already read " + this.pages.size() + " pages but page " + pageIndex + " is marked as the last page");
                }
            }
            if (this.pageCount != -1 && this.emptyPages == 0) {
                return CompositeBytesReference.of(this.pages.toArray(new BytesReference[0]));
            }
            return null;
        }
    }

    private static class PageWriterOutputStream
    extends OutputStream {
        private final byte[] buffer;
        private final PageWriter pageWriter;
        private int bufferPosition;
        private int pageIndex;
        private int bytesFlushed;
        private boolean closed;

        PageWriterOutputStream(byte[] buffer, PageWriter pageWriter) {
            assert (buffer.length > 0);
            this.buffer = buffer;
            this.pageWriter = pageWriter;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            assert (!this.closed) : "cannot write after close";
            while (len > 0) {
                if (this.bufferPosition == this.buffer.length) {
                    this.flushPage(false);
                }
                assert (this.bufferPosition < this.buffer.length);
                int lenToBuffer = Math.min(len, this.buffer.length - this.bufferPosition);
                System.arraycopy(b, off, this.buffer, this.bufferPosition, lenToBuffer);
                this.bufferPosition += lenToBuffer;
                off += lenToBuffer;
                len -= lenToBuffer;
            }
        }

        @Override
        public void write(int b) throws IOException {
            assert (!this.closed) : "cannot write after close";
            if (this.bufferPosition == this.buffer.length) {
                this.flushPage(false);
            }
            assert (this.bufferPosition < this.buffer.length);
            this.buffer[this.bufferPosition++] = (byte)b;
        }

        @Override
        public void flush() throws IOException {
            assert (!this.closed) : "must not flush after close";
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.flushPage(true);
            }
        }

        private void flushPage(boolean isLastPage) throws IOException {
            assert (this.bufferPosition > 0) : "cannot flush empty page";
            assert (this.bufferPosition == this.buffer.length || isLastPage) : "only the last page may be incomplete";
            if (this.bytesFlushed > Integer.MAX_VALUE - this.bufferPosition) {
                throw new IllegalArgumentException("cannot persist cluster state document larger than 2GB");
            }
            this.bytesFlushed += this.bufferPosition;
            this.pageWriter.consumePage(new BytesRef(this.buffer, 0, this.bufferPosition), this.pageIndex, isLastPage);
            ++this.pageIndex;
            this.bufferPosition = 0;
        }
    }

    private static interface PageWriter {
        public void consumePage(BytesRef var1, int var2, boolean var3) throws IOException;
    }
}

