/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;

public final class SearchRequestAttributesExtractor {
    private static final Logger logger = LogManager.getLogger(SearchRequestAttributesExtractor.class);
    static final String TARGET_ATTRIBUTE = "target";
    static final String SORT_ATTRIBUTE = "sort";
    static final String QUERY_TYPE_ATTRIBUTE = "query_type";
    static final String PIT_SCROLL_ATTRIBUTE = "pit_scroll";
    static final String KNN_ATTRIBUTE = "knn";
    static final String RANGE_TIMESTAMP_ATTRIBUTE = "range_timestamp";
    static final String RANGE_EVENT_INGESTED_ATTRIBUTE = "range_event_ingested";
    static final String TIMESTAMP_RANGE_FILTER_ATTRIBUTE = "timestamp_range_filter";
    private static final String TARGET_KIBANA = ".kibana";
    private static final String TARGET_ML = ".ml";
    private static final String TARGET_FLEET = ".fleet";
    private static final String TARGET_SLO = ".slo";
    private static final String TARGET_ALERTS = ".alerts";
    private static final String TARGET_ELASTIC = ".elastic";
    private static final String TARGET_DS = ".ds-";
    private static final String TARGET_OTHERS = ".others";
    private static final String TARGET_USER = "user";
    private static final String ERROR = "error";
    private static final String TIMESTAMP = "@timestamp";
    private static final String EVENT_INGESTED = "event.ingested";
    private static final String _DOC = "_doc";
    private static final String FIELD = "field";
    private static final String HITS_AND_AGGS = "hits_and_aggs";
    private static final String HITS_ONLY = "hits_only";
    private static final String AGGS_ONLY = "aggs_only";
    private static final String COUNT_ONLY = "count_only";
    private static final String PIT = "pit";
    private static final String SCROLL = "scroll";
    public static final String SYSTEM_THREAD_ATTRIBUTE_NAME = "system_thread";
    public static final Map<String, Object> SEARCH_SCROLL_ATTRIBUTES = Map.of("query_type", "scroll");

    private SearchRequestAttributesExtractor() {
    }

    public static Map<String, Object> extractAttributes(SearchRequest searchRequest, String[] localIndices) {
        return SearchRequestAttributesExtractor.extractAttributes(searchRequest.source(), searchRequest.scroll(), null, -1L, localIndices);
    }

    public static Map<String, Object> extractAttributes(ShardSearchRequest shardSearchRequest, Long rangeTimestampFrom, long nowInMillis) {
        Map<String, Object> attributes = SearchRequestAttributesExtractor.extractAttributes(shardSearchRequest.source(), shardSearchRequest.scroll(), rangeTimestampFrom, nowInMillis, shardSearchRequest.shardId().getIndexName());
        boolean isSystem = ((EsExecutors.EsThread)Thread.currentThread()).isSystem();
        attributes.put(SYSTEM_THREAD_ATTRIBUTE_NAME, isSystem);
        return attributes;
    }

    private static Map<String, Object> extractAttributes(SearchSourceBuilder searchSourceBuilder, TimeValue scroll, Long rangeTimestampFrom, long nowInMillis, String ... localIndices) {
        String target = SearchRequestAttributesExtractor.extractIndices(localIndices);
        String pitOrScroll = null;
        if (scroll != null) {
            pitOrScroll = SCROLL;
        }
        if (searchSourceBuilder == null) {
            return SearchRequestAttributesExtractor.buildAttributesMap(target, "_score", HITS_ONLY, false, false, false, pitOrScroll, null);
        }
        if (searchSourceBuilder.pointInTimeBuilder() != null) {
            pitOrScroll = PIT;
        }
        String primarySort = searchSourceBuilder.sorts() == null || searchSourceBuilder.sorts().isEmpty() ? "_score" : SearchRequestAttributesExtractor.extractPrimarySort(searchSourceBuilder.sorts().getFirst());
        String queryType = SearchRequestAttributesExtractor.extractQueryType(searchSourceBuilder);
        QueryMetadataBuilder queryMetadataBuilder = new QueryMetadataBuilder();
        if (searchSourceBuilder.query() != null) {
            try {
                SearchRequestAttributesExtractor.introspectQueryBuilder(searchSourceBuilder.query(), queryMetadataBuilder, 0);
            }
            catch (Exception e) {
                logger.error("Failed to extract query attribute", (Throwable)e);
            }
        }
        boolean hasKnn = !searchSourceBuilder.knnSearch().isEmpty() || queryMetadataBuilder.knnQuery;
        String timestampRangeFilter = null;
        if (rangeTimestampFrom != null) {
            timestampRangeFilter = SearchRequestAttributesExtractor.introspectTimeRange(rangeTimestampFrom, nowInMillis);
        }
        return SearchRequestAttributesExtractor.buildAttributesMap(target, primarySort, queryType, hasKnn, queryMetadataBuilder.rangeOnTimestamp, queryMetadataBuilder.rangeOnEventIngested, pitOrScroll, timestampRangeFilter);
    }

    private static Map<String, Object> buildAttributesMap(String target, String primarySort, String queryType, boolean knn, boolean rangeOnTimestamp, boolean rangeOnEventIngested, String pitOrScroll, String timestampRangeFilter) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(5, 1.0f);
        attributes.put(TARGET_ATTRIBUTE, target);
        attributes.put(SORT_ATTRIBUTE, primarySort);
        attributes.put(QUERY_TYPE_ATTRIBUTE, queryType);
        if (pitOrScroll != null) {
            attributes.put(PIT_SCROLL_ATTRIBUTE, pitOrScroll);
        }
        if (knn) {
            attributes.put(KNN_ATTRIBUTE, knn);
        }
        if (rangeOnTimestamp) {
            attributes.put(RANGE_TIMESTAMP_ATTRIBUTE, rangeOnTimestamp);
        }
        if (rangeOnEventIngested) {
            attributes.put(RANGE_EVENT_INGESTED_ATTRIBUTE, rangeOnEventIngested);
        }
        if (timestampRangeFilter != null) {
            attributes.put(TIMESTAMP_RANGE_FILTER_ATTRIBUTE, timestampRangeFilter);
        }
        return attributes;
    }

    static String extractIndices(String ... indices) {
        try {
            if (indices.length == 1) {
                String index = indices[0];
                assert (!Regex.isSimpleMatchPattern(index));
                if (index.startsWith(".")) {
                    if (index.startsWith(TARGET_KIBANA)) {
                        return TARGET_KIBANA;
                    }
                    if (index.startsWith(TARGET_ML)) {
                        return TARGET_ML;
                    }
                    if (index.startsWith(TARGET_FLEET)) {
                        return TARGET_FLEET;
                    }
                    if (index.startsWith(TARGET_SLO)) {
                        return TARGET_SLO;
                    }
                    if (index.startsWith(TARGET_ALERTS)) {
                        return TARGET_ALERTS;
                    }
                    if (index.startsWith(TARGET_ELASTIC)) {
                        return TARGET_ELASTIC;
                    }
                    if (index.startsWith(TARGET_DS)) {
                        return TARGET_DS;
                    }
                    return TARGET_OTHERS;
                }
            }
            return TARGET_USER;
        }
        catch (Exception e) {
            logger.error("Failed to extract indices attribute", (Throwable)e);
            return ERROR;
        }
    }

    static String extractPrimarySort(SortBuilder<?> primarySortBuilder) {
        try {
            if (primarySortBuilder instanceof FieldSortBuilder) {
                FieldSortBuilder fieldSort = (FieldSortBuilder)primarySortBuilder;
                return switch (fieldSort.getFieldName()) {
                    case TIMESTAMP -> TIMESTAMP;
                    case EVENT_INGESTED -> EVENT_INGESTED;
                    case _DOC -> _DOC;
                    default -> FIELD;
                };
            }
            return primarySortBuilder.getWriteableName();
        }
        catch (Exception e) {
            logger.error("Failed to extract primary sort attribute", (Throwable)e);
            return ERROR;
        }
    }

    static String extractQueryType(SearchSourceBuilder searchSourceBuilder) {
        try {
            int size = searchSourceBuilder.size();
            if (size == -1) {
                size = 10;
            }
            if (searchSourceBuilder.aggregations() != null && size > 0) {
                return HITS_AND_AGGS;
            }
            if (searchSourceBuilder.aggregations() != null) {
                return AGGS_ONLY;
            }
            if (size > 0) {
                return HITS_ONLY;
            }
            return COUNT_ONLY;
        }
        catch (Exception e) {
            logger.error("Failed to extract query type attribute", (Throwable)e);
            return ERROR;
        }
    }

    private static void introspectQueryBuilder(QueryBuilder queryBuilder, QueryMetadataBuilder queryMetadataBuilder, int level) {
        if (level > 20) {
            return;
        }
        QueryBuilder queryBuilder2 = queryBuilder;
        Objects.requireNonNull(queryBuilder2);
        QueryBuilder queryBuilder3 = queryBuilder2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BoolQueryBuilder.class, ConstantScoreQueryBuilder.class, BoostingQueryBuilder.class, NestedQueryBuilder.class, RangeQueryBuilder.class, KnnVectorQueryBuilder.class}, (Object)queryBuilder3, n)) {
            case 0: {
                BoolQueryBuilder bool = (BoolQueryBuilder)queryBuilder3;
                for (QueryBuilder must : bool.must()) {
                    SearchRequestAttributesExtractor.introspectQueryBuilder(must, queryMetadataBuilder, ++level);
                }
                for (QueryBuilder filter : bool.filter()) {
                    SearchRequestAttributesExtractor.introspectQueryBuilder(filter, queryMetadataBuilder, ++level);
                }
                if (!bool.must().isEmpty() || !bool.filter().isEmpty() || !bool.mustNot().isEmpty() || bool.should().size() != 1) break;
                SearchRequestAttributesExtractor.introspectQueryBuilder(bool.should().getFirst(), queryMetadataBuilder, ++level);
                break;
            }
            case 1: {
                ConstantScoreQueryBuilder constantScore = (ConstantScoreQueryBuilder)queryBuilder3;
                SearchRequestAttributesExtractor.introspectQueryBuilder(constantScore.innerQuery(), queryMetadataBuilder, ++level);
                break;
            }
            case 2: {
                BoostingQueryBuilder boosting = (BoostingQueryBuilder)queryBuilder3;
                SearchRequestAttributesExtractor.introspectQueryBuilder(boosting.positiveQuery(), queryMetadataBuilder, ++level);
                break;
            }
            case 3: {
                NestedQueryBuilder nested = (NestedQueryBuilder)queryBuilder3;
                SearchRequestAttributesExtractor.introspectQueryBuilder(nested.query(), queryMetadataBuilder, ++level);
                break;
            }
            case 4: {
                RangeQueryBuilder range = (RangeQueryBuilder)queryBuilder3;
                switch (range.fieldName()) {
                    case "@timestamp": {
                        if (range.to() == null && range.from() == null) break;
                        queryMetadataBuilder.rangeOnTimestamp = true;
                        break;
                    }
                    case "event.ingested": {
                        if (range.to() == null && range.from() == null) break;
                        queryMetadataBuilder.rangeOnEventIngested = true;
                    }
                }
                break;
            }
            case 5: {
                KnnVectorQueryBuilder knn = (KnnVectorQueryBuilder)queryBuilder3;
                queryMetadataBuilder.knnQuery = true;
                break;
            }
        }
    }

    static String introspectTimeRange(long timeRangeFrom, long nowInMillis) {
        for (TimeRangeBucket value : TimeRangeBucket.values()) {
            if (timeRangeFrom < nowInMillis - value.millis) continue;
            return value.bucketName;
        }
        return "older_than_14_days";
    }

    private static final class QueryMetadataBuilder {
        private boolean knnQuery = false;
        private boolean rangeOnTimestamp = false;
        private boolean rangeOnEventIngested = false;

        private QueryMetadataBuilder() {
        }
    }

    private static enum TimeRangeBucket {
        FifteenMinutes(TimeValue.timeValueMinutes(15L).getMillis(), "15_minutes"),
        OneHour(TimeValue.timeValueHours(1L).getMillis(), "1_hour"),
        TwelveHours(TimeValue.timeValueHours(12L).getMillis(), "12_hours"),
        OneDay(TimeValue.timeValueDays(1L).getMillis(), "1_day"),
        ThreeDays(TimeValue.timeValueDays(3L).getMillis(), "3_days"),
        SevenDays(TimeValue.timeValueDays(7L).getMillis(), "7_days"),
        FourteenDays(TimeValue.timeValueDays(14L).getMillis(), "14_days");

        private final long millis;
        private final String bucketName;

        private TimeRangeBucket(long millis, String bucketName) {
            this.millis = millis;
            this.bucketName = bucketName;
        }
    }
}

