/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.autosharding;

import java.util.Arrays;
import org.elasticsearch.action.datastreams.autosharding.AutoShardingType;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;

public record AutoShardingResult(AutoShardingType type, int currentNumberOfShards, int targetNumberOfShards, TimeValue coolDownRemaining) {
    static final String COOLDOWN_PREVENTING_TYPES = Arrays.toString((Object[])new AutoShardingType[]{AutoShardingType.COOLDOWN_PREVENTED_DECREASE, AutoShardingType.COOLDOWN_PREVENTED_INCREASE});
    public static final AutoShardingResult NOT_APPLICABLE_RESULT = new AutoShardingResult(AutoShardingType.NOT_APPLICABLE, -1, -1, TimeValue.MAX_VALUE);

    public AutoShardingResult {
        if ((type.equals((Object)AutoShardingType.INCREASE_SHARDS) || type.equals((Object)AutoShardingType.DECREASE_SHARDS)) && !coolDownRemaining.equals(TimeValue.ZERO)) {
            throw new IllegalArgumentException("The increase/decrease shards events must have a cooldown period of zero. Use one of [" + COOLDOWN_PREVENTING_TYPES + "] types indead");
        }
    }

    @Override
    public String toString() {
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case AutoShardingType.INCREASE_SHARDS -> Strings.format("Recommendation to increase shards from %d to %d", this.currentNumberOfShards, this.targetNumberOfShards);
            case AutoShardingType.DECREASE_SHARDS -> Strings.format("Recommendation to decrease shards from %d to %d", this.currentNumberOfShards, this.targetNumberOfShards);
            case AutoShardingType.COOLDOWN_PREVENTED_INCREASE -> Strings.format("Deferred recommendation to increase shards from %d to %d after cooldown period %s", this.currentNumberOfShards, this.targetNumberOfShards, this.coolDownRemaining);
            case AutoShardingType.COOLDOWN_PREVENTED_DECREASE -> Strings.format("Deferred recommendation to decrease shards from %d to %d after cooldown period %s", this.currentNumberOfShards, this.targetNumberOfShards, this.coolDownRemaining);
            case AutoShardingType.NO_CHANGE_REQUIRED -> Strings.format("Recommendation to leave shards unchanged at %d", this.currentNumberOfShards);
            case AutoShardingType.NOT_APPLICABLE -> "No recommendation as auto-sharding not enabled";
        };
    }
}

