/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ThreadCount
implements JsonpSerializable {
    @Nullable
    private final Long active;
    @Nullable
    private final Long completed;
    @Nullable
    private final Long largest;
    @Nullable
    private final Long queue;
    @Nullable
    private final Long rejected;
    @Nullable
    private final Long threads;
    public static final JsonpDeserializer<ThreadCount> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ThreadCount::setupThreadCountDeserializer);

    private ThreadCount(Builder builder) {
        this.active = builder.active;
        this.completed = builder.completed;
        this.largest = builder.largest;
        this.queue = builder.queue;
        this.rejected = builder.rejected;
        this.threads = builder.threads;
    }

    public static ThreadCount of(Function<Builder, ObjectBuilder<ThreadCount>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long active() {
        return this.active;
    }

    @Nullable
    public final Long completed() {
        return this.completed;
    }

    @Nullable
    public final Long largest() {
        return this.largest;
    }

    @Nullable
    public final Long queue() {
        return this.queue;
    }

    @Nullable
    public final Long rejected() {
        return this.rejected;
    }

    @Nullable
    public final Long threads() {
        return this.threads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.active != null) {
            generator.writeKey("active");
            generator.write(this.active);
        }
        if (this.completed != null) {
            generator.writeKey("completed");
            generator.write(this.completed);
        }
        if (this.largest != null) {
            generator.writeKey("largest");
            generator.write(this.largest);
        }
        if (this.queue != null) {
            generator.writeKey("queue");
            generator.write(this.queue);
        }
        if (this.rejected != null) {
            generator.writeKey("rejected");
            generator.write(this.rejected);
        }
        if (this.threads != null) {
            generator.writeKey("threads");
            generator.write(this.threads);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupThreadCountDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::active, JsonpDeserializer.longDeserializer(), "active");
        op.add(Builder::completed, JsonpDeserializer.longDeserializer(), "completed");
        op.add(Builder::largest, JsonpDeserializer.longDeserializer(), "largest");
        op.add(Builder::queue, JsonpDeserializer.longDeserializer(), "queue");
        op.add(Builder::rejected, JsonpDeserializer.longDeserializer(), "rejected");
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ThreadCount> {
        @Nullable
        private Long active;
        @Nullable
        private Long completed;
        @Nullable
        private Long largest;
        @Nullable
        private Long queue;
        @Nullable
        private Long rejected;
        @Nullable
        private Long threads;

        public final Builder active(@Nullable Long value) {
            this.active = value;
            return this;
        }

        public final Builder completed(@Nullable Long value) {
            this.completed = value;
            return this;
        }

        public final Builder largest(@Nullable Long value) {
            this.largest = value;
            return this;
        }

        public final Builder queue(@Nullable Long value) {
            this.queue = value;
            return this;
        }

        public final Builder rejected(@Nullable Long value) {
            this.rejected = value;
            return this;
        }

        public final Builder threads(@Nullable Long value) {
            this.threads = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ThreadCount build() {
            this._checkSingleUse();
            return new ThreadCount(this);
        }
    }
}

