/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.EnumHashBiMap;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaEntity {
    private final String entityPath;
    private final EntityType entityType;
    private final String normalizedPath;

    @JsonCreator
    public SchemaEntity(@JsonProperty(value="entityPath") String entityPath, @JsonProperty(value="entityType") EntityType entityType) {
        this.entityPath = entityPath;
        this.entityType = entityType;
        this.normalizedPath = this.entityPath.startsWith(".") ? entityPath.substring(1) : this.entityPath;
    }

    @JsonProperty(value="entityPath")
    public String getEntityPath() {
        return this.entityPath;
    }

    @JsonProperty(value="entityType")
    public EntityType getEntityType() {
        return this.entityType;
    }

    @JsonIgnore
    public String getNormalizedPath() {
        return this.normalizedPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaEntity other = (SchemaEntity)o;
        return Objects.equals(this.getNormalizedPath(), other.getNormalizedPath()) && Objects.equals((Object)this.entityType, (Object)other.getEntityType());
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getNormalizedPath());
        result = 31 * result + Objects.hashCode((Object)this.entityType);
        return result;
    }

    public String toString() {
        return "SchemaEntity{entityType=" + String.valueOf((Object)this.entityType) + ", entityPath='" + this.entityPath + "', normalizedPath='" + this.normalizedPath + "'}";
    }

    public static enum EntityType {
        SR_RECORD("sr_record"),
        SR_FIELD("sr_field");

        private static final EnumHashBiMap<EntityType, String> lookup;
        private final String symbol;

        private EntityType(String symbol) {
            this.symbol = symbol;
        }

        public String symbol() {
            return this.symbol;
        }

        public static EntityType get(String symbol) {
            return (EntityType)((Object)lookup.inverse().get((Object)symbol));
        }

        public static Set<String> symbols() {
            return lookup.inverse().keySet();
        }

        public String toString() {
            return this.symbol();
        }

        static {
            lookup = EnumHashBiMap.create(EntityType.class);
            for (EntityType type : EntityType.values()) {
                lookup.put((Enum)type, (Object)type.symbol());
            }
        }
    }
}

