"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternEditorFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/data-views-plugin/public");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _shared_imports = require("../shared_imports");
var _flyout_panels = require("./flyout_panels");
var _lib = require("../lib");
var _extract_time_fields = require("../lib/extract_time_fields");
var _2 = require(".");
var _edit_data_view_changed_modal = require("./confirm_modals/edit_data_view_changed_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/data_view_editor_flyout_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const editorTitle = _i18n.i18n.translate('indexPatternEditor.title', {
  defaultMessage: 'Create data view'
});
const editorTitleEditMode = _i18n.i18n.translate('indexPatternEditor.titleEditMode', {
  defaultMessage: 'Edit data view'
});
const IndexPatternEditorFlyoutContentComponent = ({
  onSave,
  onCancel,
  defaultTypeIsRollup,
  editData,
  allowAdHoc,
  showManagementLink,
  getDataViewHelpText,
  dataViewEditorService,
  onDuplicate,
  isDuplicating
}) => {
  var _form$getFields$type;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['s', 'xs']);
  const {
    services: {
      application,
      dataViews,
      uiSettings,
      overlays,
      docLinks
    }
  } = (0, _shared_imports.useKibana)();
  const canSave = dataViews.getCanSaveSync();
  const isManaged = !!(editData !== null && editData !== void 0 && editData.managed);
  // onDuplicate is only provided when editing an existing data view
  // if onDuplicate is undefined we are duplicating a new data view
  const isEditingExisting = editData && !isDuplicating;
  const {
    form
  } = (0, _shared_imports.useForm)({
    // Prefill with data if editData exists
    defaultValue: {
      type: defaultTypeIsRollup || (editData === null || editData === void 0 ? void 0 : editData.type) === _public.INDEX_PATTERN_TYPE.ROLLUP ? _public.INDEX_PATTERN_TYPE.ROLLUP : _public.INDEX_PATTERN_TYPE.DEFAULT,
      isAdHoc: false,
      ...(editData ? {
        title: editData.getIndexPattern(),
        id: isDuplicating ? undefined : editData.id,
        name: isDuplicating ? undefined : editData.name,
        allowHidden: editData.getAllowHidden(),
        ...(editData.timeFieldName === _extract_time_fields.noTimeFieldValue ? {
          timestampField: {
            label: _extract_time_fields.noTimeFieldLabel,
            value: _extract_time_fields.noTimeFieldValue
          }
        } : editData.timeFieldName ? {
          timestampField: {
            label: editData.timeFieldName,
            value: editData.timeFieldName
          }
        } : {})
      } : {})
    },
    schema: _2.schema,
    onSubmit: async (formData, isValid) => {
      var _formData$timestampFi;
      if (!isValid) {
        return;
      }
      const indexPatternStub = {
        title: (0, _lib.removeSpaces)(formData.title),
        timeFieldName: (_formData$timestampFi = formData.timestampField) === null || _formData$timestampFi === void 0 ? void 0 : _formData$timestampFi.value,
        id: formData.id,
        name: formData.name,
        allowHidden: formData.allowHidden
      };
      if (type === _public.INDEX_PATTERN_TYPE.ROLLUP && rollupIndex) {
        indexPatternStub.type = _public.INDEX_PATTERN_TYPE.ROLLUP;
        indexPatternStub.typeMeta = {
          params: {
            rollup_index: rollupIndex
          },
          aggs: rollupCaps === null || rollupCaps === void 0 ? void 0 : rollupCaps.aggs
        };
      }
      if (isEditingExisting && editData.getIndexPattern() !== formData.title) {
        await (0, _edit_data_view_changed_modal.editDataViewModal)({
          dataViewName: formData.name || formData.title,
          overlays,
          onEdit: async () => {
            await onSave(indexPatternStub, !formData.isAdHoc);
          }
        });
      } else {
        await onSave(indexPatternStub, !formData.isAdHoc);
      }
    }
  });

  // `useFormData` initially returns `undefined`,
  // we override `undefined` with real default values from `schema`
  // to get a stable reference to avoid hooks re-run and reduce number of excessive requests
  const [{
    title = _2.schema.title.defaultValue,
    allowHidden = _2.schema.allowHidden.defaultValue,
    type = _2.schema.type.defaultValue
  }] = (0, _shared_imports.useFormData)({
    form
  });
  const isLoadingSources = (0, _useObservable.default)(dataViewEditorService.isLoadingSources$, true);
  const existingDataViewNames = (0, _useObservable.default)(dataViewEditorService.dataViewNames$);
  const rollupIndex = (0, _useObservable.default)(dataViewEditorService.rollupIndex$);
  const rollupCaps = (0, _useObservable.default)(dataViewEditorService.rollupCaps$);
  const rollupIndicesCapabilities = (0, _useObservable.default)(dataViewEditorService.rollupIndicesCaps$, {});
  const namesNotAllowed = (0, _react.useMemo)(() => {
    // When duplicating a data view, add the existing name
    // to the not allowed names list
    if (isDuplicating && editData) {
      return [editData.name, ...(existingDataViewNames || [])];
    }
    return existingDataViewNames || [];
  }, [existingDataViewNames, isDuplicating, editData]);
  (0, _useDebounce.default)(() => {
    dataViewEditorService.setIndexPattern(title);
  }, 250, [dataViewEditorService, title]);
  (0, _react.useEffect)(() => {
    dataViewEditorService.setAllowHidden(allowHidden);
  }, [dataViewEditorService, allowHidden]);
  (0, _react.useEffect)(() => {
    dataViewEditorService.setType(type);
  }, [dataViewEditorService, type]);
  const getRollupIndices = rollupCapsRes => Object.keys(rollupCapsRes);
  const titleHelpText = (0, _react.useMemo)(() => editData && getDataViewHelpText && getDataViewHelpText(editData), [editData, getDataViewHelpText]);
  const onTypeChange = (0, _react.useCallback)(newType => {
    form.setFieldValue('title', '');
    form.setFieldValue('name', '');
    form.setFieldValue('timestampField', '');
    if (newType === _public.INDEX_PATTERN_TYPE.ROLLUP) {
      form.setFieldValue('allowHidden', false);
    }
  }, [form]);
  if (isLoadingSources || !existingDataViewNames) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      css: styles.loadingWrapper,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      size: "l",
      css: styles.skeletonTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 11
      }
    }), Array.from({
      length: 3
    }).map((_, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "100%",
      height: "48px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "100%",
      height: "160px",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 11
      }
    })));
  }
  const showIndexPatternTypeSelect = () => uiSettings.isDeclared('rollups:enableIndexPatterns') && uiSettings.get('rollups:enableIndexPatterns') && getRollupIndices(rollupIndicesCapabilities).length;
  const indexPatternTypeSelect = showIndexPatternTypeSelect() ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_2.TypeField, {
    onChange: onTypeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }))), type === _public.INDEX_PATTERN_TYPE.ROLLUP ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_2.RollupDeprecatedWarning, {
    docLinksService: docLinks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const FlyoutEditorFooter = () => /*#__PURE__*/_react.default.createElement(_2.Footer, {
    onCancel: onCancel,
    onSubmit: async adhoc => {
      const formData = form.getFormData();
      if (!formData.name) {
        form.updateFieldValues({
          name: formData.title
        });
        await form.getFields().name.validate();
      }
      // Ensures timestamp field is validated against current set of options
      form.validateFields(['timestampField']);
      form.setFieldValue('isAdHoc', adhoc || false);
      form.submit();
    },
    submitDisabled: form.isSubmitted && !form.isValid || form.isSubmitting,
    submittingType: form.isSubmitting ? form.getFormData().isAdHoc ? _2.SubmittingType.savingAsAdHoc : _2.SubmittingType.persisting : undefined,
    hasEditData: !!editData,
    isPersisted: Boolean(editData && editData.isPersisted()),
    allowAdHoc: allowAdHoc,
    canSave: canSave,
    isManaged: isManaged,
    onDuplicate: onDuplicate,
    isDuplicating: isDuplicating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Group, {
    flyoutClassName: "indexPatternEditorFlyout",
    maxWidth: 1180,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, {
    "data-test-subj": "indexPatternEditorFlyout",
    border: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Content, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "dataViewEditorFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 13
    }
  }, isEditingExisting ? editorTitleEditMode : editorTitle)), showManagementLink && isEditingExisting && editData && editData.id && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: application.getUrlForApp('management', {
      path: `/kibana/dataViews/dataView/${editData.id}`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('indexPatternEditor.goToManagementPage', {
    defaultMessage: 'Manage settings and view field details'
  })), isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('indexPatternEditor.managedDataViewCalloutMessage', {
      defaultMessage: "You can't edit managed data views. Instead, you can duplicate the data view and make changes to your newly created copy."
    }),
    color: "primary",
    iconType: "info",
    size: "s",
    css: {
      marginTop: euiTheme.base
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    css: styles.patternEditorForm,
    error: form.getErrors(),
    isInvalid: form.isSubmitted && !form.isValid && form.getErrors().length,
    "data-validation-error": form.getErrors().length ? '1' : '0',
    "data-test-subj": "indexPatternEditorForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "isAdHoc",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 13
    }
  }), indexPatternTypeSelect, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_2.NameField, {
    namesNotAllowed: namesNotAllowed,
    disabled: isManaged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_2.TitleField, {
    isRollup: ((_form$getFields$type = form.getFields().type) === null || _form$getFields$type === void 0 ? void 0 : _form$getFields$type.value) === _public.INDEX_PATTERN_TYPE.ROLLUP,
    matchedIndices$: dataViewEditorService.matchedIndices$,
    rollupIndicesCapabilities: rollupIndicesCapabilities,
    indexPatternValidationProvider: dataViewEditorService.indexPatternValidationProvider,
    titleHelpText: titleHelpText,
    disabled: isManaged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_2.TimestampField, {
    options$: dataViewEditorService.timestampFieldOptions$,
    isLoadingOptions$: dataViewEditorService.loadingTimestampFields$,
    matchedIndices$: dataViewEditorService.matchedIndices$,
    disabled: isManaged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_2.AdvancedParamsContent, {
    disableAllowHidden: type === _public.INDEX_PATTERN_TYPE.ROLLUP || isManaged,
    disableId: isEditingExisting || isManaged,
    onAllowHiddenChange: () => {
      form.getFields().title.validate();
    },
    defaultVisible: editData === null || editData === void 0 ? void 0 : editData.getAllowHidden(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 13
    }
  }))), !isMobile && /*#__PURE__*/_react.default.createElement(FlyoutEditorFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 7
    }
  }, isLoadingSources ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null) : /*#__PURE__*/_react.default.createElement(_2.PreviewPanel, {
    type: type,
    allowHidden: allowHidden,
    title: title,
    matchedIndices$: dataViewEditorService.matchedIndices$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 11
    }
  })), isMobile && /*#__PURE__*/_react.default.createElement(FlyoutEditorFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 20
    }
  }));
};
const componentStyles = {
  patternEditorForm: (0, _react2.css)({
    flexGrow: 1
  }),
  loadingWrapper: ({
    euiTheme
  }) => (0, _react2.css)({
    margin: euiTheme.size.l
  }),
  skeletonTitle: (0, _react2.css)({
    width: '25vw'
  })
};
const IndexPatternEditorFlyoutContent = exports.IndexPatternEditorFlyoutContent = /*#__PURE__*/_react.default.memo(IndexPatternEditorFlyoutContentComponent);