"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardStorage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _dashboard_saved_object = require("../dashboard_saved_object");
var _cm_services = require("./cm_services");
var _latest = require("./latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const savedObjectClientFromRequest = async ctx => {
  if (!ctx.requestHandlerContext) {
    throw new Error('Storage context.requestHandlerContext missing.');
  }
  const {
    savedObjects
  } = await ctx.requestHandlerContext.core;
  return savedObjects.client;
};
class DashboardStorage {
  constructor({
    logger,
    throwOnResultValidationError
  }) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "throwOnResultValidationError", void 0);
    this.logger = logger;
    this.throwOnResultValidationError = throwOnResultValidationError !== null && throwOnResultValidationError !== void 0 ? throwOnResultValidationError : false;
  }
  async get(ctx, id) {
    const transforms = ctx.utils.getTransforms(_cm_services.cmServicesDefinition);
    const soClient = await savedObjectClientFromRequest(ctx);
    // Save data in DB
    const {
      saved_object: savedObject,
      alias_purpose: aliasPurpose,
      alias_target_id: aliasTargetId,
      outcome
    } = await soClient.resolve(_dashboard_saved_object.DASHBOARD_SAVED_OBJECT_TYPE, id);
    const {
      item,
      error: itemError
    } = (0, _latest.savedObjectToItem)(savedObject, false);
    if (itemError) {
      throw _boom.default.badRequest(`Invalid response. ${itemError.message}`);
    }
    const response = {
      item,
      meta: {
        aliasPurpose,
        aliasTargetId,
        outcome
      }
    };
    const validationError = transforms.get.out.result.validate(response);
    if (validationError) {
      if (this.throwOnResultValidationError) {
        throw _boom.default.badRequest(`Invalid response. ${validationError.message}`);
      } else {
        this.logger.warn(`Invalid response. ${validationError.message}`);
      }
    }

    // Validate response and DOWN transform to the request version
    const {
      value,
      error: resultError
    } = transforms.get.out.result.down(
    // @ts-expect-error - fix type error
    response, undefined,
    // do not override version
    {
      validate: false
    } // validation is done above
    );
    if (resultError) {
      throw _boom.default.badRequest(`Invalid response. ${resultError.message}`);
    }
    return value;
  }
  async bulkGet() {
    // Not implemented
    throw new Error(`[bulkGet] has not been implemented. See DashboardStorage class.`);
  }
  async create() {
    throw _boom.default.badRequest(`Use REST API create endpoint`);
  }
  async update() {
    throw _boom.default.badRequest(`Use REST API update endpoint`);
  }
  async delete() {
    throw _boom.default.badRequest(`Use REST API delete endpoint`);
  }
  async search() {
    throw _boom.default.badRequest(`Use REST API search endpoint`);
  }
}
exports.DashboardStorage = DashboardStorage;