"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.areAdvancedSettingsEdited = areAdvancedSettingsEdited;
exports.getEmptyAdvancedSettings = exports.getAdvancedSettingsFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _follower_index_default_settings = require("../../services/follower_index_default_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/follower_index_form/advanced_settings_fields.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAdvancedSettingsFields = documentationLinks => {
  const byteUnitsHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.byteUnitsHelpText",
    defaultMessage: "Example values: 10b, 1024kb, 1mb, 5gb, 2tb, 1pb. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: documentationLinks.apis.byteSizeUnits,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 21,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.byteUnitsHelpTextLinkMessage",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 22,
          columnNumber: 13
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 16,
      columnNumber: 5
    }
  });
  const timeUnitsHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.timeUnitsHelpText",
    defaultMessage: "Example values: 2d, 24h, 20m, 30s, 500ms, 10000micros, 80000nanos. {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: documentationLinks.apis.timeUnits,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.timeUnitsHelpTextLinkMessage",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 13
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
  return [{
    field: 'maxReadRequestOperationCount',
    testSubject: 'maxReadRequestOperationCountInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestOperationCountTitle', {
      defaultMessage: 'Max read request operation count'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestOperationCountDescription', {
      defaultMessage: 'The maximum number of operations to pull per read from the remote cluster.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestOperationCountLabel', {
      defaultMessage: 'Max read request operation count'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxReadRequestOperationCount'),
    type: 'number'
  }, {
    field: 'maxOutstandingReadRequests',
    testSubject: 'maxOutstandingReadRequestsInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingReadRequestsTitle', {
      defaultMessage: 'Max outstanding read requests'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingReadRequestsDescription', {
      defaultMessage: 'The maximum number of outstanding read requests from the remote cluster.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingReadRequestsLabel', {
      defaultMessage: 'Max outstanding read requests'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxOutstandingReadRequests'),
    type: 'number'
  }, {
    field: 'maxReadRequestSize',
    testSubject: 'maxReadRequestSizeInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestSizeTitle', {
      defaultMessage: 'Max read request size'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestSizeDescription', {
      defaultMessage: 'The maximum size in bytes of per read of a batch of operations pulled from the remote cluster.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestSizeLabel', {
      defaultMessage: 'Max read request size'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxReadRequestSize'),
    helpText: byteUnitsHelpText
  }, {
    field: 'maxWriteRequestOperationCount',
    testSubject: 'maxWriteRequestOperationCountInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestOperationCountTitle', {
      defaultMessage: 'Max write request operation count'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestOperationCountDescription', {
      defaultMessage: 'The maximum number of operations per bulk write request executed on the follower.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestOperationCountLabel', {
      defaultMessage: 'Max write request operation count'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxWriteRequestOperationCount'),
    type: 'number'
  }, {
    field: 'maxWriteRequestSize',
    testSubject: 'maxWriteRequestSizeInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestSizeTitle', {
      defaultMessage: 'Max write request size'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestSizeDescription', {
      defaultMessage: 'The maximum total bytes of operations per bulk write request executed on the follower.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestSizeLabel', {
      defaultMessage: 'Max write request size'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxWriteRequestSize'),
    helpText: byteUnitsHelpText
  }, {
    field: 'maxOutstandingWriteRequests',
    testSubject: 'maxOutstandingWriteRequestsInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingWriteRequestsTitle', {
      defaultMessage: 'Max outstanding write requests'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingWriteRequestsDescription', {
      defaultMessage: 'The maximum number of outstanding write requests on the follower.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingWriteRequestsLabel', {
      defaultMessage: 'Max outstanding write requests'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxOutstandingWriteRequests'),
    type: 'number'
  }, {
    field: 'maxWriteBufferCount',
    testSubject: 'maxWriteBufferCountInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferCountTitle', {
      defaultMessage: 'Max write buffer count'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferCountDescription', {
      defaultMessage: 'The maximum number of operations that can be queued for writing; when this ' + 'limit is reached, reads from the remote cluster will be deferred until the number of queued ' + 'operations goes below the limit.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferCountLabel', {
      defaultMessage: 'Max write buffer count'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxWriteBufferCount'),
    type: 'number'
  }, {
    field: 'maxWriteBufferSize',
    testSubject: 'maxWriteBufferSizeInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferSizeTitle', {
      defaultMessage: 'Max write buffer size'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferSizeDescription', {
      defaultMessage: 'The maximum total bytes of operations that can be queued for writing; when ' + 'this limit is reached, reads from the remote cluster will be deferred until the total bytes ' + 'of queued operations goes below the limit.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferSizeLabel', {
      defaultMessage: 'Max write buffer size'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxWriteBufferSize'),
    helpText: byteUnitsHelpText
  }, {
    field: 'maxRetryDelay',
    testSubject: 'maxRetryDelayInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxRetryDelayTitle', {
      defaultMessage: 'Max retry delay'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxRetryDelayDescription', {
      defaultMessage: 'The maximum time to wait before retrying an operation that failed exceptionally; ' + 'an exponential backoff strategy is employed when retrying.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxRetryDelayLabel', {
      defaultMessage: 'Max retry delay'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('maxRetryDelay'),
    helpText: timeUnitsHelpText
  }, {
    field: 'readPollTimeout',
    testSubject: 'readPollTimeoutInput',
    title: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.readPollTimeoutTitle', {
      defaultMessage: 'Read poll timeout'
    }),
    description: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.readPollTimeoutDescription', {
      defaultMessage: 'The maximum time to wait for new operations on the remote cluster when the ' + 'follower index is synchronized with the leader index; when the timeout has elapsed, the ' + 'poll for operations will return to the follower so that it can update some statistics, and ' + 'then the follower will immediately attempt to read from the leader again.'
    }),
    label: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexForm.advancedSettings.readPollTimeoutLabel', {
      defaultMessage: 'Read poll timeout'
    }),
    defaultValue: (0, _follower_index_default_settings.getSettingDefault)('readPollTimeout'),
    helpText: timeUnitsHelpText
  }];
};
exports.getAdvancedSettingsFields = getAdvancedSettingsFields;
const getEmptyAdvancedSettings = documentationLinks => getAdvancedSettingsFields(documentationLinks).reduce((obj, advancedSetting) => {
  const {
    field,
    defaultValue
  } = advancedSetting;
  return {
    ...obj,
    [field]: defaultValue
  };
}, {});
exports.getEmptyAdvancedSettings = getEmptyAdvancedSettings;
function areAdvancedSettingsEdited(followerIndex, documentationLinks) {
  return getAdvancedSettingsFields(documentationLinks).some(advancedSetting => {
    const {
      field
    } = advancedSetting;
    return followerIndex[field] !== getEmptyAdvancedSettings(documentationLinks)[field];
  });
}