"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayoutGlobalCSS = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _layout_state_context = require("./layout_state_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/layout_global_css.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Defines global CSS variables for layout structure using custom properties.
 * These variables are globally available for consistent and dynamic layout styling.
 * @returns The rendered GlobalCSS component.
 */
const LayoutGlobalCSS = () => {
  const {
    bannerHeight,
    footerHeight,
    headerHeight,
    navigationWidth,
    sidebarWidth,
    applicationTopBarHeight,
    applicationBottomBarHeight
  } = (0, _layout_state_context.useLayoutState)();
  const banner = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('banner.top')}: 0;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('banner.left')}: 0;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('banner.height')}: ${bannerHeight}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('banner.width')}: 100vw;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('banner.bottom')}: calc(100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('banner.height')});
    ${(0, _coreChromeLayoutConstants.layoutVarName)('banner.right')}: 0;
  `;
  const header = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('header.top')}: ${(0, _coreChromeLayoutConstants.layoutVar)('banner.height')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('header.left')}: ${navigationWidth}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('header.right')}: ${sidebarWidth}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('header.height')}: ${headerHeight}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('header.width')}: calc(
      100vw - ${(0, _coreChromeLayoutConstants.layoutVar)('header.left')} - ${(0, _coreChromeLayoutConstants.layoutVar)('header.right')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('header.bottom')}: calc(
      100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('banner.height')} + ${(0, _coreChromeLayoutConstants.layoutVar)('header.height')}
    );
  `;
  const footer = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('footer.height')}: ${footerHeight}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('footer.top')}: calc(100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('footer.height')});
    ${(0, _coreChromeLayoutConstants.layoutVarName)('footer.bottom')}: 0;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('footer.left')}: 0;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('footer.right')}: 0;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('footer.width')}: 100vw;
  `;
  const navigation = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('navigation.top')}: ${(0, _coreChromeLayoutConstants.layoutVar)('banner.height')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('navigation.bottom')}: ${(0, _coreChromeLayoutConstants.layoutVar)('footer.height')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('navigation.left')}: 0;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('navigation.right')}: calc(100vw - ${navigationWidth}px);
    ${(0, _coreChromeLayoutConstants.layoutVarName)('navigation.height')}: calc(
      100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('navigation.top')} - ${(0, _coreChromeLayoutConstants.layoutVar)('navigation.bottom')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('navigation.width')}: ${navigationWidth}px;
  `;
  const sidebar = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('sidebar.top')}: ${(0, _coreChromeLayoutConstants.layoutVar)('banner.height')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('sidebar.bottom')}: ${(0, _coreChromeLayoutConstants.layoutVar)('footer.height')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('sidebar.right')}: 0;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('sidebar.left')}: calc(100vw - ${sidebarWidth}px);
    ${(0, _coreChromeLayoutConstants.layoutVarName)('sidebar.height')}: calc(
      100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('sidebar.top')} - ${(0, _coreChromeLayoutConstants.layoutVar)('sidebar.bottom')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('sidebar.width')}: ${sidebarWidth}px;
  `;
  const application = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.top')}: calc(
      ${(0, _coreChromeLayoutConstants.layoutVar)('banner.height')} + ${(0, _coreChromeLayoutConstants.layoutVar)('header.height')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottom')}: ${(0, _coreChromeLayoutConstants.layoutVar)('footer.height')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.left')}: ${navigationWidth}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.right')}: ${sidebarWidth}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.height')}: calc(
      100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('application.top')} - ${(0, _coreChromeLayoutConstants.layoutVar)('application.bottom')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.width')}: calc(
      100vw - ${(0, _coreChromeLayoutConstants.layoutVar)('application.left')} - ${(0, _coreChromeLayoutConstants.layoutVar)('application.right')}
    );
  `;
  const applicationTopBar = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.height')}: ${applicationTopBarHeight}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.top')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.top')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.left')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.left')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.width')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.width')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.right')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.right')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.bottom')}: calc(
      ${(0, _coreChromeLayoutConstants.layoutVar)('application.top')} + ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height')}
    );
  `;
  const applicationBottomBar = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottomBar.height')}: ${applicationBottomBarHeight}px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottomBar.top')}: calc(
      100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('footer.height')} - ${(0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.height')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottomBar.left')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.left')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottomBar.width')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.width')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottomBar.right')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.right')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottomBar.bottom')}: ${(0, _coreChromeLayoutConstants.layoutVar)('footer.height')};
  `;

  // The application content is the main area where the application renders its content.
  // It is not a slot, but it is styled to ensure it fits within the layout.
  // It is positioned inside application area and takes the full height available minus that application top and bottom bars.
  const applicationContent = (0, _react2.css)`
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.top')}: calc(
      ${(0, _coreChromeLayoutConstants.layoutVar)('application.top')} + ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.bottom')}: calc(
      ${(0, _coreChromeLayoutConstants.layoutVar)('footer.height')} + ${(0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.height')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.left')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.left')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.right')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.right')};
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.height')}: calc(
      ${(0, _coreChromeLayoutConstants.layoutVar)('application.height')} - ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height')} -
        ${(0, _coreChromeLayoutConstants.layoutVar)('application.bottomBar.height')}
    );
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.width')}: ${(0, _coreChromeLayoutConstants.layoutVar)('application.width')};
  `;
  const styles = (0, _react2.css)`
    :root {
      ${banner}
      ${header}
      ${navigation}
      ${sidebar}
      ${application}
      ${applicationTopBar}
      ${applicationBottomBar}
      ${applicationContent}
      ${footer}
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: styles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 10
    }
  });
};
exports.LayoutGlobalCSS = LayoutGlobalCSS;