"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProjectHeader = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _breadcrumbs = require("./breadcrumbs");
var _header_help_menu = require("../header/header_help_menu");
var _header_nav_controls = require("../header/header_nav_controls");
var _header_top_banner = require("../header/header_top_banner");
var _app_menu = require("./app_menu");
var _breadcrumbs_with_extensions = require("../header/breadcrumbs_with_extensions");
var _header_page_announcer = require("../header/header_page_announcer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/project/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getHeaderCss = ({
  size,
  colors
}) => ({
  logo: {
    container: (0, _react.css)`
      display: flex;
      align-items: center;
      justify-content: center;
      min-width: 56px; /* 56 = 40 + 8 + 8 */
      cursor: pointer;
    `,
    logo: (0, _react.css)`
      min-width: 0; /* overrides min-width: 40px */
      padding: 0;
    `,
    spinner: (0, _react.css)`
      position: relative;
      left: 4px;
      top: 2px;
    `
  },
  leftHeaderSection: (0, _react.css)`
    // needed to enable breadcrumbs truncation
    min-width: 0;
    flex-shrink: 1;
  `,
  breadcrumbsSectionItem: (0, _react.css)`
    min-width: 0; // needed to enable breadcrumbs truncation
  `,
  leftNavcontrols: (0, _react.css)`
    .navcontrols__separator {
      display: flex;
      margin-right: ${size.xs};
      &:after {
        background: ${colors.lightShade};
        content: '';
        flex-shrink: 0;
        margin-block-start: ${size.xs};
        margin-block-end: 0;
        margin-inline: ${size.s};
        block-size: 16px;
        inline-size: 1px;
        transform: translateY(-1px) rotate(15deg);
      }
    }
  `
});
const headerStrings = {
  logo: {
    ariaLabel: _i18n.i18n.translate('core.ui.primaryNav.goToHome.ariaLabel', {
      defaultMessage: 'Go to home page'
    })
  },
  nav: {
    closeNavAriaLabel: _i18n.i18n.translate('core.ui.primaryNav.project.toggleNavAriaLabel', {
      defaultMessage: 'Toggle primary navigation'
    })
  }
};
const LOADING_DEBOUNCE_TIME = 80;
const Logo = ({
  loadingCount$,
  homeHref$,
  prependBasePath,
  application,
  logoCss,
  customBranding$
}) => {
  const loadingCount = (0, _useObservable.default)(loadingCount$.pipe((0, _rxjs.debounceTime)(LOADING_DEBOUNCE_TIME)), 0);
  const homeHref = (0, _useObservable.default)(homeHref$, '/app/home');
  const customBranding = (0, _useObservable.default)(customBranding$, {});
  const {
    logo
  } = customBranding;
  let fullHref;
  if (homeHref) {
    fullHref = prependBasePath(homeHref);
  }
  const navigateHome = (0, _react2.useCallback)(event => {
    if (fullHref) {
      application.navigateToUrl(fullHref);
    }
    event.preventDefault();
  }, [fullHref, application]);
  const renderLogo = () => {
    if (logo) {
      return /*#__PURE__*/_react2.default.createElement("a", {
        href: fullHref,
        onClick: navigateHome,
        "data-test-subj": "globalLoadingIndicator-hidden",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiImage, {
        src: logo,
        css: logoCss,
        "data-test-subj": "globalLoadingIndicator-hidden customLogo",
        size: 24,
        alt: "logo",
        "aria-label": _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.customLogoAriaLabel', {
          defaultMessage: 'User logo'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLogo, {
      iconType: "logoElastic",
      onClick: navigateHome,
      href: fullHref,
      css: logoCss,
      "data-test-subj": "globalLoadingIndicator-hidden",
      "aria-label": headerStrings.logo.ariaLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react2.default.createElement("span", {
    css: logoCss.container,
    "data-test-subj": "nav-header-logo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, loadingCount === 0 ? renderLogo() : /*#__PURE__*/_react2.default.createElement("a", {
    onClick: navigateHome,
    href: fullHref,
    css: logoCss.spinner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "aria-hidden": false,
    onClick: navigateHome,
    "data-test-subj": "globalLoadingIndicator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  })));
};
const ProjectHeader = ({
  application,
  kibanaVersion,
  children,
  prependBasePath,
  docLinks,
  customBranding$,
  isServerless,
  breadcrumbsAppendExtensions$,
  isFixed = true,
  ...observables
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerCss = getHeaderCss(euiTheme);
  const {
    logo: logoCss
  } = headerCss;
  const topBarStyles = (0, _react.css)`
    box-shadow: none !important;
  `;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, observables.headerBanner$ && /*#__PURE__*/_react2.default.createElement(_header_top_banner.HeaderTopBanner, {
    headerBanner$: observables.headerBanner$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 37
    }
  }), /*#__PURE__*/_react2.default.createElement("header", {
    "data-test-subj": "kibanaProjectHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    id: "globalHeaderBars",
    "data-test-subj": "headerGlobalNav",
    className: "header__bars",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeader, {
    position: isFixed ? 'fixed' : 'static',
    className: "header__firstBar",
    css: topBarStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, {
    grow: false,
    css: headerCss.leftHeaderSection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  }, children, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_header_page_announcer.HeaderPageAnnouncer, {
    breadcrumbs$: observables.breadcrumbs$,
    customBranding$: customBranding$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(Logo, {
    prependBasePath: prependBasePath,
    application: application,
    homeHref$: observables.homeHref$,
    loadingCount$: observables.loadingCount$,
    customBranding$: customBranding$,
    logoCss: logoCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    css: headerCss.leftNavcontrols,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_header_nav_controls.HeaderNavControls, {
    side: "left",
    navControls$: observables.navControlsLeft$,
    append: /*#__PURE__*/_react2.default.createElement("div", {
      className: "navcontrols__separator",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 27
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    css: headerCss.breadcrumbsSectionItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_breadcrumbs_with_extensions.BreadcrumbsWithExtensionsWrapper, {
    breadcrumbsAppendExtensions$: breadcrumbsAppendExtensions$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs$: observables.breadcrumbs$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSection, {
    side: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_header_nav_controls.HeaderNavControls, {
    navControls$: observables.navControlsCenter$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_header_help_menu.HeaderHelpMenu, {
    isServerless: isServerless,
    globalHelpExtensionMenuLinks$: observables.globalHelpExtensionMenuLinks$,
    helpExtension$: observables.helpExtension$,
    helpSupportUrl$: observables.helpSupportUrl$,
    defaultContentLinks$: observables.helpMenuLinks$,
    kibanaDocLink: docLinks.links.elasticStackGetStarted,
    docLinks: docLinks,
    kibanaVersion: kibanaVersion,
    navigateToUrl: application.navigateToUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderSectionItem, {
    css: (0, _react.css)`
                  gap: ${euiTheme.size.s};
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_header_nav_controls.HeaderNavControls, {
    navControls$: observables.navControlsRight$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 17
    }
  })))))), observables.actionMenu$ && /*#__PURE__*/_react2.default.createElement(_app_menu.AppMenuBar, {
    appMenuActions$: observables.actionMenu$,
    isFixed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 9
    }
  }));
};
exports.ProjectHeader = ProjectHeader;