"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XSOARSeverity = exports.SUB_ACTION = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.xsoar';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.xsoar.title', {
  defaultMessage: 'XSOAR'
});
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["PLAYBOOKS"] = "getPlaybooks";
  SUB_ACTION["RUN"] = "run";
  return SUB_ACTION;
}({});
let XSOARSeverity = exports.XSOARSeverity = /*#__PURE__*/function (XSOARSeverity) {
  XSOARSeverity[XSOARSeverity["INFORMATIONAL"] = 0.5] = "INFORMATIONAL";
  XSOARSeverity[XSOARSeverity["UNKNOWN"] = 0] = "UNKNOWN";
  XSOARSeverity[XSOARSeverity["LOW"] = 1] = "LOW";
  XSOARSeverity[XSOARSeverity["MEDIUM"] = 2] = "MEDIUM";
  XSOARSeverity[XSOARSeverity["HIGH"] = 3] = "HIGH";
  XSOARSeverity[XSOARSeverity["CRITICAL"] = 4] = "CRITICAL";
  return XSOARSeverity;
}({});