"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyButton = exports.COPY_ARIA_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/copy_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const COPY_ARIA_LABEL = exports.COPY_ARIA_LABEL = _i18n.i18n.translate('xpack.csp.clipboard.copy', {
  defaultMessage: 'Copy'
});
const CopyButton = ({
  copyText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
  textToCopy: copyText,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 17,
    columnNumber: 3
  }
}, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  "aria-label": COPY_ARIA_LABEL,
  iconType: "copy",
  onClick: copy,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 7
  }
}));
exports.CopyButton = CopyButton;