"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../common/lib/kibana");
var _use_get_issue_types = require("./use_get_issue_types");
var _use_get_fields_by_issue_type = require("./use_get_fields_by_issue_type");
var _search_issues = require("./search_issues");
var _json_editor_field = require("../json_editor_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/jira/case_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const JiraFieldsComponent = ({
  connector
}) => {
  var _issueTypesData$data;
  const [{
    fields
  }] = (0, _hook_form_lib.useFormData)();
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    issueType
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    isLoading: isLoadingIssueTypesData,
    isFetching: isFetchingIssueTypesData,
    data: issueTypesData
  } = (0, _use_get_issue_types.useGetIssueTypes)({
    connector,
    http
  });
  const issueTypes = (_issueTypesData$data = issueTypesData === null || issueTypesData === void 0 ? void 0 : issueTypesData.data) !== null && _issueTypesData$data !== void 0 ? _issueTypesData$data : [];
  const issueTypesSelectOptions = issueTypes.map(type => {
    var _type$name, _type$id;
    return {
      text: (_type$name = type.name) !== null && _type$name !== void 0 ? _type$name : '',
      value: (_type$id = type.id) !== null && _type$id !== void 0 ? _type$id : ''
    };
  });
  const {
    isLoading: isLoadingFieldsData,
    isFetching: isFetchingFieldsData,
    data: fieldsByIssueTypeData
  } = (0, _use_get_fields_by_issue_type.useGetFieldsByIssueType)({
    connector,
    http,
    issueType
  });
  const fieldsByIssueType = fieldsByIssueTypeData === null || fieldsByIssueTypeData === void 0 ? void 0 : fieldsByIssueTypeData.data;
  const hasPriority = (fieldsByIssueType === null || fieldsByIssueType === void 0 ? void 0 : fieldsByIssueType.priority) != null;
  const hasParent = (fieldsByIssueType === null || fieldsByIssueType === void 0 ? void 0 : fieldsByIssueType.parent) != null;
  const isLoadingIssueTypes = isLoadingIssueTypesData || isFetchingIssueTypesData;
  const isLoadingFields = isLoadingFieldsData || isFetchingFieldsData;
  const prioritiesSelectOptions = (0, _react.useMemo)(() => {
    var _fieldsByIssueType$pr, _fieldsByIssueType$pr2;
    const priorities = (_fieldsByIssueType$pr = fieldsByIssueType === null || fieldsByIssueType === void 0 ? void 0 : (_fieldsByIssueType$pr2 = fieldsByIssueType.priority) === null || _fieldsByIssueType$pr2 === void 0 ? void 0 : _fieldsByIssueType$pr2.allowedValues) !== null && _fieldsByIssueType$pr !== void 0 ? _fieldsByIssueType$pr : [];
    return (0, _fp.map)(p => ({
      text: p.name,
      value: p.name
    }), priorities);
  }, [fieldsByIssueType]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'connector-fields-jira',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.issueType",
    component: _components.SelectField,
    config: {
      label: i18n.ISSUE_TYPE,
      validations: [{
        validator: emptyField(i18n.ISSUE_TYPE_REQUIRED)
      }]
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'issueTypeSelect',
        options: issueTypesSelectOptions,
        fullWidth: true,
        disabled: isLoadingIssueTypes,
        isLoading: isLoadingIssueTypes,
        hasNoInitialSelection: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 5,
    size: "m",
    isLoading: isLoadingFields && !isLoadingIssueTypes && !(0, _lodash.isEmpty)(issueType),
    "data-test-subj": "fields-by-issue-type-loading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: hasParent ? 'block' : 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_search_issues.SearchIssues, {
    actionConnector: connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: hasPriority ? 'block' : 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.priority",
    component: _components.SelectField,
    config: {
      label: i18n.PRIORITY
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'prioritySelect',
        options: prioritiesSelectOptions,
        fullWidth: true,
        disabled: isLoadingIssueTypes || isLoadingFields,
        isLoading: isLoadingFields
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.otherFields",
    component: _json_editor_field.JsonEditorField,
    config: {
      label: i18n.OTHER_FIELDS
    },
    componentProps: {
      euiCodeEditorProps: {
        fullWidth: true,
        height: '200px',
        disabled: isLoadingIssueTypes,
        isLoading: isLoadingIssueTypes,
        options: {
          fontSize: '12px',
          renderValidationDecorations: 'off'
        }
      },
      dataTestSubj: 'otherFieldsEditor'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  })));
};
exports.default = JiraFieldsComponent;
JiraFieldsComponent.displayName = 'JiraFields';

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;