"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _i18n = require("@kbn/i18n");
var _connectors_dropdown = require("../configure_cases/connectors_dropdown");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connector_selector/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ADD_CONNECTOR_HELPER_TEXT = _i18n.i18n.translate('xpack.cases.connectorSelector.addConnectorHelperText', {
  defaultMessage: 'Go to Cases > Settings to add an external incident management system'
});
const ConnectorSelector = ({
  connectors,
  dataTestSubj,
  disabled = false,
  field,
  idAria,
  isLoading = false,
  handleChange
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const onChange = (0, _react.useCallback)(val => {
    if (handleChange) {
      handleChange(val);
    }
    field.setValue(val);
  }, [handleChange, field]);
  const isConnectorAvailable = Boolean(connectors.find(connector => connector.id === field.value));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: (0, _react2.css)`
        .euiFormErrorText {
          display: none;
        }
      `,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined,
    error: errorMessage,
    fullWidth: true,
    helpText: ADD_CONNECTOR_HELPER_TEXT,
    isInvalid: isInvalid,
    label: field.label,
    labelAppend: field.labelAppend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_connectors_dropdown.ConnectorsDropdown, {
    connectors: connectors,
    disabled: disabled,
    isLoading: isLoading,
    onChange: onChange,
    selectedConnector: (0, _fp.isEmpty)(field.value) || !isConnectorAvailable ? 'none' : field.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }));
};
exports.ConnectorSelector = ConnectorSelector;
ConnectorSelector.displayName = 'ConnectorSelector';