"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _var_config = require("../var_config");
var _constants = require("../../../common/lib/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_config/workpad_config.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getApplyStylesheetButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.applyStylesheetButtonLabel', {
    defaultMessage: `Apply stylesheet`,
    description: '"stylesheet" refers to the collection of CSS style rules entered by the user.'
  }),
  getFlipDimensionAriaLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.swapDimensionsAriaLabel', {
    defaultMessage: `Swap the page's width and height`
  }),
  getFlipDimensionTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.swapDimensionsTooltip', {
    defaultMessage: 'Swap the width and height'
  }),
  getGlobalCSSLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.globalCSSLabel', {
    defaultMessage: `Global CSS overrides`
  }),
  getGlobalCSSTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.globalCSSTooltip', {
    defaultMessage: `Apply styles to all pages in this workpad`
  }),
  getNameLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.nameLabel', {
    defaultMessage: 'Name'
  }),
  getPageHeightLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.heightLabel', {
    defaultMessage: 'Height'
  }),
  getPageSizeBadgeAriaLabel: sizeName => _i18n.i18n.translate('xpack.canvas.workpadConfig.pageSizeBadgeAriaLabel', {
    defaultMessage: `Preset page size: {sizeName}`,
    values: {
      sizeName
    }
  }),
  getPageSizeBadgeOnClickAriaLabel: sizeName => _i18n.i18n.translate('xpack.canvas.workpadConfig.pageSizeBadgeOnClickAriaLabel', {
    defaultMessage: `Set page size to {sizeName}`,
    values: {
      sizeName
    }
  }),
  getPageWidthLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.widthLabel', {
    defaultMessage: 'Width'
  }),
  getUSLetterButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.USLetterButtonLabel', {
    defaultMessage: 'US Letter',
    description: 'This is referring to the dimensions of U.S. standard letter paper.'
  })
};
const WorkpadConfig = props => {
  const [css, setCSS] = (0, _react.useState)(props.css);
  const {
    size,
    name,
    setSize,
    setName,
    setWorkpadCSS,
    variables,
    setWorkpadVariables
  } = props;
  const rotate = () => setSize({
    width: size.height,
    height: size.width
  });
  const badges = [{
    name: '1080p',
    size: {
      height: 1080,
      width: 1920
    }
  }, {
    name: '720p',
    size: {
      height: 720,
      width: 1280
    }
  }, {
    name: 'A4',
    size: {
      height: 842,
      width: 590
    }
  }, {
    name: strings.getUSLetterButtonLabel(),
    size: {
      height: 792,
      width: 612
    }
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getNameLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    value: name,
    onChange: e => setName(e.target.value),
    "data-test-subj": "canvas-workpad-name-text-field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getPageWidthLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    onChange: e => setSize({
      width: Number(e.target.value),
      height: size.height
    }),
    value: size.width,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: strings.getFlipDimensionTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "merge",
    color: "text",
    onClick: rotate,
    "aria-label": strings.getFlipDimensionAriaLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getPageHeightLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    onChange: e => setSize({
      height: Number(e.target.value),
      width: size.width
    }),
    value: size.height,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }, badges.map((badge, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: `page-size-badge-${i}`,
    color: "hollow",
    onClick: () => setSize(badge.size),
    "aria-label": strings.getPageSizeBadgeAriaLabel(badge.name),
    onClickAriaLabel: strings.getPageSizeBadgeOnClickAriaLabel(badge.name),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, badge.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_var_config.VarConfig, {
    variables: variables,
    setVariables: setWorkpadVariables,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__expandable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion-global-css",
    className: "canvasSidebar__accordion",
    style: {
      marginBottom: 0
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: strings.getGlobalCSSTooltip(),
      position: "left",
      className: "canvasArg__tooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 15
      }
    }, strings.getGlobalCSSLabel())),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "aria-label": strings.getGlobalCSSTooltip(),
    value: css,
    compressed: true,
    onChange: e => setCSS(e.target.value),
    rows: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: () => setWorkpadCSS(css || _constants.DEFAULT_WORKPAD_CSS),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, strings.getApplyStylesheetButtonLabel()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  })))));
};
exports.WorkpadConfig = WorkpadConfig;
WorkpadConfig.propTypes = {
  size: _propTypes.default.object.isRequired,
  name: _propTypes.default.string.isRequired,
  css: _propTypes.default.string,
  variables: _propTypes.default.array,
  setSize: _propTypes.default.func.isRequired,
  setName: _propTypes.default.func.isRequired,
  setWorkpadCSS: _propTypes.default.func.isRequired,
  setWorkpadVariables: _propTypes.default.func.isRequired
};