"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedElementsModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _confirm_modal = require("../confirm_modal/confirm_modal");
var _custom_element_modal = require("../custom_element_modal");
var _element_grid = require("./element_grid");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/saved_elements_modal/saved_elements_modal.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getAddNewElementDescription: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.addNewElementDescription', {
    defaultMessage: 'Group and save workpad elements to create new elements'
  }),
  getAddNewElementTitle: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.addNewElementTitle', {
    defaultMessage: 'Add new elements'
  }),
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getDeleteButtonLabel: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.deleteButtonLabel', {
    defaultMessage: 'Delete'
  }),
  getDeleteElementDescription: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.deleteElementDescription', {
    defaultMessage: 'Are you sure you want to delete this element?'
  }),
  getDeleteElementTitle: elementName => _i18n.i18n.translate('xpack.canvas.savedElementsModal.deleteElementTitle', {
    defaultMessage: `Delete element ''{elementName}''?`,
    values: {
      elementName
    }
  }),
  getEditElementTitle: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.editElementTitle', {
    defaultMessage: 'Edit element'
  }),
  getFindElementPlaceholder: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.findElementPlaceholder', {
    defaultMessage: 'Find element'
  }),
  getModalTitle: () => _i18n.i18n.translate('xpack.canvas.savedElementsModal.modalTitle', {
    defaultMessage: 'My elements'
  }),
  getSavedElementsModalCloseButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.addElementModalCloseButtonLabel', {
    defaultMessage: 'Close'
  })
};
const SavedElementsModal = ({
  customElements,
  onAddCustomElement,
  onClose,
  onRemoveCustomElement,
  onUpdateCustomElement,
  onSearch,
  initialSearch = ''
}) => {
  const hasLoadedElements = (0, _react.useRef)(false);
  const [elementToDelete, setElementToDelete] = (0, _react.useState)(null);
  const [elementToEdit, setElementToEdit] = (0, _react.useState)(null);
  const [search, setSearch] = (0, _react.useState)(initialSearch);
  (0, _react.useEffect)(() => {
    if (!hasLoadedElements.current) {
      hasLoadedElements.current = true;
      onSearch('');
    }
  }, [onSearch, hasLoadedElements]);
  const showEditModal = element => setElementToEdit(element);
  const hideEditModal = () => setElementToEdit(null);
  const handleEdit = async (name, description, image) => {
    if (elementToEdit) {
      onUpdateCustomElement(elementToEdit.id, name, description, image);
    }
    hideEditModal();
  };
  const showDeleteModal = element => setElementToDelete(element);
  const hideDeleteModal = () => setElementToDelete(null);
  const handleDelete = async () => {
    if (elementToDelete) {
      onRemoveCustomElement(elementToDelete.id);
    }
    hideDeleteModal();
  };
  const renderEditModal = () => {
    if (!elementToEdit) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_custom_element_modal.CustomElementModal, {
      title: strings.getEditElementTitle(),
      name: elementToEdit.displayName,
      description: elementToEdit.help,
      image: elementToEdit.image,
      onSave: handleEdit,
      onCancel: hideEditModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 7
      }
    });
  };
  const renderDeleteModal = () => {
    if (!elementToDelete) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_confirm_modal.ConfirmModal, {
      isOpen: true,
      title: strings.getDeleteElementTitle(elementToDelete.displayName),
      message: strings.getDeleteElementDescription(),
      confirmButtonText: strings.getDeleteButtonLabel(),
      cancelButtonText: strings.getCancelButtonLabel(),
      onConfirm: handleDelete,
      onCancel: hideDeleteModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 7
      }
    });
  };
  const sortElements = elements => (0, _lodash.sortBy)(elements, 'displayName');
  const onFieldSearch = e => setSearch(e.target.value);
  let customElementContent = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "vector",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 14
      }
    }, strings.getAddNewElementTitle()),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }, strings.getAddNewElementDescription()),
    titleSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 5
    }
  });
  if (customElements.length) {
    customElementContent = /*#__PURE__*/_react.default.createElement(_element_grid.ElementGrid, {
      elements: sortElements(customElements),
      filterText: search,
      onClick: onAddCustomElement,
      onEdit: showEditModal,
      onDelete: showDeleteModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    className: "canvasModal--fixedSize",
    maxWidth: "1000px",
    initialFocus: ".canvasElements__filter input",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    className: "canvasAssetManager__modalHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    className: "canvasAssetManager__modalHeaderTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, strings.getModalTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    style: {
      paddingRight: '1px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    value: search,
    placeholder: strings.getFindElementPlaceholder(),
    onChange: onFieldSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }), customElementContent), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onClose,
    "data-test-subj": "saved-elements-modal-close-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, strings.getSavedElementsModalCloseButtonLabel()))), renderDeleteModal(), renderEditModal());
};
exports.SavedElementsModal = SavedElementsModal;