"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamSchemaV1 = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataStreamSchemaV1 = exports.dataStreamSchemaV1 = _configSchema.schema.object({
  integration_id: _configSchema.schema.string({
    maxLength: 50,
    minLength: 1
  }),
  data_stream_id: _configSchema.schema.string({
    maxLength: 50,
    minLength: 1
  }),
  created_by: _configSchema.schema.string({
    minLength: 1
  }),
  job_info: _configSchema.schema.object({
    job_id: _configSchema.schema.string({
      maxLength: 50,
      minLength: 1
    }),
    job_type: _configSchema.schema.string({
      maxLength: 50,
      minLength: 1
    }),
    // TODO: Add Enum
    status: _configSchema.schema.oneOf(Object.values(_constants.TASK_STATUSES).map(status => _configSchema.schema.literal(status)))
  }),
  metadata: _configSchema.schema.object({
    sample_count: _configSchema.schema.maybe(_configSchema.schema.number()),
    created_at: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1
    })),
    version: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 5,
      maxLength: 20,
      validate(value) {
        if (!/^\d+\.\d+\.\d+$/.test(value)) {
          return 'version must be in semantic versioning format (x.y.z)';
        }
      }
    })),
    input_type: _configSchema.schema.maybe(_configSchema.schema.oneOf(Object.values(_constants.INPUT_TYPES).map(status => _configSchema.schema.literal(status))))
  }, {
    unknowns: 'allow'
  }),
  result: _configSchema.schema.object({
    ingest_pipeline: _configSchema.schema.maybe(_configSchema.schema.string()),
    field_mapping: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
    connector: _configSchema.schema.maybe(_configSchema.schema.string())
  })
});