"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNameFromTitle = exports.InputTypeOptions = exports.DataStreamStep = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _state = require("../../state");
var _step_content_wrapper = require("../step_content_wrapper");
var _generation_modal = require("./generation_modal");
var _sample_logs_input = require("./sample_logs_input");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_load_package_names = require("./use_load_package_names");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/steps/data_stream_step/data_stream_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InputTypeOptions = exports.InputTypeOptions = [{
  value: 'aws-cloudwatch',
  label: 'AWS Cloudwatch'
}, {
  value: 'aws-s3',
  label: 'AWS S3'
}, {
  value: 'azure-blob-storage',
  label: 'Azure Blob Storage'
}, {
  value: 'azure-eventhub',
  label: 'Azure Event Hub'
}, {
  value: 'cel',
  label: 'API (CEL Input)'
}, {
  value: 'cloudfoundry',
  label: 'Cloud Foundry'
}, {
  value: 'filestream',
  label: 'File Stream'
}, {
  value: 'gcp-pubsub',
  label: 'GCP Pub/Sub'
}, {
  value: 'gcs',
  label: 'Google Cloud Storage'
}, {
  value: 'http_endpoint',
  label: 'HTTP Endpoint'
}, {
  value: 'journald',
  label: 'Journald'
}, {
  value: 'kafka',
  label: 'Kafka'
}, {
  value: 'tcp',
  label: 'TCP'
}, {
  value: 'udp',
  label: 'UDP'
}];
const isValidName = name => _constants.NAME_REGEX_PATTERN.test(name);
const isValidDatastreamName = name => _constants.DATASTREAM_NAME_REGEX_PATTERN.test(name);
const getNameFromTitle = title => title.toLowerCase().replaceAll(/[^a-z0-9]/g, '_');
exports.getNameFromTitle = getNameFromTitle;
const DataStreamStep = exports.DataStreamStep = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  celInputResult,
  connector,
  isGenerating
}) => {
  var _integrationSettings$, _integrationSettings$2, _integrationSettings$4, _integrationSettings$5;
  const {
    setIntegrationSettings,
    setIsGenerating,
    setShowCelCreateFlyout,
    setStep,
    setResult,
    completeStep
  } = (0, _state.useActions)();
  const {
    isLoading: isLoadingPackageNames,
    packageNames
  } = (0, _use_load_package_names.useLoadPackageNames)(); // this is used to avoid duplicate names

  const [name, setName] = (0, _react.useState)((_integrationSettings$ = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.name) !== null && _integrationSettings$ !== void 0 ? _integrationSettings$ : '');
  const [dataStreamName, setDataStreamName] = (0, _react.useState)((_integrationSettings$2 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.dataStreamName) !== null && _integrationSettings$2 !== void 0 ? _integrationSettings$2 : '');
  const [invalidFields, setInvalidFields] = (0, _react.useState)({
    name: false,
    dataStreamName: false
  });
  const [showCelOpenApiSpecButton, setShowCelOpenApiSpecButton] = (0, _react.useState)(false);
  const setIntegrationValues = (0, _react.useCallback)(settings => setIntegrationSettings({
    ...integrationSettings,
    ...settings
  }), [integrationSettings, setIntegrationSettings]);
  const onChange = (0, _react.useMemo)(() => {
    return {
      name: e => {
        const nextName = e.target.value;
        setName(nextName);
        if (!isValidName(nextName) || packageNames !== null && packageNames !== void 0 && packageNames.has(nextName)) {
          setInvalidFields(current => ({
            ...current,
            name: true
          }));
          setIntegrationValues({
            name: undefined
          });
        } else {
          setInvalidFields(current => ({
            ...current,
            name: false
          }));
          setIntegrationValues({
            name: nextName
          });
        }
      },
      dataStreamName: e => {
        const nextDataStreamName = e.target.value;
        setDataStreamName(nextDataStreamName);
        if (!isValidDatastreamName(nextDataStreamName)) {
          setInvalidFields(current => ({
            ...current,
            dataStreamName: true
          }));
          setIntegrationValues({
            dataStreamName: undefined
          });
        } else {
          setInvalidFields(current => ({
            ...current,
            dataStreamName: false
          }));
          setIntegrationValues({
            dataStreamName: nextDataStreamName
          });
        }
      },
      // inputs without validation
      dataStreamTitle: e => setIntegrationValues({
        dataStreamTitle: e.target.value
      }),
      dataStreamDescription: e => setIntegrationValues({
        dataStreamDescription: e.target.value
      }),
      inputTypes: options => {
        setIntegrationValues({
          inputTypes: options.map(option => option.value)
        });
        setShowCelOpenApiSpecButton(
        // the cel value here comes from the input type options defined above
        options.map(option => option.value).includes('cel'));
      }
    };
  }, [setIntegrationValues, setInvalidFields, packageNames]);
  (0, _react.useEffect)(() => {
    // Pre-populates the name from the title set in the previous step.
    // Only executed once when the packageNames are loaded
    if (packageNames != null && (integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.name) == null && integrationSettings !== null && integrationSettings !== void 0 && integrationSettings.title) {
      const generatedName = getNameFromTitle(integrationSettings.title);
      if (!packageNames.has(generatedName) && isValidName(generatedName)) {
        setName(generatedName);
        setIntegrationValues({
          name: generatedName
        });
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [packageNames]);
  const onGenerationCompleted = (0, _react.useCallback)(result => {
    if (result) {
      setResult(result);
      setIsGenerating(false);
      setStep(4);
    }
  }, [setResult, setIsGenerating, setStep]);
  const onGenerationClosed = (0, _react.useCallback)(() => {
    setIsGenerating(false); // aborts generation
  }, [setIsGenerating]);
  const nameInputError = (0, _react.useMemo)(() => {
    if (packageNames && name && packageNames.has(name)) {
      return i18n.NAME_ALREADY_EXISTS_ERROR;
    }
  }, [packageNames, name]);
  const selectedInputTypeOptions = (0, _react.useMemo)(() => InputTypeOptions.filter(inputType => {
    var _integrationSettings$3;
    return integrationSettings === null || integrationSettings === void 0 ? void 0 : (_integrationSettings$3 = integrationSettings.inputTypes) === null || _integrationSettings$3 === void 0 ? void 0 : _integrationSettings$3.includes(inputType.value);
  }), [integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.inputTypes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    onSubmit: e => {
      e.preventDefault();
      completeStep();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    "data-test-subj": "dataStreamStep",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.INTEGRATION_NAME_TITLE,
    subtitle: i18n.INTEGRATION_NAME_DESCRIPTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.INTEGRATION_NAME_LABEL,
    helpText: !nameInputError && !invalidFields.name ? i18n.NO_SPACES_HELP : undefined,
    isInvalid: !!nameInputError || invalidFields.name,
    error: [nameInputError !== null && nameInputError !== void 0 ? nameInputError : i18n.NO_SPACES_HELP],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    "data-test-subj": "nameInput",
    value: name,
    onChange: onChange.name,
    isInvalid: !!nameInputError || invalidFields.name,
    isLoading: isLoadingPackageNames,
    disabled: isLoadingPackageNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.DATA_STREAM_TITLE,
    subtitle: i18n.DATA_STREAM_DESCRIPTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.DATA_STREAM_TITLE_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "dataStreamTitle",
    "data-test-subj": "dataStreamTitleInput",
    value: (_integrationSettings$4 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.dataStreamTitle) !== null && _integrationSettings$4 !== void 0 ? _integrationSettings$4 : '',
    onChange: onChange.dataStreamTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.DATA_STREAM_DESCRIPTION_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "dataStreamDescription",
    "data-test-subj": "dataStreamDescriptionInput",
    value: (_integrationSettings$5 = integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.dataStreamDescription) !== null && _integrationSettings$5 !== void 0 ? _integrationSettings$5 : '',
    onChange: onChange.dataStreamDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.DATA_STREAM_NAME_LABEL,
    helpText: !invalidFields.dataStreamName ? i18n.NO_SPACES_HELP : undefined,
    isInvalid: invalidFields.dataStreamName,
    error: [i18n.NO_SPACES_HELP],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "dataStreamName",
    "data-test-subj": "dataStreamNameInput",
    value: dataStreamName,
    onChange: onChange.dataStreamName,
    isInvalid: invalidFields.dataStreamName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.DATA_COLLECTION_METHOD_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "dataCollectionMethodInput",
    options: InputTypeOptions,
    selectedOptions: selectedInputTypeOptions,
    onChange: onChange.inputTypes,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 19
    }
  })), showCelOpenApiSpecButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 23
      }
    }, i18n.ADD_OPEN_API_SPEC_LABEL, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      iconType: "beaker",
      label: i18n.TECH_PREVIEW,
      tooltipContent: i18n.TECH_PREVIEW_TOOLTIP,
      size: "s",
      color: "hollow",
      "data-test-subj": "techPreviewBadge",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 25
      }
    })),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 25
      }
    }, i18n.ADD_OPEN_API_SPEC_OPTIONAL_LABEL)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 25
    }
  }, i18n.ADD_OPEN_API_SPEC_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 23
    }
  }, celInputResult ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "check",
    color: "success",
    "data-test-subj": "openApiConfigured",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 33
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 35
    }
  }, i18n.OPEN_API_SPEC_BUTTON_CONFIGURED)))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 31
    }
  }, integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.apiSpecFileName)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 29
    }
  }, integrationSettings === null || integrationSettings === void 0 ? void 0 : integrationSettings.celPath), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    onClick: () => setShowCelCreateFlyout(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 33
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 35
    }
  }, i18n.EDIT_OPEN_API_SPEC_BUTTON))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    onClick: () => setShowCelCreateFlyout(true),
    "data-test-subj": "addOpenApiSpecButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 31
    }
  }, i18n.ADD_OPEN_API_SPEC_BUTTON)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_sample_logs_input.SampleLogsInput, {
    integrationSettings: integrationSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 17
    }
  }))), isGenerating && /*#__PURE__*/_react.default.createElement(_generation_modal.GenerationModal, {
    integrationSettings: integrationSettings,
    connector: connector,
    onComplete: onGenerationCompleted,
    onClose: onGenerationClosed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 15
    }
  }))));
});
DataStreamStep.displayName = 'DataStreamStep';