"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FocusedTraceWaterfallEmbeddable = FocusedTraceWaterfallEmbeddable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _focused_trace_waterfall = require("../../components/shared/focused_trace_waterfall");
var _use_fetcher = require("../../hooks/use_fetcher");
var _loading = require("./loading");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/embeddable/trace_waterfall/focused_trace_waterfall_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FocusedTraceWaterfallEmbeddable({
  rangeFrom,
  rangeTo,
  traceId,
  docId
}) {
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/unified_traces/{traceId}/summary', {
      params: {
        path: {
          traceId
        },
        query: {
          start: rangeFrom,
          end: rangeTo,
          docId
        }
      }
    });
  }, [docId, rangeFrom, rangeTo, traceId]);
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  }
  if (data === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      "data-test-subj": "FocusedTraceWaterfallEmbeddableNoData",
      color: "danger",
      size: "s",
      title: _i18n.i18n.translate('xpack.apm.focusedTraceWaterfallEmbeddable.noDataCalloutLabel', {
        defaultMessage: 'Trace waterfall could not be loaded.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_focused_trace_waterfall.FocusedTraceWaterfall, {
    items: data,
    isEmbeddable: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 10
    }
  });
}