"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpInfoSummaryItem = HttpInfoSummaryItem;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _apmUiShared = require("@kbn/apm-ui-shared");
var _style = require("../../../../utils/style");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/summary/http_info_summary_item/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const urlStyles = (0, _react2.css)`
  display: inline-block;
  vertical-align: bottom;
  max-width: ${_style.unit * 24}px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;
function HttpInfoSummaryItem({
  status,
  method,
  url
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!url) {
    return null;
  }
  const methodLabel = _i18n.i18n.translate('xpack.apm.transactionDetails.requestMethodLabel', {
    defaultMessage: 'Request method'
  });
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        whitespace: nowrap;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: undefined,
    css: {
      marginRight: `${euiTheme.size.xs}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, method && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: methodLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    "data-test-subj": "apmHttpInfoRequestMethod",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }, method.toUpperCase())), ' ', url && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: url,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    "data-test-subj": "apmHttpInfoUrl",
    css: urlStyles,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, url))), status && /*#__PURE__*/_react.default.createElement(_apmUiShared.HttpStatusCode, {
    code: status,
    showTooltip: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 18
    }
  }));
}