"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionLink = TransactionLink;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_fetcher = require("../../../hooks/use_fetcher");
var _get_redirect_to_transaction_detail_page_url = require("../trace_link/get_redirect_to_transaction_detail_page_url");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_link/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CentralizedContainer = _styled.default.div`
  height: 100%;
  display: flex;
`;
function TransactionLink() {
  const {
    path: {
      transactionId
    },
    query: {
      rangeFrom,
      rangeTo,
      waterfallItemId
    }
  } = (0, _use_apm_params.useApmParams)('/link-to/transaction/{transactionId}');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom: rangeFrom || new Date(0).toISOString(),
    rangeTo: rangeTo || new Date().toISOString()
  });
  const {
    data = {
      transaction: null
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (transactionId) {
      return callApmApi('GET /internal/apm/transactions/{transactionId}', {
        params: {
          path: {
            transactionId
          },
          query: {
            start,
            end
          }
        }
      });
    }
  }, [transactionId, start, end]);
  if (transactionId && status === _use_fetcher.FETCH_STATUS.SUCCESS) {
    if (data.transaction) {
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: (0, _get_redirect_to_transaction_detail_page_url.getRedirectToTransactionDetailPageUrl)({
          transaction: data.transaction,
          rangeFrom,
          rangeTo,
          waterfallItemId
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(CentralizedContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "apmTrace",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.transactionLink.h2.fetchingTransactionLabel', {
      defaultMessage: 'Fetching transaction...'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
}