"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraTab = void 0;
exports.useTabs = useTabs;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _apm = require("../../../../../common/es_fields/apm");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/infra_overview/infra_tabs/use_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let InfraTab = exports.InfraTab = /*#__PURE__*/function (InfraTab) {
  InfraTab["containers"] = "containers";
  InfraTab["pods"] = "pods";
  InfraTab["hosts"] = "hosts";
  return InfraTab;
}({});
function useTabs({
  containerIds,
  podNames,
  hostNames,
  start,
  end
}) {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    metricsDataAccess
  } = services;
  const HostMetricsTable = metricsDataAccess === null || metricsDataAccess === void 0 ? void 0 : metricsDataAccess.HostMetricsTable;
  const ContainerMetricsTable = metricsDataAccess === null || metricsDataAccess === void 0 ? void 0 : metricsDataAccess.ContainerMetricsTable;
  const PodMetricsTable = metricsDataAccess === null || metricsDataAccess === void 0 ? void 0 : metricsDataAccess.PodMetricsTable;
  const timerange = (0, _react.useMemo)(() => ({
    from: start,
    to: end
  }), [start, end]);
  const hostsFilter = (0, _react.useMemo)(() => ({
    bool: {
      should: [{
        terms: {
          [_apm.HOST_NAME]: hostNames
        }
      }],
      minimum_should_match: 1
    }
  }), [hostNames]);
  const podsFilter = (0, _react.useMemo)(() => ({
    bool: {
      filter: [{
        terms: {
          [_apm.KUBERNETES_POD_NAME]: podNames
        }
      }]
    }
  }), [podNames]);
  const containersFilter = (0, _react.useMemo)(() => ({
    bool: {
      filter: [{
        terms: {
          [_apm.CONTAINER_ID]: containerIds
        }
      }]
    }
  }), [containerIds]);
  const containerMetricsTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), ContainerMetricsTable && ContainerMetricsTable({
    timerange,
    filterClauseDsl: containersFilter
  }));
  const podMetricsTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), PodMetricsTable && PodMetricsTable({
    timerange,
    filterClauseDsl: podsFilter
  }));
  const hostMetricsTable = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }), HostMetricsTable && HostMetricsTable({
    timerange,
    filterClauseDsl: hostsFilter
  }));
  const tabs = [{
    id: InfraTab.containers,
    name: _i18n.i18n.translate('xpack.apm.views.infra.tabs.containers', {
      defaultMessage: 'Containers'
    }),
    content: containerMetricsTable,
    hidden: containerIds && containerIds.length <= 0
  }, {
    id: InfraTab.pods,
    name: _i18n.i18n.translate('xpack.apm.views.infra.tabs.pods', {
      defaultMessage: 'Pods'
    }),
    content: podMetricsTable,
    hidden: podNames && podNames.length <= 0
  }, {
    id: InfraTab.hosts,
    name: _i18n.i18n.translate('xpack.apm.views.infra.tabs.hosts', {
      defaultMessage: 'Hosts'
    }),
    content: hostMetricsTable
  }];
  return tabs.filter(t => !t.hidden).map(({
    id,
    name,
    content
  }) => ({
    id,
    name,
    content
  }));
}