"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exceptionStacktraceTab = exports.ErrorTabKey = void 0;
exports.getTabs = getTabs;
exports.metadataTab = exports.logStacktraceTab = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ErrorTabKey = exports.ErrorTabKey = /*#__PURE__*/function (ErrorTabKey) {
  ErrorTabKey["LogStackTrace"] = "log_stacktrace";
  ErrorTabKey["ExceptionStacktrace"] = "exception_stacktrace";
  ErrorTabKey["Metadata"] = "metadata";
  return ErrorTabKey;
}({});
const logStacktraceTab = exports.logStacktraceTab = {
  key: ErrorTabKey.LogStackTrace,
  label: _i18n.i18n.translate('xpack.apm.errorGroup.tabs.logStacktraceLabel', {
    defaultMessage: 'Log stack trace'
  })
};
const exceptionStacktraceTab = exports.exceptionStacktraceTab = {
  key: ErrorTabKey.ExceptionStacktrace,
  label: _i18n.i18n.translate('xpack.apm.errorGroup.tabs.exceptionStacktraceLabel', {
    defaultMessage: 'Exception stack trace'
  })
};
const metadataTab = exports.metadataTab = {
  key: ErrorTabKey.Metadata,
  label: _i18n.i18n.translate('xpack.apm.errorGroup.tabs.metadataLabel', {
    defaultMessage: 'Metadata'
  })
};
function getTabs(error) {
  var _error$error$log;
  const hasLogStacktrace = !(0, _lodash.isEmpty)(error === null || error === void 0 ? void 0 : (_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.stacktrace);
  return [...(hasLogStacktrace ? [logStacktraceTab] : []), exceptionStacktraceTab, metadataTab];
}