"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCountRuleType = ErrorCountRuleType;
exports.default = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _formatters = require("../../../../../common/utils/formatters");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _chart_preview = require("../../ui_components/chart_preview");
var _fields = require("../../utils/fields");
var _helper = require("../../utils/helper");
var _apm_rule_params_container = require("../../ui_components/apm_rule_params_container");
var _apm_rule_group_by = require("../../ui_components/apm_rule_group_by");
var _apm = require("../../../../../common/es_fields/apm");
var _chart_preview_helper = require("../../ui_components/chart_preview/chart_preview_helper");
var _apm_rule_kql_filter = require("../../ui_components/apm_rule_kql_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/rule_types/error_count_rule_type/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ErrorCountRuleType(props) {
  var _errorCountChartPrevi, _errorCountChartPrevi2;
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ruleParams,
    metadata,
    setRuleParams,
    setRuleProperty
  } = props;
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const params = (0, _lodash.defaults)({
    ...(0, _lodash.omit)(metadata, ['start', 'end']),
    ...ruleParams
  }, {
    threshold: 25,
    windowSize: 5,
    windowUnit: _public2.TIME_UNITS.MINUTE,
    environment: _environment_filter_values.ENVIRONMENT_ALL.value
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    const {
      interval,
      start,
      end
    } = (0, _helper.getIntervalAndTimeRange)({
      windowSize: params.windowSize,
      windowUnit: params.windowUnit
    });
    if (params.windowSize && start && end) {
      var _params$searchConfigu, _params$searchConfigu2;
      return callApmApi('GET /internal/apm/rule_types/error_count/chart_preview', {
        params: {
          query: {
            environment: params.environment,
            serviceName: params.serviceName,
            errorGroupingKey: params.errorGroupingKey,
            interval,
            start,
            end,
            groupBy: params.groupBy,
            searchConfiguration: (_params$searchConfigu = params.searchConfiguration) !== null && _params$searchConfigu !== void 0 && (_params$searchConfigu2 = _params$searchConfigu.query) !== null && _params$searchConfigu2 !== void 0 && _params$searchConfigu2.query ? JSON.stringify(params.searchConfiguration) : undefined
          }
        }
      });
    }
  }, [params.windowSize, params.windowUnit, params.environment, params.serviceName, params.errorGroupingKey, params.groupBy, params.searchConfiguration]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group !== null && group !== void 0 ? group : []);
  }, [setRuleParams]);
  const filterFields = [/*#__PURE__*/_react.default.createElement(_fields.ServiceField, {
    currentValue: params.serviceName,
    onChange: value => {
      if (value !== params.serviceName) {
        setRuleParams('serviceName', value);
        setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
        setRuleParams('errorGroupingKey', undefined);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.EnvironmentField, {
    currentValue: params.environment,
    onChange: value => setRuleParams('environment', value !== '' ? value : _environment_filter_values.ENVIRONMENT_ALL.value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.ErrorGroupingKeyField, {
    currentValue: params.errorGroupingKey,
    onChange: value => setRuleParams('errorGroupingKey', value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  })];
  const criteriaFields = [/*#__PURE__*/_react.default.createElement(_fields.IsAboveField, {
    value: params.threshold,
    unit: _i18n.i18n.translate('xpack.apm.errorCountRuleType.errors', {
      defaultMessage: ' errors'
    }),
    onChange: value => setRuleParams('threshold', value || 0),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    onChangeWindowSize: timeWindowSize => setRuleParams('windowSize', timeWindowSize || ''),
    onChangeWindowUnit: timeWindowUnit => setRuleParams('windowUnit', timeWindowUnit),
    timeWindowSize: params.windowSize,
    timeWindowUnit: params.windowUnit,
    errors: {
      timeWindowSize: [],
      timeWindowUnit: []
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  })];
  const fields = [...(!ruleParams.useKqlFilter ? filterFields : []), ...criteriaFields];
  const errorCountChartPreview = data === null || data === void 0 ? void 0 : data.errorCountChartPreview;
  const series = (_errorCountChartPrevi = errorCountChartPreview === null || errorCountChartPreview === void 0 ? void 0 : errorCountChartPreview.series) !== null && _errorCountChartPrevi !== void 0 ? _errorCountChartPrevi : [];
  const hasData = series.length > 0;
  const totalGroups = (_errorCountChartPrevi2 = errorCountChartPreview === null || errorCountChartPreview === void 0 ? void 0 : errorCountChartPreview.totalGroups) !== null && _errorCountChartPrevi2 !== void 0 ? _errorCountChartPrevi2 : 0;
  const chartPreview = (0, _use_fetcher.isPending)(status) ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.LoadingState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }) : !hasData ? /*#__PURE__*/_react.default.createElement(_chart_preview_helper.NoDataState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 5
    }
  }) : status === _use_fetcher.FETCH_STATUS.SUCCESS ? /*#__PURE__*/_react.default.createElement(_chart_preview.ChartPreview, {
    series: series,
    threshold: params.threshold,
    yTickFormat: _formatters.asInteger,
    uiSettings: services.uiSettings,
    timeSize: params.windowSize,
    timeUnit: params.windowUnit,
    totalGroups: totalGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_chart_preview_helper.ErrorState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  });
  const groupAlertsBy = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.ruleFlyout.errorCount.createAlertPerText', {
      defaultMessage: 'Group alerts by'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.ruleFlyout.errorCount.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "transaction.name". By default, alert is created for every unique service.name and service.environment.'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_rule_group_by.APMRuleGroupBy, {
    onChange: onGroupByChange,
    options: {
      groupBy: ruleParams.groupBy
    },
    fields: [_apm.TRANSACTION_NAME, _apm.ERROR_GROUP_ID, _apm.ERROR_GROUP_NAME],
    preSelectedOptions: [_apm.SERVICE_NAME, _apm.SERVICE_ENVIRONMENT],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }));
  const onToggleKqlFilter = e => {
    setRuleParams('serviceName', undefined);
    setRuleParams('errorGroupingKey', undefined);
    setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
    setRuleParams('searchConfiguration', {
      query: {
        query: '',
        language: 'kuery'
      }
    });
    setRuleParams('useKqlFilter', e.target.checked);
  };
  const kqlFilter = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_apm_rule_kql_filter.ApmRuleKqlFilter, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams,
    onToggleKqlFilter: onToggleKqlFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_apm_rule_params_container.ApmRuleParamsContainer, {
    minimumWindowSize: {
      value: 5,
      unit: _public2.TIME_UNITS.MINUTE
    },
    defaultParams: params,
    fields: fields,
    groupAlertsBy: groupAlertsBy,
    kqlFilter: kqlFilter,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty,
    chartPreview: chartPreview,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 5
    }
  });
}

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = exports.default = ErrorCountRuleType;