"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mappingFromFieldMap = mappingFromFieldMap;
var _saferLodashSet = require("@kbn/safer-lodash-set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mappingFromFieldMap(fieldMap, dynamic = 'strict') {
  const mappings = {
    dynamic,
    properties: {}
  };
  const fields = Object.keys(fieldMap).filter(key => fieldMap[key].type !== 'unmapped').map(key => {
    const field = fieldMap[key];
    return {
      name: key,
      ...field
    };
  });
  fields.forEach(field => {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    const {
      name,
      required,
      array,
      multi_fields,
      ...rest
    } = field;
    const mapped = multi_fields ? {
      ...rest,
      // eslint-disable-next-line @typescript-eslint/naming-convention
      fields: multi_fields.reduce((acc, multi_field) => {
        acc[multi_field.name] = {
          type: multi_field.type
        };
        return acc;
      }, {})
    } : rest;
    (0, _saferLodashSet.set)(mappings.properties, field.name.split('.').join('.properties.'), mapped);
    if (name === '@timestamp') {
      (0, _saferLodashSet.set)(mappings.properties, `${name}.ignore_malformed`, false);
    }
  });
  return mappings;
}