"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityContextProvider = DatasetQualityContextProvider;
exports.useDatasetQualityContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _url_state_storage_service = require("./url_state_storage_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/data_quality/public/routes/dataset_quality/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatasetQualityContext = /*#__PURE__*/(0, _react.createContext)({});
function DatasetQualityContextProvider({
  children,
  urlStateStorageContainer,
  toastsService,
  datasetQuality
}) {
  const [controller, setController] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function getDatasetQualityController() {
      const initialState = (0, _url_state_storage_service.getDatasetQualityStateFromUrl)({
        urlStateStorageContainer,
        toastsService
      });
      const datasetQualityController = await datasetQuality.createDatasetQualityController({
        initialState
      });
      datasetQualityController.service.start();
      setController(datasetQualityController);
      const datasetQualityStateSubscription = datasetQualityController.state$.subscribe(state => {
        (0, _url_state_storage_service.updateUrlFromDatasetQualityState)({
          urlStateStorageContainer,
          datasetQualityState: state
        });
      });
      return () => {
        datasetQualityController.service.stop();
        datasetQualityStateSubscription.unsubscribe();
      };
    }
    getDatasetQualityController();
  }, [datasetQuality, toastsService, urlStateStorageContainer]);
  return /*#__PURE__*/_react.default.createElement(DatasetQualityContext.Provider, {
    value: {
      controller
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, children);
}
const useDatasetQualityContext = () => {
  const context = (0, _react.useContext)(DatasetQualityContext);
  if (context === undefined) {
    throw new Error('useDatasetQualityContext must be used within a <DatasetQualityContextProvider />');
  }
  return context;
};
exports.useDatasetQualityContext = useDatasetQualityContext;