"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionsColumn = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _actions = require("../actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/columns/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const actionsColumn = ({
  api,
  core,
  onActionComplete,
  allowedActions
}) => ({
  field: 'actions',
  name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerActions', {
    defaultMessage: 'Actions'
  }),
  sortable: false,
  align: 'right',
  render: (actions, session) => {
    if (!(actions !== null && actions !== void 0 && actions.length)) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "l",
      justifyContent: "flexEnd",
      alignItems: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "sessionManagementActionsCol",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_actions.PopoverActionsMenu, {
      api: api,
      key: `popkey-${session.id}`,
      session: session,
      core: core,
      allowedActions: allowedActions,
      onActionComplete: onActionComplete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    })));
  }
});
exports.actionsColumn = actionsColumn;