"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadDashboardApi = loadDashboardApi;
var _contentManagementContentInsightsPublic = require("@kbn/content-management-content-insights-public");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _kibana_services = require("../../services/kibana_services");
var _logger = require("../../services/logger");
var _get_dashboard_api = require("../get_dashboard_api");
var _query_performance_tracking = require("../performance/query_performance_tracking");
var _transform_panels = require("./transform_panels");
var _dashboard_client = require("../../dashboard_client");
var _default_dashboard_state = require("../default_dashboard_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function loadDashboardApi({
  getCreationOptions,
  savedObjectId
}) {
  var _creationOptions$getI, _creationOptions$vali, _creationOptions$getI2, _creationOptions$getI3;
  const creationStartTime = performance.now();
  const creationOptions = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions());
  const incomingEmbeddables = creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getI = creationOptions.getIncomingEmbeddables) === null || _creationOptions$getI === void 0 ? void 0 : _creationOptions$getI.call(creationOptions);
  const savedObjectResult = savedObjectId ? await _dashboard_client.dashboardClient.get(savedObjectId) : undefined;
  const validationResult = savedObjectResult && (creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$vali = creationOptions.validateLoadedSavedObject) === null || _creationOptions$vali === void 0 ? void 0 : _creationOptions$vali.call(creationOptions, savedObjectResult));
  if (validationResult === 'invalid') {
    // throw error to stop the rest of Dashboard loading and make the factory throw an Error
    throw new Error('Dashboard failed saved object result validation');
  } else if (validationResult === 'redirected') {
    return;
  }
  const unsavedChanges = creationOptions !== null && creationOptions !== void 0 && creationOptions.useSessionStorageIntegration ? (0, _dashboard_backup_service.getDashboardBackupService)().getState(savedObjectId) : undefined;
  const {
    viewMode,
    ...overrideState
  } = (_creationOptions$getI2 = creationOptions === null || creationOptions === void 0 ? void 0 : (_creationOptions$getI3 = creationOptions.getInitialInput) === null || _creationOptions$getI3 === void 0 ? void 0 : _creationOptions$getI3.call(creationOptions)) !== null && _creationOptions$getI2 !== void 0 ? _creationOptions$getI2 : {};
  if (overrideState.panels) {
    overrideState.panels = await (0, _transform_panels.transformPanels)(overrideState.panels, overrideState.references);
  }

  // Back up any view mode passed in explicitly.
  if (viewMode) {
    (0, _dashboard_backup_service.getDashboardBackupService)().storeViewMode(viewMode);
  }
  const {
    api,
    cleanup,
    internalApi
  } = (0, _get_dashboard_api.getDashboardApi)({
    creationOptions,
    incomingEmbeddables,
    initialState: {
      ..._default_dashboard_state.DEFAULT_DASHBOARD_STATE,
      ...(savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.data),
      ...unsavedChanges,
      ...overrideState
    },
    savedObjectResult,
    savedObjectId
  });
  const performanceSubscription = (0, _query_performance_tracking.startQueryPerformanceTracking)(api, {
    firstLoad: true,
    creationStartTime
  });
  if (savedObjectId && !(incomingEmbeddables !== null && incomingEmbeddables !== void 0 && incomingEmbeddables.length)) {
    // We count a new view every time a user opens a dashboard, both in view or edit mode
    // We don't count views when a user is editing a dashboard and is returning from an editor after saving
    // however, there is an edge case that we now count a new view when a user is editing a dashboard and is returning from an editor by canceling
    // TODO: this should be revisited by making embeddable transfer support canceling logic https://github.com/elastic/kibana/issues/190485
    const contentInsightsClient = new _contentManagementContentInsightsPublic.ContentInsightsClient({
      http: _kibana_services.coreServices.http,
      logger: _logger.logger
    }, {
      domainId: 'dashboard'
    });
    contentInsightsClient.track(savedObjectId, 'viewed');
  }
  return {
    api,
    cleanup: () => {
      cleanup();
      performanceSubscription.unsubscribe();
    },
    internalApi
  };
}