"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FatalErrorsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _rxjs = require("rxjs");
var _reactKibanaContextRoot = require("@kbn/react-kibana-context-root");
var _fatal_error_screen = require("./fatal_error_screen");
var _utils = require("./utils");
var _generic_error = require("./generic_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/fatal-errors/browser-internal/src/fatal_errors_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @internal */

/** @internal */
class FatalErrorsService {
  /**
   *
   * @param rootDomElement
   * @param onFirstErrorCb - Callback function that gets executed after the first error,
   *   but before the FatalErrorsService renders the error to the DOM.
   */
  constructor(rootDomElement, onFirstErrorCb) {
    (0, _defineProperty2.default)(this, "error$", new _rxjs.ReplaySubject());
    (0, _defineProperty2.default)(this, "fatalErrors", void 0);
    (0, _defineProperty2.default)(this, "handlers", new Map());
    this.rootDomElement = rootDomElement;
    this.onFirstErrorCb = onFirstErrorCb;
  }
  setup(deps) {
    this.error$.pipe((0, _rxjs.first)(), (0, _rxjs.tap)(() => {
      this.onFirstErrorCb();
      this.renderError(deps);
    })).subscribe({
      error: error => {
        // eslint-disable-next-line no-console
        console.error('Uncaught error in fatal error service internals', error);
      }
    });
    this.fatalErrors = {
      add: (error, source) => {
        this.error$.next({
          error,
          source
        });
        if (error instanceof Error) {
          // make stack traces clickable by putting whole error in the console
          // eslint-disable-next-line no-console
          console.error(error);
        }
        throw error;
      },
      catch: this.handlers.set.bind(this.handlers)
    };
    this.setupGlobalErrorHandlers();
    return this.fatalErrors;
  }
  start() {
    if (!this.fatalErrors) {
      throw new Error('FatalErrorsService#setup() must be invoked before start.');
    }
    return this.fatalErrors;
  }
  renderError(deps) {
    const {
      analytics,
      i18n,
      theme,
      injectedMetadata
    } = deps;
    // delete all content in the rootDomElement
    this.rootDomElement.textContent = '';

    // create and mount a container for the <FatalErrorScreen>
    const container = document.createElement('div');
    this.rootDomElement.appendChild(container);
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRoot.KibanaRootContextProvider, {
      analytics: analytics,
      i18n: i18n,
      theme: theme,
      globalStyles: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_fatal_error_screen.FatalErrorScreen, {
      error$: this.error$,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 9
      }
    }, errors => this.renderCustomError(errors) || /*#__PURE__*/_react.default.createElement(_generic_error.GenericError, {
      buildNumber: injectedMetadata.getKibanaBuildNumber(),
      errors: errors,
      kibanaVersion: injectedMetadata.getKibanaVersion(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    }))), container);
  }
  renderCustomError(errors) {
    for (const [condition, handler] of this.handlers) {
      if (errors.length && errors.every(error => condition(error))) {
        return handler(errors);
      }
    }
    return null;
  }
  setupGlobalErrorHandlers() {
    var _window$addEventListe, _window;
    (_window$addEventListe = (_window = window).addEventListener) === null || _window$addEventListe === void 0 ? void 0 : _window$addEventListe.call(_window, 'unhandledrejection', e => {
      // eslint-disable-next-line no-console
      console.log(`Detected an unhandled Promise rejection.\n
      Message: ${(0, _utils.formatError)(e.reason)}\n
      Stack: ${(0, _utils.formatStack)(e.reason)}`);
    });
  }
}
exports.FatalErrorsService = FatalErrorsService;