"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _pLimit = _interopRequireDefault(require("p-limit"));
var _dataStreams = require("@kbn/data-streams");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
class DataStreamsService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "dataStreams", new Map());
    this.coreContext = coreContext;
    this.logger = this.coreContext.logger.get('data-streams');
  }
  setup() {
    return {
      registerDataStream: dataStreamDefinition => {
        this.dataStreams.set(dataStreamDefinition, undefined);
      }
    };
  }
  async start({
    elasticsearch
  }) {
    const limit = (0, _pLimit.default)(5);
    const setupPromises = [];
    for (const dataStreamDefinition of this.dataStreams.keys()) {
      setupPromises.push(limit(async () => {
        this.dataStreams.set(dataStreamDefinition, await _dataStreams.DataStreamClient.initialize({
          dataStreams: dataStreamDefinition,
          elasticsearchClient: elasticsearch.client.asInternalUser,
          logger: this.logger
        }));
      }));
    }
    await Promise.all(setupPromises);
    return {
      getClient: dataStreamDefinition => {
        if (!this.dataStreams.has(dataStreamDefinition)) {
          throw new Error(`Data stream ${dataStreamDefinition.name} is not registered.`);
        }
        const client = this.dataStreams.get(dataStreamDefinition);
        if (!client) {
          throw new Error(`Data stream client for ${dataStreamDefinition.name} is not initialized. Are you sure you are providing the same definition as in setup?`);
        }
        return client;
      }
    };
  }
  stop() {}
}
exports.DataStreamsService = DataStreamsService;