"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.crawlersBreadcrumbs = exports.connectorsBreadcrumbs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _default_settings_flyout = require("../settings/default_settings_flyout");
var _connector_stats = require("./connector_stats");
var _connectors_logic = require("./connectors_logic");
var _connectors_table = require("./connectors_table");
var _delete_connector_modal = require("./delete_connector_modal");
var _elastic_managed_web_crawler_empty_prompt = require("./elastic_managed_web_crawler_empty_prompt");
var _self_managed_web_crawler_empty_prompt = require("./self_managed_web_crawler_empty_prompt");
var _utils = require("./utils");
var _routes = require("../routes");
var _translations = require("./translations");
var _use_kibana = require("../../utils/use_kibana");
var _use_breadcrumbs = require("../../utils/use_breadcrumbs");
var _page_template = require("../shared/page_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateConnector = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./create_connector/create_connector'))));
const connectorsBreadcrumbs = exports.connectorsBreadcrumbs = [{
  text: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.breadcrumb', {
    defaultMessage: 'Content Connectors'
  }),
  href: '/connectors'
}];
const crawlersBreadcrumbs = exports.crawlersBreadcrumbs = [{
  text: _i18n.i18n.translate('xpack.contentConnectors.content.crawlers.breadcrumb', {
    defaultMessage: 'Web Crawlers'
  })
}];
const Connectors = ({
  isCrawler,
  isCrawlerSelfManaged
}) => {
  const {
    services: {
      application,
      http
    }
  } = (0, _public.useKibana)();
  const {
    services: {
      chrome,
      appParams
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    fetchConnectors,
    onPaginate,
    setIsFirstRequest,
    openDeleteModal
  } = (0, _kea.useActions)((0, _connectors_logic.ConnectorsLogic)({
    http
  }));
  const {
    data,
    isLoading,
    searchParams,
    isEmpty,
    connectors
  } = (0, _kea.useValues)((0, _connectors_logic.ConnectorsLogic)({
    http
  }));
  const [searchQuery, setSearchValue] = (0, _react.useState)('');
  const [showMoreOptionsPopover, setShowMoreOptionsPopover] = (0, _react.useState)(false);
  const [showDefaultSettingsFlyout, setShowDefaultSettingsFlyout] = (0, _react.useState)(false);
  (0, _use_breadcrumbs.useBreadcrumbs)(!isCrawler ? connectorsBreadcrumbs : crawlersBreadcrumbs, appParams, chrome);
  (0, _react.useEffect)(() => {
    setIsFirstRequest();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isCrawler]);
  (0, _react.useEffect)(() => {
    fetchConnectors({
      ...searchParams,
      fetchCrawlersOnly: isCrawler,
      searchQuery,
      http
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [searchParams.from, searchParams.size, searchQuery, isCrawler]);
  return !isLoading && isEmpty && !isCrawler ? /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CreateConnector, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_page_template.SearchConnectorsPageTemplateWrapper, {
    isLoading: isLoading,
    pageHeader: {
      pageTitle: !isCrawler ? _i18n.i18n.translate('xpack.contentConnectors.title', {
        defaultMessage: 'Content connectors'
      }) : _i18n.i18n.translate('xpack.contentConnectors.crawlers.title', {
        defaultMessage: 'Elastic Web Crawler'
      }),
      description: [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.webcrawlers.headerContent",
        defaultMessage: "Discover extract and index searchable content from websites and knowledge bases {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "entSearchContentConnectorsLearnMoreLink",
            external: true,
            target: "_blank",
            href: 'https://github.com/elastic/crawler',
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 125,
              columnNumber: 21
            }
          }, _translations.LEARN_MORE_LINK)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 15
        }
      })))],
      rightSideGroupProps: {
        gutterSize: 's',
        responsive: false
      },
      rightSideItems: isLoading ? [] : !isCrawler ? [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "entSearchContent-connectors-newConnectorButton",
        "data-telemetry-id": "entSearchContent-connectors-newConnectorButton",
        key: "newConnector",
        color: "primary",
        iconType: "plusInCircle",
        fill: true,
        onClick: () => {
          const url = application === null || application === void 0 ? void 0 : application.getUrlForApp('management', {
            path: `/data/content_connectors`
          });
          application === null || application === void 0 ? void 0 : application.navigateToUrl(`${url}${_routes.NEW_INDEX_SELECT_CONNECTOR_PATH}`);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.newConnectorButtonLabel",
        defaultMessage: "New Connector",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 21
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        isOpen: showMoreOptionsPopover,
        closePopover: () => setShowMoreOptionsPopover(false),
        button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "data-test-subj": "entSearchContent-connectors-newConnector-moreOptionsButton",
          "data-telemetry-id": "entSearchContent-connectors-newConnector-moreOptionsButton",
          color: "primary",
          display: "fill",
          size: "m",
          iconType: "boxesVertical",
          "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.connectors.more.ariaLabel', {
            defaultMessage: 'More options'
          }),
          onClick: () => setShowMoreOptionsPopover(!showMoreOptionsPopover),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 174,
            columnNumber: 23
          }
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        size: "s",
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          size: "s",
          key: "newConnectorNative",
          onClick: () => {
            const url = application === null || application === void 0 ? void 0 : application.getUrlForApp('management', {
              path: `/data/content_connectors`
            });
            application === null || application === void 0 ? void 0 : application.navigateToUrl(`${url}${_routes.NEW_INDEX_SELECT_CONNECTOR_NATIVE_PATH}`);
          },
          icon: "plusInCircle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 192,
            columnNumber: 25
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newNativeConnectorButtonLabel', {
          defaultMessage: 'New Elastic managed Connector'
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
          size: "s",
          key: "newConnectorClient",
          icon: "plusInCircle",
          onClick: () => {
            const url = application === null || application === void 0 ? void 0 : application.getUrlForApp('management', {
              path: `/data/content_connectors`
            });
            application === null || application === void 0 ? void 0 : application.navigateToUrl(`${url}${_routes.NEW_INDEX_SELECT_CONNECTOR_CLIENTS_PATH}`);
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 212,
            columnNumber: 25
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newConnectorsClientButtonLabel', {
          defaultMessage: 'New Self-managed Connector'
        }))],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 21
        }
      })))), ...[/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        "data-test-subj": "entSearchContent-searchIndices-defaultSettings",
        onClick: () => setShowDefaultSettingsFlyout(true),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.contentConnectors.content.searchIndices.defaultSettings', {
        defaultMessage: 'Default settings'
      }))]] : undefined
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_delete_connector_modal.DeleteConnectorModal, {
    isCrawler: isCrawler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showDefaultSettingsFlyout && /*#__PURE__*/_react.default.createElement(_default_settings_flyout.DefaultSettingsFlyout, {
    closeFlyout: () => setShowDefaultSettingsFlyout(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  }), !isCrawler && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_stats.ConnectorStats, {
    isCrawler: isCrawler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  }, isEmpty && isCrawler ? isCrawlerSelfManaged ? /*#__PURE__*/_react.default.createElement(_self_managed_web_crawler_empty_prompt.SelfManagedWebCrawlerEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_elastic_managed_web_crawler_empty_prompt.ElasticManagedWebCrawlerEmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 19
    }
  }, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors.connectorsTable.h2.availableConnectorsLabel",
    defaultMessage: "Available connectors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 23
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors.connectorsTable.h2.availableCrawlersLabel",
    defaultMessage: "Available web crawlers",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchQuery,
    box: {
      incremental: true,
      placeholder: !isCrawler ? _i18n.i18n.translate('xpack.contentConnectorsTable.euiSearchBar.filterConnectorsPlaceholder', {
        defaultMessage: 'Filter connectors'
      }) : _i18n.i18n.translate('xpack.contentConnectorsTable.euiSearchBar.filterCrawlersPlaceholder', {
        defaultMessage: 'Filter web crawlers'
      })
    },
    "aria-label": !isCrawler ? _i18n.i18n.translate('xpack.contentConnectorsTable.euiSearchBar.filterConnectorsLabel', {
      defaultMessage: 'Filter connectors'
    }) : _i18n.i18n.translate('xpack.contentConnectorsTable.euiSearchBar.filterCrawlersLabel', {
      defaultMessage: 'Filter web crawlers'
    }),
    onChange: event => setSearchValue(event.queryText),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_connectors_table.ConnectorsTable, {
    isCrawler: isCrawler,
    items: connectors || [],
    meta: data === null || data === void 0 ? void 0 : data.meta,
    onChange: (0, _utils.handlePageChange)(onPaginate),
    onDelete: openDeleteModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 15
    }
  })))));
};
// eslint-disable-next-line import/no-default-export
exports.default = Connectors;