"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAutocompleteInfo = exports.getAutocompleteInfo = exports.ENTITIES = exports.AutocompleteInfo = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-utils-plugin/public");
var _constants = require("../../common/constants");
var _autocomplete_entities = require("../lib/autocomplete_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let ENTITIES = exports.ENTITIES = /*#__PURE__*/function (ENTITIES) {
  ENTITIES["INDICES"] = "indices";
  ENTITIES["FIELDS"] = "fields";
  ENTITIES["INDEX_TEMPLATES"] = "indexTemplates";
  ENTITIES["COMPONENT_TEMPLATES"] = "componentTemplates";
  ENTITIES["LEGACY_TEMPLATES"] = "legacyTemplates";
  ENTITIES["DATA_STREAMS"] = "dataStreams";
  return ENTITIES;
}({});
class AutocompleteInfo {
  constructor() {
    (0, _defineProperty2.default)(this, "alias", new _autocomplete_entities.Alias());
    (0, _defineProperty2.default)(this, "mapping", new _autocomplete_entities.Mapping());
    (0, _defineProperty2.default)(this, "dataStream", new _autocomplete_entities.DataStream());
    (0, _defineProperty2.default)(this, "legacyTemplate", new _autocomplete_entities.LegacyTemplate());
    (0, _defineProperty2.default)(this, "indexTemplate", new _autocomplete_entities.IndexTemplate());
    (0, _defineProperty2.default)(this, "componentTemplate", new _autocomplete_entities.ComponentTemplate());
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "pollTimeoutId", void 0);
    /**
     * Indicates if autocomplete_entities fetching is in progress.
     */
    (0, _defineProperty2.default)(this, "_isLoading$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "isLoading$", this._isLoading$.asObservable());
  }
  setup(http) {
    this.http = http;
  }
  getEntityProvider(type, context = {
    indices: [],
    types: []
  }) {
    switch (type) {
      case ENTITIES.INDICES:
        const includeAliases = true;
        const collaborator = this.mapping;
        return () => [...this.alias.getIndices(includeAliases, collaborator), ...this.dataStream.getDataStreams()];
      case ENTITIES.FIELDS:
        return this.mapping.getMappings(context.indices, context.types, Object.getPrototypeOf(context));
      case ENTITIES.INDEX_TEMPLATES:
        return () => this.indexTemplate.getTemplates();
      case ENTITIES.COMPONENT_TEMPLATES:
        return () => this.componentTemplate.getTemplates();
      case ENTITIES.LEGACY_TEMPLATES:
        return () => this.legacyTemplate.getTemplates();
      case ENTITIES.DATA_STREAMS:
        return () => this.dataStream.getDataStreams();
      default:
        throw new Error(`Unsupported type: ${type}`);
    }
  }
  retrieve(settings, settingsToRetrieve) {
    this.clearSubscriptions();
    this._isLoading$.next(true);
    this.http.get(`${_constants.API_BASE_PATH}/autocomplete_entities`, {
      query: {
        ...settingsToRetrieve
      }
    }).then(data => {
      this.load(data);
      // Schedule next request.
      this.pollTimeoutId = setTimeout(() => {
        // This looks strange/inefficient, but it ensures correct behavior because we don't want to send
        // a scheduled request if the user turns off polling.
        if (settings.getPolling()) {
          this.retrieve(settings, settings.getAutocomplete());
        }
      }, settings.getPollInterval());
    }).finally(() => {
      this._isLoading$.next(false);
    });
  }
  clearSubscriptions() {
    if (this.pollTimeoutId) {
      clearTimeout(this.pollTimeoutId);
    }
  }
  load(data) {
    const collaborator = this.mapping;
    this.alias.loadAliases(data.aliases, collaborator);
    this.indexTemplate.loadTemplates(data.indexTemplates);
    this.componentTemplate.loadTemplates(data.componentTemplates);
    this.legacyTemplate.loadTemplates(data.legacyTemplates);
    this.dataStream.loadDataStreams(data.dataStreams);
  }
  clear() {
    this.alias.clearAliases();
    this.mapping.clearMappings();
    this.dataStream.clearDataStreams();
    this.legacyTemplate.clearTemplates();
    this.indexTemplate.clearTemplates();
    this.componentTemplate.clearTemplates();
  }
}
exports.AutocompleteInfo = AutocompleteInfo;
const [getAutocompleteInfo, setAutocompleteInfo] = (0, _public.createGetterSetter)('AutocompleteInfo');
exports.setAutocompleteInfo = setAutocompleteInfo;
exports.getAutocompleteInfo = getAutocompleteInfo;