"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Editor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _components = require("../../components");
var _services = require("../../../services");
var _contexts = require("../../contexts");
var _monaco_editor = require("./monaco_editor");
var _monaco_editor_output = require("./monaco_editor_output");
var _utils = require("../../../lib/utils");
var _styles = require("../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/editor/editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_PANEL_SIZE = 50;
const PANEL_MIN_SIZE = '20%';
const DEBOUNCE_DELAY = 500;
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    consoleEditorPanel: _styles.consoleEditorPanelStyles,
    requestProgressBarContainer: (0, _react2.css)`
      position: relative;
      z-index: ${euiTheme.levels.menu};
    `,
    resizerButton: (0, _styles.useResizerButtonStyles)(),
    // Consolidated styles for editor panels with positioning
    editorPanelPositioned: (0, _react2.css)`
      top: 0;
      height: calc(100% - 40px);
    `,
    outputPanelCentered: (0, _react2.css)`
      align-content: center;
      top: 0;
      height: calc(100% - 40px);
    `,
    actionsPanelWithBackground: (0, _react2.css)`
      background-color: ${euiTheme.colors.backgroundBasePlain};
    `,
    fullHeightPanel: (0, _react2.css)`
      height: 100%;
    `
  };
};
const Editor = exports.Editor = /*#__PURE__*/(0, _react.memo)(({
  loading,
  inputEditorValue,
  setInputEditorValue
}) => {
  var _getResponseWithMostS;
  const {
    services: {
      storage,
      objectStorageClient
    }
  } = (0, _contexts.useServicesContext)();
  const styles = useStyles();
  const {
    currentTextObject,
    customParsedRequestsProvider
  } = (0, _contexts.useEditorReadContext)();
  const {
    requestInFlight,
    lastResult: {
      data: requestData,
      error: requestError
    }
  } = (0, _contexts.useRequestReadContext)();
  const dispatch = (0, _contexts.useRequestActionContext)();
  const editorDispatch = (0, _contexts.useEditorActionContext)();
  const [fetchingAutocompleteEntities, setFetchingAutocompleteEntities] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const debouncedSetFechingAutocompleteEntities = (0, _lodash.debounce)(setFetchingAutocompleteEntities, DEBOUNCE_DELAY);
    const subscription = (0, _services.getAutocompleteInfo)().isLoading$.subscribe(debouncedSetFechingAutocompleteEntities);
    return () => {
      subscription.unsubscribe();
      debouncedSetFechingAutocompleteEntities.cancel();
    };
  }, []);
  const [firstPanelSize, secondPanelSize] = storage.get(_services.StorageKeys.SIZE, [INITIAL_PANEL_SIZE, INITIAL_PANEL_SIZE]);
  const isVerticalLayout = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const onPanelSizeChange = (0, _react.useCallback)((0, _lodash.debounce)(sizes => {
    storage.set(_services.StorageKeys.SIZE, Object.values(sizes));
  }, 300), []);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedUpdateLocalStorageValue = (0, _react.useCallback)((0, _lodash.debounce)(newValue => {
    const textObject = {
      ...currentTextObject,
      text: newValue,
      updatedAt: Date.now()
    };
    objectStorageClient.text.update(textObject);
    editorDispatch({
      type: 'setCurrentTextObject',
      payload: textObject
    });
  }, DEBOUNCE_DELAY), []);

  // Always keep the localstorage value in sync with the value in the editor
  // to avoid losing the text object when the user navigates away from the shell
  (0, _react.useEffect)(() => {
    debouncedUpdateLocalStorageValue(inputEditorValue);
  }, [debouncedUpdateLocalStorageValue, inputEditorValue]);
  if (!currentTextObject) return null;
  const data = (_getResponseWithMostS = (0, _utils.getResponseWithMostSevereStatusCode)(requestData)) !== null && _getResponseWithMostS !== void 0 ? _getResponseWithMostS : requestError;
  const isLoading = loading || requestInFlight;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fetchingAutocompleteEntities ? /*#__PURE__*/_react.default.createElement("div", {
    css: styles.requestProgressBarContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    css: styles.fullHeightPanel,
    direction: isVerticalLayout ? 'vertical' : 'horizontal',
    onPanelWidthChange: sizes => onPanelSizeChange(sizes),
    "data-test-subj": "consoleEditorContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: firstPanelSize,
    minSize: PANEL_MIN_SIZE,
    tabIndex: 0,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    borderRadius: "none",
    hasShadow: false,
    css: styles.fullHeightPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    grow: true,
    css: [styles.consoleEditorPanel, styles.editorPanelPositioned],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_monaco_editor.MonacoEditor, {
    localStorageValue: currentTextObject.text,
    value: inputEditorValue,
    setValue: setInputEditorValue,
    customParsedRequestsProvider: customParsedRequestsProvider,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 21
    }
  })), !loading && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    paddingSize: "s",
    color: "subdued",
    css: styles.consoleEditorPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "primary",
    "data-test-subj": "clearConsoleInput",
    onClick: () => {
      setInputEditorValue('');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('console.editor.clearConsoleInputButton', {
    defaultMessage: 'Clear this input'
  }))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    css: styles.resizerButton,
    "aria-label": _i18n.i18n.translate('console.editor.adjustPanelSizeAriaLabel', {
      defaultMessage: "Press left/right to adjust panels' sizes"
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: secondPanelSize,
    minSize: PANEL_MIN_SIZE,
    tabIndex: 0,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    borderRadius: "none",
    hasShadow: false,
    css: styles.fullHeightPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: [styles.consoleEditorPanel, styles.outputPanelCentered],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 17
    }
  }, data ? /*#__PURE__*/_react.default.createElement(_monaco_editor_output.MonacoEditorOutput, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 21
    }
  }) : isLoading ? /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.OutputPanelEmptyState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 21
    }
  })), (data || isLoading) && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    paddingSize: "s",
    css: [styles.consoleEditorPanel, styles.actionsPanelWithBackground],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "primary",
    "data-test-subj": "clearConsoleOutput",
    onClick: () => dispatch({
      type: 'cleanRequest',
      payload: undefined
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 25
    }
  }, _i18n.i18n.translate('console.editor.clearConsoleOutputButton', {
    defaultMessage: 'Clear this output'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_components.NetworkRequestStatusBar, {
    requestInProgress: requestInFlight,
    requestResult: data ? {
      method: data.request.method.toUpperCase(),
      endpoint: data.request.path,
      statusCode: data.response.statusCode,
      statusText: data.response.statusText,
      timeElapsedMs: data.response.timeMs
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 25
    }
  })))))))));
});