"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimlaneServiceConfigurationSchema = exports.SwimlaneServiceConfiguration = exports.SwimlaneSecretsConfigurationSchema = exports.SwimlaneSecretsConfiguration = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorParamsSchema = exports.ConfigMappingSchema = exports.ConfigMapping = exports.ConfigMapSchema = exports.ConfigMap = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ConfigMap = exports.ConfigMap = {
  id: _zod.z.string(),
  key: _zod.z.string(),
  name: _zod.z.string(),
  fieldType: _zod.z.string()
};
const ConfigMapSchema = exports.ConfigMapSchema = _zod.z.object(ConfigMap).strict();
const ConfigMapping = exports.ConfigMapping = {
  ruleNameConfig: ConfigMapSchema.nullable().default(null),
  alertIdConfig: ConfigMapSchema.nullable().default(null),
  caseIdConfig: ConfigMapSchema.nullable().default(null),
  caseNameConfig: ConfigMapSchema.nullable().default(null),
  commentsConfig: ConfigMapSchema.nullable().default(null),
  severityConfig: ConfigMapSchema.nullable().default(null),
  descriptionConfig: ConfigMapSchema.nullable().default(null)
};
const ConfigMappingSchema = exports.ConfigMappingSchema = _zod.z.object(ConfigMapping).strict();
const SwimlaneServiceConfiguration = exports.SwimlaneServiceConfiguration = {
  apiUrl: _zod.z.string(),
  appId: _zod.z.string(),
  connectorType: _zod.z.enum(['all', 'alerts', 'cases']),
  mappings: ConfigMappingSchema
};
const SwimlaneServiceConfigurationSchema = exports.SwimlaneServiceConfigurationSchema = _zod.z.object(SwimlaneServiceConfiguration).strict();
const SwimlaneSecretsConfiguration = exports.SwimlaneSecretsConfiguration = {
  apiToken: _zod.z.string()
};
const SwimlaneSecretsConfigurationSchema = exports.SwimlaneSecretsConfigurationSchema = _zod.z.object(SwimlaneSecretsConfiguration).strict();
const SwimlaneFields = {
  alertId: _zod.z.string().nullable().default(null),
  ruleName: _zod.z.string().nullable().default(null),
  caseId: _zod.z.string().nullable().default(null),
  caseName: _zod.z.string().nullable().default(null),
  severity: _zod.z.string().nullable().default(null),
  description: _zod.z.string().nullable().default(null)
};
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _zod.z.object({
  incident: _zod.z.object({
    ...SwimlaneFields,
    externalId: _zod.z.string().nullable().default(null)
  }).strict(),
  comments: _zod.z.array(_zod.z.object({
    comment: _zod.z.string(),
    commentId: _zod.z.string()
  }).strict()).nullable().default(null)
}).strict();
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _zod.z.discriminatedUnion('subAction', [_zod.z.object({
  subAction: _zod.z.literal('pushToService'),
  subActionParams: ExecutorSubActionPushParamsSchema
}).strict()]);