"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsIndexSchedulerTaskFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _scheduler_task_runner = require("./scheduler_task_runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AnalyticsIndexSchedulerTaskFactory {
  constructor({
    logger,
    getUnsecureSavedObjectsClient,
    analyticsConfig,
    getTaskManager,
    getESClient
  }) {
    (0, _defineProperty2.default)(this, "analyticsConfig", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "getUnsecureSavedObjectsClient", void 0);
    (0, _defineProperty2.default)(this, "getTaskManager", void 0);
    (0, _defineProperty2.default)(this, "getESClient", void 0);
    this.analyticsConfig = analyticsConfig;
    this.logger = logger;
    this.getUnsecureSavedObjectsClient = getUnsecureSavedObjectsClient;
    this.getTaskManager = getTaskManager;
    this.getESClient = getESClient;
  }
  create() {
    return new _scheduler_task_runner.SchedulerTaskRunner({
      analyticsConfig: this.analyticsConfig,
      logger: this.logger,
      getUnsecureSavedObjectsClient: this.getUnsecureSavedObjectsClient,
      getTaskManager: this.getTaskManager,
      getESClient: this.getESClient
    });
  }
}
exports.AnalyticsIndexSchedulerTaskFactory = AnalyticsIndexSchedulerTaskFactory;