"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../utils");
var _use_push_to_service = require("../use_push_to_service");
var _kibana = require("../../common/lib/kibana");
var _push_button = require("./push_button");
var _push_callouts = require("./push_callouts");
var _connectors_form = require("./connectors_form");
var _fields_preview_form = require("../connectors/fields_preview_form");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/edit_connector/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditConnector = exports.EditConnector = /*#__PURE__*/_react.default.memo(({
  caseData,
  caseConnectors,
  supportedActionConnectors,
  isLoading,
  onSubmit
}) => {
  var _caseActionConnector$;
  const caseConnectorFields = caseData.connector.fields;
  const caseActionConnector = (0, _utils.getConnectorById)(caseData.connector.id, supportedActionConnectors);
  const isValidConnector = !!caseActionConnector;
  const [isEdit, setIsEdit] = (0, _react.useState)(false);
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canUseConnectors = permissions.connectors && actions.read;
  const onEditClick = (0, _react.useCallback)(() => setIsEdit(true), []);
  const onCancelConnector = (0, _react.useCallback)(() => setIsEdit(false), []);
  const onSubmitConnector = (0, _react.useCallback)(connector => {
    onSubmit(connector);
    setIsEdit(false);
  }, [onSubmit]);
  const connectorWithName = {
    ...caseData.connector,
    name: (0, _fp.isEmpty)(caseActionConnector === null || caseActionConnector === void 0 ? void 0 : caseActionConnector.name) ? caseData.connector.name : (_caseActionConnector$ = caseActionConnector === null || caseActionConnector === void 0 ? void 0 : caseActionConnector.name) !== null && _caseActionConnector$ !== void 0 ? _caseActionConnector$ : ''
  };
  const {
    errorsMsg,
    needsToBePushed,
    hasBeenPushed,
    isLoading: isLoadingPushToService,
    hasPushPermissions,
    hasErrorMessages,
    hasLicenseError,
    handlePushToService
  } = (0, _use_push_to_service.usePushToService)({
    connector: connectorWithName,
    caseConnectors,
    caseId: caseData.id,
    caseStatus: caseData.status,
    isValidConnector
  });
  const disablePushButton = isLoadingPushToService || errorsMsg.length > 0 || !hasPushPermissions || !isValidConnector || !needsToBePushed;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "sidebar-connectors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "spaceBetween",
    responsive: false,
    "data-test-subj": "case-view-edit-connector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "connector-edit-header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  }, i18n.CONNECTORS))), !isLoading && !isEdit && hasPushPermissions && canUseConnectors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "connector-edit",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "connector-edit-button",
    "aria-label": i18n.EDIT_CONNECTOR_ARIA,
    iconType: "pencil",
    onClick: onEditClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "edit-connectors",
    direction: "column",
    alignItems: "stretch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, !isLoading && !isEdit && hasErrorMessages && canUseConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "push-callouts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_push_callouts.PushCallouts, {
    errorsMsg: errorsMsg,
    hasLicenseError: hasLicenseError,
    hasConnectors: supportedActionConnectors.length > 0,
    onEditClick: onEditClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  })), !canUseConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "edit-connector-permissions-error-msg",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG)), canUseConnectors && !isEdit && /*#__PURE__*/_react.default.createElement(_fields_preview_form.ConnectorFieldsPreviewForm, {
    connector: caseActionConnector,
    fields: caseConnectorFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }), canUseConnectors && isEdit && /*#__PURE__*/_react.default.createElement(_connectors_form.ConnectorsForm, {
    caseData: caseData,
    caseConnectors: caseConnectors,
    supportedActionConnectors: supportedActionConnectors,
    isLoading: isLoading,
    onCancel: onCancelConnector,
    onSubmit: onSubmitConnector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }), !hasErrorMessages && !isLoading && !isEdit && hasPushPermissions && canUseConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_push_button.PushButton, {
    hasBeenPushed: hasBeenPushed,
    disabled: disablePushButton,
    isLoading: isLoadingPushToService,
    pushToService: handlePushToService,
    errorsMsg: errorsMsg,
    showTooltip: errorsMsg.length > 0 || !needsToBePushed || !hasPushPermissions,
    connectorName: connectorWithName.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  })))));
});
EditConnector.displayName = 'EditConnector';