"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessDetails = ServerlessDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/service_icons/serverless_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ServerlessDetails({
  serverless
}) {
  var _serverless$functionN, _serverless$faasTrigg;
  if (!serverless) {
    return null;
  }
  const listItems = [];
  if (!!((_serverless$functionN = serverless.functionNames) !== null && _serverless$functionN !== void 0 && _serverless$functionN.length)) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.functionNameLabel', {
        defaultMessage: '{functionNames, plural, =0 {Function name} one {Function name} other {Function names}} ',
        values: {
          functionNames: serverless.functionNames.length
        }
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 9
        }
      }, serverless.functionNames.map((type, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 15
        }
      }, type))))
    });
  }
  if (!!((_serverless$faasTrigg = serverless.faasTriggerTypes) !== null && _serverless$faasTrigg !== void 0 && _serverless$faasTrigg.length)) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.faasTriggerTypeLabel', {
        defaultMessage: '{triggerTypes, plural, =0 {Trigger type} one {Trigger type} other {Trigger types}} ',
        values: {
          triggerTypes: serverless.faasTriggerTypes.length
        }
      }),
      description: /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 9
        }
      }, serverless.faasTriggerTypes.map((type, index) => /*#__PURE__*/_react.default.createElement("li", {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 15
        }
      }, type))))
    });
  }
  if (serverless.hostArchitecture) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.serviceDetails.cloud.architecture', {
        defaultMessage: 'Architecture'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 20
        }
      }, serverless.hostArchitecture)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: listItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 10
    }
  });
}