"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = EmptyPrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _create_custom_link_button = require("./create_custom_link_button");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EmptyPrompt({
  onCreateCustomLinkClick
}) {
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "customLinksEmptyPrompt",
    iconType: "link",
    iconColor: "",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.settings.customLink.emptyPromptTitle', {
      defaultMessage: 'No links found.'
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.settings.customLink.emptyPromptText",
      defaultMessage: "Let's change that! You can add custom links to the Actions menu by the transaction details for each service. Create a helpful link to your company's support portal or open a bug report. Need more ideas? Check out {customLinkDocLinkText}.",
      values: {
        customLinkDocLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmCustomLinkEmptyPromptDocsLink",
          target: "_blank",
          href: docLinks.links.apm.customLinks,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 37,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.apm.settings.customLink.emptyPromptText.customLinkDocLinkText', {
          defaultMessage: 'docs'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 13
      }
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_create_custom_link_button.CreateCustomLinkButton, {
      onClick: onCreateCustomLinkClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 16
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  });
}