"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstanceActionsMenu = InstanceActionsMenu;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/logs-shared-plugin/common");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _agent_name = require("../../../../../../common/agent_name");
var _apm = require("../../../../../../common/es_fields/apm");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _utils = require("../../../../shared/kuery_bar/utils");
var _metric_overview_link = require("../../../../shared/links/apm/metric_overview_link");
var _service_node_metric_overview_link = require("../../../../shared/links/apm/service_node_metric_overview_link");
var _use_instance_details_fetcher = require("../use_instance_details_fetcher");
var _menu_sections = require("./menu_sections");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/service_overview_instances_table/instance_actions_menu/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const POPOVER_WIDTH = '305px';
function InstanceActionsMenu({
  serviceName,
  serviceNodeName,
  kuery,
  onClose
}) {
  var _data$agent;
  const {
    core,
    share
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    data,
    status
  } = (0, _use_instance_details_fetcher.useInstanceDetailsFetcher)({
    serviceName,
    serviceNodeName
  });
  const serviceNodeMetricOverviewHref = (0, _service_node_metric_overview_link.useServiceNodeMetricOverviewHref)({
    serviceName,
    serviceNodeName
  });
  const metricOverviewHref = (0, _metric_overview_link.useMetricOverviewHref)(serviceName);
  const history = (0, _reactRouterDom.useHistory)();
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(share.url);
  const assetDetailsLocator = share.url.locators.get(_common2.ASSET_DETAILS_LOCATOR_ID);
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: POPOVER_WIDTH,
        display: 'flex',
        justifyContent: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }));
  }
  if (!data) {
    return null;
  }
  const handleFilterByInstanceClick = () => {
    onClose();
    (0, _utils.pushNewItemToKueryBar)({
      kuery,
      history,
      key: _apm.SERVICE_NODE_NAME,
      value: serviceNodeName
    });
  };
  const metricsHref = (0, _agent_name.isJavaAgentName)((_data$agent = data.agent) === null || _data$agent === void 0 ? void 0 : _data$agent.name) ? serviceNodeMetricOverviewHref : metricOverviewHref;
  const sections = (0, _menu_sections.getMenuSections)({
    instanceDetails: data,
    basePath: core.http.basePath,
    onFilterByInstanceClick: handleFilterByInstanceClick,
    metricsHref,
    logsLocator,
    assetDetailsLocator
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: POPOVER_WIDTH
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, sections.map((section, idx) => {
    const isLastSection = idx !== sections.length - 1;
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, section.map(item => /*#__PURE__*/_react.default.createElement(_public.Section, {
      key: item.key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 15
      }
    }, item.title && /*#__PURE__*/_react.default.createElement(_public.SectionTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 32
      }
    }, item.title), item.subtitle && /*#__PURE__*/_react.default.createElement(_public.SectionSubtitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 35
      }
    }, item.subtitle), /*#__PURE__*/_react.default.createElement(_public.SectionLinks, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 17
      }
    }, item.actions.map(action => /*#__PURE__*/_react.default.createElement(_public.SectionLink, {
      key: action.key,
      label: action.label,
      href: action.href,
      onClick: action.onClick,
      color: "primary",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 21
      }
    }))))), isLastSection && /*#__PURE__*/_react.default.createElement(_public.ActionMenuDivider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 31
      }
    }));
  }));
}