"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceContents = ServiceContents;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _anomaly_detection = require("./anomaly_detection");
var _stats_list = require("./stats_list");
var _use_time_range = require("../../../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/popover/service_contents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @elastic/eui/href-or-on-click */
const INITIAL_STATE = {
  currentPeriod: {},
  previousPeriod: undefined
};
function ServiceContents({
  onFocusClick,
  elementData,
  environment,
  kuery
}) {
  const nodeData = elementData;
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/service-map', '/services/{serviceName}/service-map', '/mobile-services/{serviceName}/service-map');
  if (!('rangeFrom' in query && 'rangeTo' in query) || !query.rangeFrom || !query.rangeTo) {
    throw new Error('Expected rangeFrom and rangeTo to be set');
  }
  const {
    rangeFrom,
    rangeTo,
    comparisonEnabled,
    offset
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const serviceName = nodeData.id;
  const serviceGroup = 'serviceGroup' in query && query.serviceGroup || '';
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end) {
      return callApmApi('GET /internal/apm/service-map/service/{serviceName}', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            start,
            end,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          }
        }
      });
    }
  }, [environment, serviceName, start, end, offset, comparisonEnabled]);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const detailsUrl = apmRouter.link('/services/{serviceName}', {
    path: {
      serviceName
    },
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      comparisonEnabled,
      serviceGroup
    }
  });
  const focusUrl = apmRouter.link('/services/{serviceName}/service-map', {
    path: {
      serviceName
    },
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      serviceGroup,
      comparisonEnabled
    }
  });
  const {
    serviceAnomalyStats
  } = nodeData;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, serviceAnomalyStats && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_anomaly_detection.AnomalyDetection, {
    serviceName: serviceName,
    serviceAnomalyStats: serviceAnomalyStats,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_stats_list.StatsList, {
    data: data,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmServiceContentsServiceDetailsButton",
    href: detailsUrl,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.serviceDetailsButtonText', {
    defaultMessage: 'Service Details'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmServiceContentsFocusMapButton",
    color: "success",
    href: focusUrl,
    onClick: onFocusClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.focusMapButtonText', {
    defaultMessage: 'Focus map'
  }))));
}