"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilterQueryUpdates = exports.FilterQueryContextProvider = exports.FilterQueryContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _use_aiops_app_context = require("./use_aiops_app_context");
var _use_reload = require("./use_reload");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/hooks/use_filters_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilterQueryContext = exports.FilterQueryContext = /*#__PURE__*/(0, _react.createContext)({
  get filters() {
    throw new Error('FilterQueryContext is not initialized');
  },
  get query() {
    throw new Error('FilterQueryContext is not initialized');
  },
  get timeRange() {
    throw new Error('FilterQueryContext is not initialized');
  },
  get searchBounds() {
    throw new Error('FilterQueryContext is not initialized');
  },
  get interval() {
    throw new Error('FilterQueryContext is not initialized');
  }
});

/**
 * Helper context to provide the latest
 *   - filter
 *   - query
 *   - time range
 * from the data plugin.
 * Also merges custom filters and queries provided with an input.
 *
 * @param children
 * @constructor
 */
const FilterQueryContextProvider = ({
  children,
  timeRange,
  filtersApi
}) => {
  const {
    data: {
      query: {
        filterManager,
        queryString,
        timefilter
      }
    },
    uiSettings
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const reload = (0, _use_reload.useReload)();
  const [resultFilters, setResultFilter] = (0, _react.useState)(filterManager.getFilters());
  const [resultQuery, setResultQuery] = (0, _react.useState)(queryString.getQuery());
  const timeRangeUpdates = (0, _mlDatePicker.useTimeRangeUpdates)(false);
  (0, _react.useEffect)(() => {
    // Embeddable API exposes not just filters from query bar, but also
    // filters from other dashboard controls
    // so if that information is available, we should prioritize it
    if (filtersApi !== null && filtersApi !== void 0 && filtersApi.filters$) {
      const sub = filtersApi === null || filtersApi === void 0 ? void 0 : filtersApi.filters$.subscribe(() => {
        var _filtersApi$filters$$;
        setResultFilter((_filtersApi$filters$$ = filtersApi === null || filtersApi === void 0 ? void 0 : filtersApi.filters$.getValue()) !== null && _filtersApi$filters$$ !== void 0 ? _filtersApi$filters$$ : []);
      });
      return () => {
        sub.unsubscribe();
      };
    } else {
      const sub = filterManager.getUpdates$().subscribe(() => {
        setResultFilter(filterManager.getFilters());
      });
      return () => {
        sub.unsubscribe();
      };
    }
  }, [filterManager, filtersApi]);
  (0, _react.useEffect)(() => {
    const sub = queryString.getUpdates$().subscribe(() => {
      setResultQuery(queryString.getQuery());
    });
    return () => {
      sub.unsubscribe();
    };
  }, [queryString]);
  const resultTimeRange = (0, _react.useMemo)(() => {
    return timeRange !== null && timeRange !== void 0 ? timeRange : timeRangeUpdates;
  }, [timeRangeUpdates, timeRange]);

  /**
   * Search bounds derived from the time range.
   * Has to be updated on reload, in case relative time range is used.
   */
  const bounds = (0, _react.useMemo)(() => {
    return timefilter.timefilter.calculateBounds(resultTimeRange);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [resultTimeRange, timefilter, reload.refreshTimestamp]);
  const timeBucketsInterval = (0, _react.useMemo)(() => {
    timeBuckets.setInterval('auto');
    timeBuckets.setBounds(bounds);
    return timeBuckets.getInterval();
  }, [bounds, timeBuckets]);

  /**
   * Search bounds rounded to the time buckets interval.
   */
  const searchBounds = (0, _react.useMemo)(() => {
    return (0, _mlTimeBuckets.getBoundsRoundedToInterval)(bounds, timeBucketsInterval, false);
  }, [bounds, timeBucketsInterval]);
  return /*#__PURE__*/_react.default.createElement(FilterQueryContext.Provider, {
    value: {
      filters: resultFilters,
      query: resultQuery,
      timeRange: resultTimeRange,
      searchBounds,
      interval: timeBucketsInterval.expression
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, children);
};
exports.FilterQueryContextProvider = FilterQueryContextProvider;
const useFilterQueryUpdates = () => {
  return (0, _react.useContext)(FilterQueryContext);
};
exports.useFilterQueryUpdates = useFilterQueryUpdates;