"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormControls = exports.ChangePointChartInitializer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _change_point_detection_context = require("../../components/change_point_detection/change_point_detection_context");
var _constants = require("../../components/change_point_detection/constants");
var _function_picker = require("../../components/change_point_detection/function_picker");
var _max_series_control = require("../../components/change_point_detection/max_series_control");
var _metric_field_selector = require("../../components/change_point_detection/metric_field_selector");
var _partitions_selector = require("../../components/change_point_detection/partitions_selector");
var _split_field_selector = require("../../components/change_point_detection/split_field_selector");
var _view_type_selector = require("../../components/change_point_detection/view_type_selector");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _use_filters_query = require("../../hooks/use_filters_query");
var _const = require("./const");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294606429848706/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/change_point_chart/change_point_chart_initializer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChangePointChartInitializer = ({
  initialInput,
  onCreate,
  onCancel
}) => {
  var _initialInput$dataVie, _initialInput$viewTyp;
  const appContextValue = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    data: {
      dataViews
    },
    unifiedSearch: {
      ui: {
        IndexPatternSelect
      }
    }
  } = appContextValue;
  const datePickerDeps = {
    ...(0, _lodash.pick)(appContextValue, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS
  };
  const [dataViewId, setDataViewId] = (0, _react.useState)((_initialInput$dataVie = initialInput === null || initialInput === void 0 ? void 0 : initialInput.dataViewId) !== null && _initialInput$dataVie !== void 0 ? _initialInput$dataVie : '');
  const [viewType, setViewType] = (0, _react.useState)((_initialInput$viewTyp = initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewType) !== null && _initialInput$viewTyp !== void 0 ? _initialInput$viewTyp : 'charts');
  const [formInput, setFormInput] = (0, _react.useState)((0, _lodash.pick)(initialInput !== null && initialInput !== void 0 ? initialInput : {}, ['fn', 'metricField', 'splitField', 'maxSeriesToPlot', 'partitions']));
  const [isFormValid, setIsFormValid] = (0, _react.useState)(true);
  const updatedProps = (0, _react.useMemo)(() => {
    return {
      ...formInput,
      viewType,
      title: (0, _mlIsPopulatedObject.isPopulatedObject)(formInput) ? _i18n.i18n.translate('xpack.aiops.changePointDetection.attachmentTitle', {
        defaultMessage: 'Change point: {function}({metric}){splitBy}',
        values: {
          function: formInput.fn,
          metric: formInput === null || formInput === void 0 ? void 0 : formInput.metricField,
          splitBy: formInput !== null && formInput !== void 0 && formInput.splitField ? _i18n.i18n.translate('xpack.aiops.changePointDetection.splitByTitle', {
            defaultMessage: ' split by "{splitField}"',
            values: {
              splitField: formInput.splitField
            }
          }) : ''
        }
      }) : '',
      dataViewId
    };
  }, [formInput, dataViewId, viewType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: 'changePointConfig',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.modalTitle",
    defaultMessage: "Change point detection configuration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "aiopsChangePointDetectionControls",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_view_type_selector.ViewTypeSelector, {
    value: viewType,
    onChange: setViewType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.aiops.embeddableChangePointChart.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
    autoFocus: !dataViewId,
    fullWidth: true,
    compressed: true,
    indexPatternId: dataViewId,
    placeholder: _i18n.i18n.translate('xpack.aiops.embeddableChangePointChart.dataViewSelectorPlaceholder', {
      defaultMessage: 'Select data view'
    }),
    onChange: newId => {
      setDataViewId(newId !== null && newId !== void 0 ? newId : '');
    },
    "data-test-subj": "aiopsChangePointChartEmbeddableDataViewSelector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViews: dataViews,
    dataViewId: dataViewId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(FormControls, {
    formInput: formInput,
    onChange: setFormInput,
    onValidationChange: setIsFormValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 19
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "aiopsChangePointChartsInitializerCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "aiopsChangePointChartsInitializerConfirmButton",
    isDisabled: !isFormValid || !dataViewId,
    onClick: onCreate.bind(null, updatedProps),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddableChangePointChart.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm configurations",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }))))));
};
exports.ChangePointChartInitializer = ChangePointChartInitializer;
const FormControls = ({
  formInput,
  onChange,
  onValidationChange
}) => {
  var _formInput$partitions, _formInput$partitions2;
  const {
    metricFieldOptions,
    splitFieldsOptions
  } = (0, _change_point_detection_context.useChangePointDetectionControlsContext)();
  const prevMetricFieldOptions = (0, _usePrevious.default)(metricFieldOptions);
  const enableSearch = (0, _react.useMemo)(() => {
    const field = splitFieldsOptions.find(v => v.name === (formInput === null || formInput === void 0 ? void 0 : formInput.splitField));
    if (field && field.esTypes) {
      var _field$esTypes;
      return (_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.some(t => t === _fieldTypes.ES_FIELD_TYPES.KEYWORD);
    } else {
      return false;
    }
  }, [splitFieldsOptions, formInput === null || formInput === void 0 ? void 0 : formInput.splitField]);
  (0, _react.useEffect)(function setDefaultOnDataViewChange() {
    var _metricFieldOptions$2;
    if (!(0, _mlIsPopulatedObject.isPopulatedObject)(formInput)) {
      var _metricFieldOptions$;
      onChange({
        fn: _constants.DEFAULT_AGG_FUNCTION,
        metricField: (_metricFieldOptions$ = metricFieldOptions[0]) === null || _metricFieldOptions$ === void 0 ? void 0 : _metricFieldOptions$.name,
        splitField: undefined,
        partitions: undefined,
        maxSeriesToPlot: _const.DEFAULT_SERIES
      });
      return;
    }
    if (!prevMetricFieldOptions || metricFieldOptions === prevMetricFieldOptions) return;
    onChange({
      fn: formInput.fn,
      metricField: (_metricFieldOptions$2 = metricFieldOptions[0]) === null || _metricFieldOptions$2 === void 0 ? void 0 : _metricFieldOptions$2.name,
      splitField: undefined,
      partitions: undefined,
      maxSeriesToPlot: formInput.maxSeriesToPlot
    });
  }, [metricFieldOptions, prevMetricFieldOptions, formInput, onChange]);
  const updateCallback = (0, _react.useCallback)(update => {
    onChange({
      ...formInput,
      ...update
    });
  }, [formInput, onChange]);
  if (!(0, _mlIsPopulatedObject.isPopulatedObject)(formInput)) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.embeddableChangePointChart.functionLabel",
      defaultMessage: "Function",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_function_picker.FunctionPicker, {
    value: formInput.fn,
    onChange: v => updateCallback({
      fn: v
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_metric_field_selector.MetricFieldSelector, {
    inline: false,
    value: formInput.metricField,
    onChange: v => updateCallback({
      metricField: v
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_split_field_selector.SplitFieldSelector, {
    inline: false,
    value: formInput.splitField,
    onChange: v => updateCallback({
      splitField: v
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 7
    }
  }), formInput.splitField ? /*#__PURE__*/_react.default.createElement(_partitions_selector.PartitionsSelector, {
    value: (_formInput$partitions = formInput.partitions) !== null && _formInput$partitions !== void 0 ? _formInput$partitions : [],
    onChange: v => updateCallback({
      partitions: v
    }),
    splitField: formInput.splitField,
    enableSearch: enableSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_max_series_control.MaxSeriesControl, {
    inline: false,
    disabled: !!(formInput !== null && formInput !== void 0 && (_formInput$partitions2 = formInput.partitions) !== null && _formInput$partitions2 !== void 0 && _formInput$partitions2.length),
    value: formInput.maxSeriesToPlot,
    onChange: v => updateCallback({
      maxSeriesToPlot: v
    }),
    onValidationChange: result => onValidationChange(result === null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 7
    }
  }));
};
exports.FormControls = FormControls;